/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import com.itextpdf.styledxmlparser.resolver.resource.UriEncodeUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriResolver {
    private URL baseUrl;
    private boolean isLocalBaseUri;

    public UriResolver(String baseUri) {
        this.resolveBaseUrlOrPath(baseUri);
    }

    public String getBaseUri() {
        return this.baseUrl.toExternalForm();
    }

    public URL resolveAgainstBaseUri(String uriString) throws MalformedURLException {
        URL resolvedUrl = null;
        uriString = uriString.trim();
        String scheme = this.getUriStringScheme(uriString);
        uriString = UriEncodeUtil.encode(uriString);
        if (this.isLocalBaseUri && !(uriString = uriString.replaceFirst("/*\\\\*", "")).startsWith("file:")) {
            try {
                Path path = Paths.get(uriString, new String[0]);
                if (path.isAbsolute()) {
                    resolvedUrl = path.toUri().toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resolvedUrl == null) {
            resolvedUrl = new URL(this.baseUrl, uriString);
        }
        return resolvedUrl;
    }

    private void resolveBaseUrlOrPath(String base) {
        base = base.trim();
        String scheme = this.getUriStringScheme(base);
        base = UriEncodeUtil.encode(base);
        this.baseUrl = this.baseUriAsUrl(base);
        if (this.baseUrl == null) {
            this.baseUrl = this.uriAsFileUrl(base);
        }
        if (this.baseUrl == null) {
            throw new StyledXMLParserException(MessageFormatUtil.format((String)"Invalid base URI: {0}", (Object[])new Object[]{base}));
        }
    }

    private URL baseUriAsUrl(String baseUriString) {
        URL baseAsUrl = null;
        try {
            URI baseUri = new URI(baseUriString);
            if (baseUri.isAbsolute()) {
                baseAsUrl = baseUri.toURL();
                if ("file".equals(baseUri.getScheme())) {
                    this.isLocalBaseUri = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsUrl;
    }

    private URL uriAsFileUrl(String baseUriString) {
        URL baseAsFileUrl = null;
        try {
            Path path = Paths.get(baseUriString, new String[0]);
            baseAsFileUrl = path.toAbsolutePath().normalize().toUri().toURL();
            this.isLocalBaseUri = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsFileUrl;
    }

    private String getUriStringScheme(String uriString) {
        String result = null;
        Matcher matcher = Pattern.compile("^[a-zA-Z]([a-zA-Z]|\\d|\\+|-|\\.)*:").matcher(uriString);
        if (matcher.find()) {
            result = matcher.group().substring(0, matcher.group().indexOf(58));
        } else if (null != this.baseUrl) {
            try {
                result = this.baseUrl.toURI().getScheme();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isLocalBaseUri() {
        return this.isLocalBaseUri;
    }
}

