/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.styledxmlparser.resolver.resource.ReadingByteLimitException;
import java.io.IOException;
import java.io.InputStream;

class LimitedInputStream
extends InputStream {
    private boolean isStreamRead;
    private boolean isLimitViolated;
    private long readingByteLimit;
    private InputStream inputStream;

    public LimitedInputStream(InputStream inputStream, long readingByteLimit) {
        if (readingByteLimit < 0L) {
            throw new IllegalArgumentException("The reading byte limit argument must not be less than zero.");
        }
        this.isStreamRead = false;
        this.isLimitViolated = false;
        this.inputStream = inputStream;
        this.readingByteLimit = readingByteLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.isStreamRead) {
            return -1;
        }
        if (this.isLimitViolated) {
            throw new ReadingByteLimitException();
        }
        int nextByte = this.inputStream.read();
        --this.readingByteLimit;
        this.checkReadingByteLimit(nextByte);
        return nextByte;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int numberOfReadingBytes;
        if (this.isStreamRead) {
            return -1;
        }
        if (this.isLimitViolated) {
            throw new ReadingByteLimitException();
        }
        if ((long)b.length > this.readingByteLimit) {
            byte[] validArray = this.readingByteLimit == 0L ? new byte[1] : new byte[(int)this.readingByteLimit];
            numberOfReadingBytes = this.inputStream.read(validArray);
            if (numberOfReadingBytes != -1) {
                System.arraycopy(validArray, 0, b, 0, numberOfReadingBytes);
            }
        } else {
            numberOfReadingBytes = this.inputStream.read(b);
        }
        this.readingByteLimit -= (long)numberOfReadingBytes;
        this.checkReadingByteLimit(numberOfReadingBytes);
        return numberOfReadingBytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isStreamRead) {
            return -1;
        }
        if (this.isLimitViolated) {
            throw new ReadingByteLimitException();
        }
        if ((long)len > this.readingByteLimit) {
            len = this.readingByteLimit == 0L ? 1 : (int)this.readingByteLimit;
        }
        int numberOfReadingBytes = this.inputStream.read(b, off, len);
        this.readingByteLimit -= (long)numberOfReadingBytes;
        this.checkReadingByteLimit(numberOfReadingBytes);
        return numberOfReadingBytes;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void checkReadingByteLimit(int byteValue) throws ReadingByteLimitException {
        if (byteValue == -1) {
            this.isStreamRead = true;
        } else if (this.readingByteLimit < 0L) {
            this.isLimitViolated = true;
            throw new ReadingByteLimitException();
        }
    }
}

