/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;

public final class CssTypesValidationUtils {
    private static final String[] ANGLE_MEASUREMENTS_VALUES = new String[]{"deg", "grad", "rad"};
    private static final String[] RELATIVE_MEASUREMENTS_VALUES = new String[]{"%", "em", "ex", "rem"};

    public static boolean isAngleValue(String value) {
        if (value == null) {
            return false;
        }
        for (String metricPostfix : ANGLE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(metricPostfix) || !CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - metricPostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBase64Data(String data) {
        return data.matches("^data:([^\\s]*);base64,([^\\s]*)");
    }

    public static boolean isColorProperty(String value) {
        return value.startsWith("rgb(") || value.startsWith("rgba(") || value.startsWith("#") || WebColors.NAMES.containsKey((Object)value.toLowerCase()) || "transparent".equals(value);
    }

    public static boolean isEmValue(String value) {
        return value != null && value.endsWith("em") && CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - "em".length()).trim());
    }

    public static boolean isExValue(String value) {
        return value != null && value.endsWith("ex") && CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - "ex".length()).trim());
    }

    public static boolean isMetricValue(String value) {
        if (value == null) {
            return false;
        }
        for (String metricPostfix : CommonCssConstants.METRIC_MEASUREMENTS_VALUES) {
            if (!value.endsWith(metricPostfix) || !CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - metricPostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegativeValue(String value) {
        if (value == null) {
            return false;
        }
        if (CssTypesValidationUtils.isNumericValue(value) || CssTypesValidationUtils.isRelativeValue(value)) {
            return value.startsWith("-");
        }
        return false;
    }

    public static boolean isNumericValue(String value) {
        return value != null && (value.matches("^[-+]?\\d\\d*\\.\\d*$") || value.matches("^[-+]?\\d\\d*$") || value.matches("^[-+]?\\.\\d\\d*$"));
    }

    public static boolean isPercentageValue(String value) {
        return value != null && value.endsWith("%") && CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - "%".length()).trim());
    }

    public static boolean isRelativeValue(String value) {
        if (value == null) {
            return false;
        }
        for (String relativePostfix : RELATIVE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(relativePostfix) || !CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - relativePostfix.length()).trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemValue(String value) {
        return value != null && value.endsWith("rem") && CssTypesValidationUtils.isNumericValue(value.substring(0, value.length() - "rem".length()).trim());
    }

    public static boolean isValidNumericValue(String value) {
        if (value == null || value.contains(" ")) {
            return false;
        }
        return CssTypesValidationUtils.isRelativeValue(value) || CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isNumericValue(value);
    }

    public static boolean isInitialOrInheritOrUnset(String value) {
        return "initial".equals(value) || "inherit".equals(value) || "unset".equals(value);
    }

    private CssTypesValidationUtils() {
    }
}

