/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.validate;

import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.validate.ICssDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.ArrayDataTypeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBackgroundValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssBlendModeValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssColorValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssEnumValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssNumericValueValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssQuotesValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.datatype.CssTransformValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.MultiTypeDeclarationValidator;
import com.itextpdf.styledxmlparser.css.validate.impl.declaration.SingleTypeDeclarationValidator;
import java.util.HashMap;
import java.util.Map;

public class CssDeclarationValidationMaster {
    private static final Map<String, ICssDeclarationValidator> DEFAULT_VALIDATORS;

    private CssDeclarationValidationMaster() {
    }

    public static boolean checkDeclaration(CssDeclaration declaration) {
        ICssDeclarationValidator validator = DEFAULT_VALIDATORS.get(declaration.getProperty());
        return validator == null || validator.isValid(declaration);
    }

    static {
        MultiTypeDeclarationValidator colorCommonValidator = new MultiTypeDeclarationValidator(new CssEnumValidator("transparent", "initial", "inherit", "currentcolor"), new CssColorValidator());
        DEFAULT_VALIDATORS = new HashMap<String, ICssDeclarationValidator>();
        DEFAULT_VALIDATORS.put("background-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-bottom-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-top-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-left-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-right-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("float", new SingleTypeDeclarationValidator(new CssEnumValidator("left", "right", "none", "inherit", "center")));
        DEFAULT_VALIDATORS.put("page-break-before", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("page-break-after", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("quotes", new MultiTypeDeclarationValidator(new CssEnumValidator("initial", "inherit", "none"), new CssQuotesValidator()));
        DEFAULT_VALIDATORS.put("transform", new SingleTypeDeclarationValidator(new CssTransformValidator()));
        CssEnumValidator enumValidator = new CssEnumValidator("larger", "smaller");
        enumValidator.addAllowedValues(CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.keySet());
        DEFAULT_VALIDATORS.put("font-size", new MultiTypeDeclarationValidator(new CssNumericValueValidator(true, false), enumValidator));
        DEFAULT_VALIDATORS.put("word-spacing", new SingleTypeDeclarationValidator(new CssNumericValueValidator(false, true)));
        DEFAULT_VALIDATORS.put("letter-spacing", new SingleTypeDeclarationValidator(new CssNumericValueValidator(false, true)));
        DEFAULT_VALIDATORS.put("text-indent", new SingleTypeDeclarationValidator(new CssNumericValueValidator(true, false)));
        DEFAULT_VALIDATORS.put("line-height", new SingleTypeDeclarationValidator(new CssNumericValueValidator(true, true)));
        DEFAULT_VALIDATORS.put("background-repeat", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-repeat")));
        DEFAULT_VALIDATORS.put("background-image", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-image")));
        DEFAULT_VALIDATORS.put("background-position-x", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-x")));
        DEFAULT_VALIDATORS.put("background-position-y", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-position-y")));
        DEFAULT_VALIDATORS.put("background-size", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-size")));
        DEFAULT_VALIDATORS.put("background-clip", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-clip")));
        DEFAULT_VALIDATORS.put("background-origin", new SingleTypeDeclarationValidator(new CssBackgroundValidator("background-origin")));
        DEFAULT_VALIDATORS.put("background-blend-mode", new SingleTypeDeclarationValidator(new ArrayDataTypeValidator(new CssBlendModeValidator())));
    }
}

