/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssGradientUtil;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundShorthandResolver
implements IShorthandResolver {
    private static final int UNDEFINED_TYPE = -1;
    private static final int BACKGROUND_COLOR_TYPE = 0;
    private static final int BACKGROUND_IMAGE_TYPE = 1;
    private static final int BACKGROUND_POSITION_TYPE = 2;
    private static final int BACKGROUND_POSITION_OR_SIZE_TYPE = 3;
    private static final int BACKGROUND_REPEAT_TYPE = 4;
    private static final int BACKGROUND_ORIGIN_OR_CLIP_TYPE = 5;
    private static final int BACKGROUND_CLIP_TYPE = 6;
    private static final int BACKGROUND_ATTACHMENT_TYPE = 7;

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if ("initial".equals(shorthandExpression) || "inherit".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("background-color", shorthandExpression), new CssDeclaration("background-image", shorthandExpression), new CssDeclaration("background-position", shorthandExpression), new CssDeclaration("background-size", shorthandExpression), new CssDeclaration("background-repeat", shorthandExpression), new CssDeclaration("background-origin", shorthandExpression), new CssDeclaration("background-clip", shorthandExpression), new CssDeclaration("background-attachment", shorthandExpression));
        }
        List<String> props = CssUtils.extractShorthandProperties(shorthandExpression).get(0);
        String[] resolvedProps = new String[8];
        boolean slashEncountered = false;
        for (String value : props) {
            int slashCharInd = value.indexOf(47);
            if (slashCharInd > 0 && !value.contains("url(")) {
                slashEncountered = true;
                String value1 = value.substring(0, slashCharInd);
                String value2 = value.substring(slashCharInd + 1, value.length());
                this.putPropertyBasedOnType(this.resolvePropertyType(value1), value1, resolvedProps, false);
                this.putPropertyBasedOnType(this.resolvePropertyType(value2), value2, resolvedProps, true);
                continue;
            }
            this.putPropertyBasedOnType(this.resolvePropertyType(value), value, resolvedProps, slashEncountered);
        }
        for (int i = 0; i < resolvedProps.length; ++i) {
            if (resolvedProps[i] != null) continue;
            resolvedProps[i] = "initial";
        }
        List<CssDeclaration> cssDeclarations = Arrays.asList(new CssDeclaration("background-color", resolvedProps[0]), new CssDeclaration("background-image", resolvedProps[1]), new CssDeclaration("background-position", resolvedProps[2]), new CssDeclaration("background-size", resolvedProps[3]), new CssDeclaration("background-repeat", resolvedProps[4]), new CssDeclaration("background-origin", resolvedProps[5]), new CssDeclaration("background-clip", resolvedProps[6]), new CssDeclaration("background-attachment", resolvedProps[7]));
        return cssDeclarations;
    }

    private int resolvePropertyType(String value) {
        if (value.contains("url(") || CssGradientUtil.isCssLinearGradientValue(value) || "none".equals(value)) {
            return 1;
        }
        if (CommonCssConstants.BACKGROUND_REPEAT_VALUES.contains(value)) {
            return 4;
        }
        if (CommonCssConstants.BACKGROUND_ATTACHMENT_VALUES.contains(value)) {
            return 7;
        }
        if (CommonCssConstants.BACKGROUND_POSITION_VALUES.contains(value)) {
            return 2;
        }
        if (CssUtils.isNumericValue(value) || CssUtils.isMetricValue(value) || CssUtils.isRelativeValue(value)) {
            return 3;
        }
        if (CommonCssConstants.BACKGROUND_SIZE_VALUES.contains(value)) {
            return 3;
        }
        if (CssUtils.isColorProperty(value)) {
            return 0;
        }
        if (CommonCssConstants.BACKGROUND_ORIGIN_OR_CLIP_VALUES.contains(value)) {
            return 5;
        }
        return -1;
    }

    private void putPropertyBasedOnType(int type, String value, String[] resolvedProps, boolean slashEncountered) {
        if (type == -1) {
            Logger logger = LoggerFactory.getLogger(BackgroundShorthandResolver.class);
            logger.error(MessageFormatUtil.format((String)"Was not able to define one of the background CSS shorthand properties: {0}", (Object[])new Object[]{value}));
            return;
        }
        if (type == 3 && !slashEncountered) {
            type = 2;
        }
        if (type == 5 && resolvedProps[5] != null) {
            type = 6;
        }
        if ((type == 3 || type == 2) && resolvedProps[type] != null) {
            int n = type;
            resolvedProps[n] = resolvedProps[n] + " " + value;
        } else {
            resolvedProps[type] = value;
        }
    }
}

