/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.runner.Description;

class LogListenerHelper {
    LogListenerHelper() {
    }

    public static <T extends Annotation> T getTestAnnotation(Description description, Class<T> annotationClass) {
        Annotation annotation = description.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = description.getTestClass().getAnnotation(annotationClass);
        }
        return (T)annotation;
    }

    public static void failWrongMessageCount(int expected, int actual, String messageTemplate, Description description) {
        Assert.fail((String)MessageFormat.format("{0}:{1} Expected to find {2}, but found {3} messages with the following content: \"{4}\"", description.getClassName(), description.getMethodName(), expected, actual, messageTemplate));
    }

    public static void failWrongTotalCount(int expected, int actual, Description description) {
        Assert.fail((String)MessageFormat.format("{0}.{1}: The test does not check the message logging - {2} messages", description.getClassName(), description.getMethodName(), expected - actual));
    }

    public static boolean equalsMessageByTemplate(String message, String template) {
        if (template.contains("{") && template.contains("}")) {
            String templateWithoutParameters = template.replace("''", "'").replaceAll("\\{[0-9]+?\\}", "(.)*?");
            Pattern p = Pattern.compile(templateWithoutParameters, 32);
            Matcher m = p.matcher(message);
            return m.matches();
        }
        return message.contains(template);
    }
}

