/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.io.color.IccProfile;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.image.Jpeg2000ImageData;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.PatternColor;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.pdfa.PdfAConformanceException;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PdfA2Checker
extends PdfA1Checker {
    protected static final Set<PdfName> forbiddenAnnotations = new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.Sound, PdfName.Screen, PdfName.Movie));
    protected static final Set<PdfName> forbiddenActions = new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide, PdfName.SetOCGState, PdfName.Rendition, PdfName.Trans, PdfName.GoTo3DView));
    protected static final Set<PdfName> allowedBlendModes = new HashSet<PdfName>(Arrays.asList(PdfName.Normal, PdfName.Compatible, PdfName.Multiply, PdfName.Screen, PdfName.Overlay, PdfName.Darken, PdfName.Lighten, PdfName.ColorDodge, PdfName.ColorBurn, PdfName.HardLight, PdfName.SoftLight, PdfName.Difference, PdfName.Exclusion, PdfName.Hue, PdfName.Saturation, PdfName.Color, PdfName.Luminosity));
    static final int MAX_PAGE_SIZE = 14400;
    static final int MIN_PAGE_SIZE = 3;
    private boolean transparencyIsUsed = false;
    private boolean currentFillCsIsIccBasedCMYK = false;
    private boolean currentStrokeCsIsIccBasedCMYK = false;
    private Map<PdfName, PdfArray> separationColorSpaces = new HashMap<PdfName, PdfArray>();

    public PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    public void checkInlineImage(PdfStream inlineImage, PdfDictionary currentColorSpaces) {
        PdfObject filter = inlineImage.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("lzwdecode.filter.is.not.permitted");
            }
            if (filter.equals(PdfName.Crypt)) {
                throw new PdfAConformanceException("crypt.filter.is.not.permitted.inline.image");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals((Object)PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("lzwdecode.filter.is.not.permitted");
                }
                if (!f.equals((Object)PdfName.Crypt)) continue;
                throw new PdfAConformanceException("crypt.filter.is.not.permitted.inline.image");
            }
        }
        this.checkImage(inlineImage, currentColorSpaces);
    }

    @Override
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill) {
        PdfPattern pattern;
        if (color instanceof PatternColor && (pattern = ((PatternColor)color).getPattern()) instanceof PdfPattern.Shading) {
            PdfDictionary shadingDictionary = ((PdfPattern.Shading)pattern).getShading();
            PdfObject colorSpace = shadingDictionary.get(PdfName.ColorSpace);
            this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)colorSpace), currentColorSpaces, true, true);
            final PdfDictionary extGStateDict = ((PdfDictionary)pattern.getPdfObject()).getAsDictionary(PdfName.ExtGState);
            CanvasGraphicsState gState = new CanvasGraphicsState(){
                {
                    this.updateFromExtGState(new PdfExtGState(extGStateDict));
                }
            };
            this.checkExtGState(gState);
        }
        this.checkColorSpace(color.getColorSpace(), currentColorSpaces, true, fill);
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        byte[] iccBytes;
        if (fill != null) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = false;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = false;
            }
        }
        if (colorSpace instanceof PdfSpecialCs.Separation) {
            PdfSpecialCs.Separation separation = (PdfSpecialCs.Separation)colorSpace;
            this.checkSeparationCS((PdfArray)separation.getPdfObject());
            if (checkAlternate) {
                this.checkColorSpace(separation.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.DeviceN) {
            PdfSpecialCs.DeviceN deviceN = (PdfSpecialCs.DeviceN)colorSpace;
            PdfDictionary attributes = ((PdfArray)deviceN.getPdfObject()).getAsDictionary(4);
            PdfDictionary colorants = attributes.getAsDictionary(PdfName.Colorants);
            if (colorants != null) {
                for (Map.Entry entry : colorants.entrySet()) {
                    PdfArray separation = (PdfArray)entry.getValue();
                    this.checkSeparationInsideDeviceN(separation, ((PdfArray)deviceN.getPdfObject()).get(2), ((PdfArray)deviceN.getPdfObject()).get(3).getIndirectReference());
                }
            }
            if (checkAlternate) {
                this.checkColorSpace(deviceN.getBaseCs(), currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.Indexed) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.Indexed)colorSpace).getBaseCs(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.UncoloredTilingPattern)colorSpace).getUnderlyingColorSpace(), currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Rgb) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultRGB, 3)) {
                this.rgbIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            if (!this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultCMYK, 4)) {
                this.cmykIsUsed = true;
            }
        } else if (colorSpace instanceof PdfDeviceCs.Gray && !this.checkDefaultCS(currentColorSpaces, fill, PdfName.DefaultGray, 1)) {
            this.grayIsUsed = true;
        }
        if (fill != null && colorSpace instanceof PdfCieBasedCs.IccBased && "CMYK".equals(IccProfile.getIccColorSpaceName((byte[])(iccBytes = ((PdfArray)colorSpace.getPdfObject()).getAsStream(1).getBytes())))) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = true;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = true;
            }
        }
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState) {
        PdfObject bm;
        if (Integer.valueOf(1).equals(extGState.getOverprintMode())) {
            if (extGState.getFillOverprint() && this.currentFillCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("overprint.mode.shall.not.be.one.when.an.ICCBased.CMYK.colour.space.is.used.and.when.overprinting.is.set.to.true");
            }
            if (extGState.getStrokeOverprint() && this.currentStrokeCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("overprint.mode.shall.not.be.one.when.an.ICCBased.CMYK.colour.space.is.used.and.when.overprinting.is.set.to.true");
            }
        }
        if (extGState.getTransferFunction() != null) {
            throw new PdfAConformanceException("an.extgstate.dictionary.shall.not.contain.the.tr.key");
        }
        if (extGState.getHTP() != null) {
            throw new PdfAConformanceException("an.extgstate.dictionary.shall.not.contain.the.HTP.key");
        }
        PdfObject transferFunction2 = extGState.getTransferFunction2();
        if (transferFunction2 != null && !PdfName.Default.equals((Object)transferFunction2)) {
            throw new PdfAConformanceException("an.extgstate.dictionary.shall.not.contain.the.TR2.key.with.a.value.other.than.default");
        }
        if (extGState.getHalftone() instanceof PdfDictionary) {
            PdfDictionary halftoneDict = (PdfDictionary)extGState.getHalftone();
            Integer halftoneType = halftoneDict.getAsInt(PdfName.HalftoneType);
            if (halftoneType != 1 && halftoneType != 5) {
                throw new PdfAConformanceException("all.halftones.shall.have.halftonetype.1.or.5");
            }
            if (halftoneDict.containsKey(PdfName.HalftoneName)) {
                throw new PdfAConformanceException("halftones.shall.not.contain.halftonename");
            }
        }
        this.checkRenderingIntent(extGState.getRenderingIntent());
        if (extGState.getSoftMask() != null && extGState.getSoftMask() instanceof PdfDictionary) {
            this.transparencyIsUsed = true;
        }
        if (extGState.getStrokeOpacity() < 1.0f) {
            this.transparencyIsUsed = true;
        }
        if (extGState.getFillOpacity() < 1.0f) {
            this.transparencyIsUsed = true;
        }
        if ((bm = extGState.getBlendMode()) != null) {
            if (!PdfName.Normal.equals((Object)bm)) {
                this.transparencyIsUsed = true;
            }
            if (bm instanceof PdfArray) {
                for (PdfObject b : (PdfArray)bm) {
                    this.checkBlendMode((PdfName)b);
                }
            } else if (bm instanceof PdfName) {
                this.checkBlendMode((PdfName)bm);
            }
        }
    }

    @Override
    protected double getMaxRealValue() {
        return 3.4028234663852886E38;
    }

    @Override
    protected int getMaxStringLength() {
        return Short.MAX_VALUE;
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        PdfName subtype = annotDic.getAsName(PdfName.Subtype);
        if (subtype == null) {
            throw new PdfAConformanceException("annotation.type.1.is.not.permitted").setMessageParams(new Object[]{"null"});
        }
        if (forbiddenAnnotations.contains(subtype)) {
            throw new PdfAConformanceException("annotation.type.1.is.not.permitted").setMessageParams(new Object[]{subtype.getValue()});
        }
        if (!subtype.equals((Object)PdfName.Popup)) {
            PdfNumber f = annotDic.getAsNumber(PdfName.F);
            if (f == null) {
                throw new PdfAConformanceException("an.annotation.dictionary.shall.contain.the.f.key");
            }
            int flags = f.intValue();
            if (!PdfA2Checker.checkFlag(flags, 4) || PdfA2Checker.checkFlag(flags, 2) || PdfA2Checker.checkFlag(flags, 1) || PdfA2Checker.checkFlag(flags, 32) || PdfA2Checker.checkFlag(flags, 256)) {
                throw new PdfAConformanceException("the.f.keys.print.flag.bit.shall.be.set.to.1.and.its.hidden.invisible.noview.and.togglenoview.flag.bits.shall.be.set.to.0");
            }
            if (!(!subtype.equals((Object)PdfName.Text) || PdfA2Checker.checkFlag(flags, 8) && PdfA2Checker.checkFlag(flags, 16))) {
                throw new PdfAConformanceException("text.annotations.should.set.the.nozoom.and.norotate.flag.bits.of.the.f.key.to.1");
            }
        }
        if (PdfName.Widget.equals((Object)subtype) && (annotDic.containsKey(PdfName.AA) || annotDic.containsKey(PdfName.A))) {
            throw new PdfAConformanceException("widget.annotation.dictionary.or.field.dictionary.shall.not.include.a.or.aa.entry");
        }
        if (annotDic.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("an.annotation.dictionary.shall.not.contain.aa.key");
        }
        if (PdfA2Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annotDic.containsKey(PdfName.Contents)) {
            throw new PdfAConformanceException("annotation.of.type.1.should.have.contents.key").setMessageParams(new Object[]{subtype});
        }
        PdfDictionary ap = annotDic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            if (ap.containsKey(PdfName.R) || ap.containsKey(PdfName.D)) {
                throw new PdfAConformanceException("appearance.dictionary.shall.contain.only.the.n.key.with.stream.value");
            }
            PdfObject n = ap.get(PdfName.N);
            if (PdfName.Widget.equals((Object)subtype) && PdfName.Btn.equals((Object)annotDic.getAsName(PdfName.FT))) {
                if (n == null || !n.isDictionary()) {
                    throw new PdfAConformanceException("appearance.dictionary.of.widget.subtype.and.btn.field.type.shall.contain.only.the.n.key.with.dictionary.value");
                }
            } else if (n == null || !n.isStream()) {
                throw new PdfAConformanceException("appearance.dictionary.shall.contain.only.the.n.key.with.stream.value");
            }
        } else {
            boolean isCorrectRect = false;
            PdfArray rect = annotDic.getAsArray(PdfName.Rect);
            if (rect != null && rect.size() == 4) {
                PdfNumber index0 = rect.getAsNumber(0);
                PdfNumber index1 = rect.getAsNumber(1);
                PdfNumber index2 = rect.getAsNumber(2);
                PdfNumber index3 = rect.getAsNumber(3);
                if (index0 != null && index1 != null && index2 != null && index3 != null && index0.floatValue() == index2.floatValue() && index1.floatValue() == index3.floatValue()) {
                    isCorrectRect = true;
                }
            }
            if (!(PdfName.Popup.equals((Object)subtype) || PdfName.Link.equals((Object)subtype) || isCorrectRect)) {
                throw new PdfAConformanceException("every.annotation.shall.have.at.least.one.appearance.dictionary");
            }
        }
    }

    @Override
    protected void checkForm(PdfDictionary form) {
        if (form != null) {
            PdfBoolean needAppearances = form.getAsBoolean(PdfName.NeedAppearances);
            if (needAppearances != null && needAppearances.getValue()) {
                throw new PdfAConformanceException("needappearances.flag.of.the.interactive.form.dictionary.shall.either.not.be.presented.or.shall.be.false");
            }
            if (form.containsKey(PdfName.XFA)) {
                throw new PdfAConformanceException("the.interactive.form.dictionary.shall.not.contain.the.xfa.key");
            }
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        PdfDictionary namesDictionary;
        if (catalogDict.containsKey(PdfName.NeedsRendering)) {
            throw new PdfAConformanceException("the.catalog.dictionary.shall.not.contain.the.needsrendering.key");
        }
        if (catalogDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("catalog.dictionary.shall.not.contain.aa.entry");
        }
        if (catalogDict.containsKey(PdfName.Requirements)) {
            throw new PdfAConformanceException("catalog.dictionary.shall.not.contain.a.requirements.entry");
        }
        PdfDictionary permissions = catalogDict.getAsDictionary(PdfName.Perms);
        if (permissions != null) {
            for (PdfName dictKey : permissions.keySet()) {
                if (PdfName.DocMDP.equals((Object)dictKey)) {
                    PdfArray references;
                    PdfDictionary signatureDict = permissions.getAsDictionary(PdfName.DocMDP);
                    if (signatureDict == null || (references = signatureDict.getAsArray(PdfName.Reference)) == null) continue;
                    for (int i = 0; i < references.size(); ++i) {
                        Iterator referenceDict = references.getAsDictionary(i);
                        if (!referenceDict.containsKey(PdfName.DigestLocation) && !referenceDict.containsKey(PdfName.DigestMethod) && !referenceDict.containsKey(PdfName.DigestValue)) continue;
                        throw new PdfAConformanceException("signature.references.dictionary.shall.not.contain.digestlocation.digestmethod.digestvalue");
                    }
                    continue;
                }
                if (PdfName.UR3.equals((Object)dictKey)) continue;
                throw new PdfAConformanceException("no.keys.other.than.UR3.and.DocMDP.shall.be.present.in.a.permissions.dictionary");
            }
        }
        if ((namesDictionary = catalogDict.getAsDictionary(PdfName.Names)) != null && namesDictionary.containsKey(PdfName.AlternatePresentations)) {
            throw new PdfAConformanceException("catalog.dictionary.shall.not.contain.alternatepresentations.names.entry");
        }
        PdfDictionary oCProperties = catalogDict.getAsDictionary(PdfName.OCProperties);
        if (oCProperties != null) {
            PdfArray configs;
            ArrayList<PdfDictionary> configList = new ArrayList<PdfDictionary>();
            PdfDictionary d = oCProperties.getAsDictionary(PdfName.D);
            if (d != null) {
                configList.add(d);
            }
            if ((configs = oCProperties.getAsArray(PdfName.Configs)) != null) {
                for (PdfObject config : configs) {
                    configList.add((PdfDictionary)config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = oCProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    ocgs.add(ocg);
                }
            }
            HashSet<String> names = new HashSet<String>();
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            for (PdfDictionary config : configList) {
                PdfString name = config.getAsString(PdfName.Name);
                if (name == null) {
                    throw new PdfAConformanceException("optional.content.configuration.dictionary.shall.contain.name.entry");
                }
                if (!names.add(name.toUnicodeString())) {
                    throw new PdfAConformanceException("value.of.name.entry.shall.be.unique.among.all.optional.content.configuration.dictionaries");
                }
                if (config.containsKey(PdfName.AS)) {
                    throw new PdfAConformanceException("the.as.key.shall.not.appear.in.any.optional.content.configuration.dictionary");
                }
                PdfArray orderArray = config.getAsArray(PdfName.Order);
                if (orderArray == null) continue;
                this.fillOrderRecursively(orderArray, order);
            }
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException("order.array.shall.contain.references.to.all.ocgs");
            }
            order.retainAll(ocgs);
            if (order.size() != ocgs.size()) {
                throw new PdfAConformanceException("order.array.shall.contain.references.to.all.ocgs");
            }
        }
    }

    @Override
    protected void checkPageSize(PdfDictionary page) {
        PdfName[] boxNames;
        for (PdfName boxName : boxNames = new PdfName[]{PdfName.MediaBox, PdfName.CropBox, PdfName.TrimBox, PdfName.ArtBox, PdfName.BleedBox}) {
            Rectangle box = page.getAsRectangle(boxName);
            if (box == null) continue;
            float width = box.getWidth();
            float height = box.getHeight();
            if (!(width < 3.0f || width > 14400.0f || height < 3.0f) && !(height > 14400.0f)) continue;
            throw new PdfAConformanceException("the.page.less.3.units.no.greater.14400.in.either.direction");
        }
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.containsKey(PdfName.EF)) {
            if (!(fileSpec.containsKey(PdfName.F) && fileSpec.containsKey(PdfName.UF) && fileSpec.containsKey(PdfName.Desc))) {
                throw new PdfAConformanceException("file.specification.dictionary.shall.contain.f.key.uf.key.and.desc.key");
            }
            PdfDictionary ef = fileSpec.getAsDictionary(PdfName.EF);
            PdfStream embeddedFile = ef.getAsStream(PdfName.F);
            if (embeddedFile == null) {
                throw new PdfAConformanceException("ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key");
            }
            PdfName subtype = embeddedFile.getAsName(PdfName.Subtype);
            if (!PdfName.ApplicationPdf.equals((Object)subtype)) {
                throw new PdfAConformanceException("embedded.file.shall.be.of.pdf.mime.type");
            }
        }
    }

    @Override
    protected void checkPdfStream(PdfStream stream) {
        if (stream.containsKey(PdfName.F) || stream.containsKey(PdfName.FFilter) || stream.containsKey(PdfName.FDecodeParams)) {
            throw new PdfAConformanceException("stream.object.dictionary.shall.not.contain.the.f.ffilter.or.fdecodeparams.keys");
        }
        PdfObject filter = stream.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            PdfString cryptFilterName;
            PdfDictionary decodeParams;
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("lzwdecode.filter.is.not.permitted");
            }
            if (filter.equals(PdfName.Crypt) && (decodeParams = stream.getAsDictionary(PdfName.DecodeParms)) != null && (cryptFilterName = decodeParams.getAsString(PdfName.Name)) != null && !cryptFilterName.equals(PdfName.Identity)) {
                throw new PdfAConformanceException("not.identity.crypt.filter.is.not.permitted");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfDictionary decodeParam;
                PdfString cryptFilterName;
                PdfArray decodeParams;
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals((Object)PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("lzwdecode.filter.is.not.permitted");
                }
                if (!f.equals((Object)PdfName.Crypt) || (decodeParams = stream.getAsArray(PdfName.DecodeParms)) == null || i >= decodeParams.size() || (cryptFilterName = (decodeParam = decodeParams.getAsDictionary(i)).getAsString(PdfName.Name)) == null || cryptFilterName.equals(PdfName.Identity)) continue;
                throw new PdfAConformanceException("not.identity.crypt.filter.is.not.permitted");
            }
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        if (pageDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("page.dictionary.shall.not.contain.aa.entry");
        }
        if (pageDict.containsKey(PdfName.PresSteps)) {
            throw new PdfAConformanceException("page.dictionary.shall.not.contain.pressteps.entry");
        }
        if (pageDict.containsKey(PdfName.Group) && PdfName.Transparency.equals((Object)pageDict.getAsDictionary(PdfName.Group).getAsName(PdfName.S))) {
            this.transparencyIsUsed = true;
            PdfObject cs = pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS);
            if (cs != null) {
                PdfDictionary currentColorSpaces = pageResources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)cs), currentColorSpaces, true, null);
            }
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        int i;
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfObject destOutputProfile = null;
        for (i = 0; i < outputIntents.size() && destOutputProfile == null; ++i) {
            destOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
        }
        while (i < outputIntents.size()) {
            PdfObject otherDestOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
            if (otherDestOutputProfile != null && destOutputProfile != otherDestOutputProfile) {
                throw new PdfAConformanceException("if.outputintents.array.has.more.than.one.entry.with.destoutputprofile.key.the.same.indirect.object.shall.be.used.as.the.value.of.that.object");
            }
            ++i;
        }
        if (destOutputProfile != null) {
            String deviceClass = IccProfile.getIccDeviceClass((byte[])((PdfStream)destOutputProfile).getBytes());
            if (!"prtr".equals(deviceClass) && !"mntr".equals(deviceClass)) {
                throw new PdfAConformanceException("profile.stream.of.outputintent.shall.be.output.profile.(prtr).or.monitor.profile.(mntr)");
            }
            String cs = IccProfile.getIccColorSpaceName((byte[])((PdfStream)destOutputProfile).getBytes());
            if (!("RGB ".equals(cs) || "CMYK".equals(cs) || "GRAY".equals(cs))) {
                throw new PdfAConformanceException("output.intent.color.space.shall.be.either.gray.rgb.or.cmyk");
            }
        }
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        return forbiddenActions;
    }

    @Override
    protected Set<PdfName> getAllowedNamedActions() {
        return allowedNamedActions;
    }

    @Override
    protected void checkColorsUsages() {
        if (this.transparencyIsUsed && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("if.the.document.does.not.contain.a.pdfa.outputintent.transparency.is.forbidden");
        }
        if ((this.rgbIsUsed || this.cmykIsUsed || this.grayIsUsed) && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("if.device.rgb.cmyk.gray.used.in.file.that.file.shall.contain.pdfa.outputintent.orDefaultRgb.Cmyk.Gray.in.usage.context");
        }
        if (this.rgbIsUsed && !"RGB ".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("devicergb.may.be.used.only.if.the.file.has.a.rgb.pdfa.outputIntent.or.defaultrgb.in.usage.context");
        }
        if (this.cmykIsUsed && !"CMYK".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("devicecmyk.may.be.used.only.if.the.file.has.a.cmyk.pdfa.outputIntent.or.defaultcmyk.in.usage.context");
        }
    }

    @Override
    protected void checkImage(PdfStream image, PdfDictionary currentColorSpaces) {
        PdfColorSpace colorSpace = null;
        if (this.isAlreadyChecked((PdfDictionary)image)) {
            colorSpace = (PdfColorSpace)this.checkedObjectsColorspace.get(image);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            return;
        }
        PdfObject colorSpaceObj = image.get(PdfName.ColorSpace);
        if (colorSpaceObj != null) {
            colorSpace = PdfColorSpace.makeColorSpace((PdfObject)colorSpaceObj);
            this.checkColorSpace(colorSpace, currentColorSpaces, true, null);
            this.checkedObjectsColorspace.put(image, colorSpace);
        }
        if (image.containsKey(PdfName.Alternates)) {
            throw new PdfAConformanceException("an.image.dictionary.shall.not.contain.alternates.key");
        }
        if (image.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("an.image.dictionary.shall.not.contain.opi.key");
        }
        if (image.containsKey(PdfName.Interpolate) && image.getAsBool(PdfName.Interpolate).booleanValue()) {
            throw new PdfAConformanceException("the.value.of.interpolate.key.shall.not.be.true");
        }
        this.checkRenderingIntent(image.getAsName(PdfName.Intent));
        if (image.getAsStream(PdfName.SMask) != null) {
            this.transparencyIsUsed = true;
        }
        if (image.containsKey(PdfName.SMaskInData) && image.getAsInt(PdfName.SMaskInData) > 0) {
            this.transparencyIsUsed = true;
        }
        if (PdfName.JPXDecode.equals((Object)image.get(PdfName.Filter))) {
            Jpeg2000ImageData jpgImage = (Jpeg2000ImageData)ImageDataFactory.createJpeg2000((byte[])image.getBytes());
            Jpeg2000ImageData.Parameters params = jpgImage.getParameters();
            if (!params.isJp2) {
                throw new PdfAConformanceException("only.jpx.baseline.set.of.features.shall.be.used");
            }
            if (params.numOfComps != 1 && params.numOfComps != 3 && params.numOfComps != 4) {
                throw new PdfAConformanceException("the.number.of.colour.channels.in.the.jpeg2000.data.shall.be.123");
            }
            if (params.colorSpecBoxes != null && params.colorSpecBoxes.size() > 1) {
                int numOfApprox0x01 = 0;
                for (Jpeg2000ImageData.ColorSpecBox colorSpecBox : params.colorSpecBoxes) {
                    if (colorSpecBox.getApprox() == 1) {
                        if (++numOfApprox0x01 == 1 && colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                            throw new PdfAConformanceException("the.value.of.the.meth.entry.in.colr.box.shall.be.123");
                        }
                        if (image.get(PdfName.ColorSpace) == null) {
                            switch (colorSpecBox.getEnumCs()) {
                                case 1: {
                                    PdfDeviceCs.Gray deviceGrayCs = new PdfDeviceCs.Gray();
                                    this.checkColorSpace((PdfColorSpace)deviceGrayCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceGrayCs);
                                    break;
                                }
                                case 3: {
                                    PdfDeviceCs.Rgb deviceRgbCs = new PdfDeviceCs.Rgb();
                                    this.checkColorSpace((PdfColorSpace)deviceRgbCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceRgbCs);
                                    break;
                                }
                                case 12: {
                                    PdfDeviceCs.Cmyk deviceCmykCs = new PdfDeviceCs.Cmyk();
                                    this.checkColorSpace((PdfColorSpace)deviceCmykCs, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceCmykCs);
                                }
                            }
                        }
                    }
                    if (colorSpecBox.getEnumCs() != 19) continue;
                    throw new PdfAConformanceException("jpeg2000.enumerated.colour.space.19.(CIEJab).shall.not.be.used");
                }
                if (numOfApprox0x01 != 1) {
                    throw new PdfAConformanceException("exactly.one.colour.space.specification.shall.have.the.value.0x01.in.the.approx.field");
                }
            }
            if (jpgImage.getBpc() < 1 || jpgImage.getBpc() > 38) {
                throw new PdfAConformanceException("the.bit-depth.of.the.jpeg2000.data.shall.have.a.value.in.the.range.1to38");
            }
            if (params.bpcBoxData != null) {
                throw new PdfAConformanceException("all.colour.channels.in.the.jpeg2000.data.shall.have.the.same.bit-depth");
            }
        }
    }

    @Override
    protected void checkFormXObject(PdfStream form) {
        if (this.isAlreadyChecked((PdfDictionary)form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("a.form.xobject.dictionary.shall.not.contain.opi.key");
        }
        if (form.containsKey(PdfName.PS)) {
            throw new PdfAConformanceException("a.form.xobject.dictionary.shall.not.contain.PS.key");
        }
        if (PdfName.PS.equals((Object)form.getAsName(PdfName.Subtype2))) {
            throw new PdfAConformanceException("a.form.xobject.dictionary.shall.not.contain.subtype2.key.with.a.value.of.PS");
        }
        if (form.containsKey(PdfName.Group) && PdfName.Transparency.equals((Object)form.getAsDictionary(PdfName.Group).getAsName(PdfName.S))) {
            this.transparencyIsUsed = true;
            PdfObject cs = form.getAsDictionary(PdfName.Group).get(PdfName.CS);
            PdfDictionary resources = form.getAsDictionary(PdfName.Resources);
            if (cs != null && resources != null) {
                PdfDictionary currentColorSpaces = resources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace((PdfObject)cs), currentColorSpaces, true, null);
            }
        }
    }

    private void checkBlendMode(PdfName blendMode) {
        if (!allowedBlendModes.contains(blendMode)) {
            throw new PdfAConformanceException("only.standard.blend.modes.shall.be.used.for.the.value.of.the.BM.key.in.an.extended.graphic.state.dictionary");
        }
    }

    private void checkSeparationInsideDeviceN(PdfArray separation, PdfObject deviceNColorSpace, PdfIndirectReference deviceNTintTransform) {
        if (!this.isAltCSIsTheSame(separation.get(2), deviceNColorSpace) || !deviceNTintTransform.equals((Object)separation.getAsDictionary(3).getIndirectReference())) {
            throw new PdfAConformanceException("tintTransform.and.alternateSpace.of.separation.arrays.in.the.colorants.of.deviceN.shall.be.consistent.with.same.attributes.of.deviceN");
        }
        this.checkSeparationCS(separation);
    }

    private void checkSeparationCS(PdfArray separation) {
        if (this.separationColorSpaces.containsKey(separation.getAsName(0))) {
            boolean altCSIsTheSame = false;
            boolean tintTransformIsTheSame = false;
            PdfArray sameNameSeparation = this.separationColorSpaces.get(separation.getAsName(0));
            PdfObject cs1 = separation.get(2);
            PdfObject cs2 = sameNameSeparation.get(2);
            altCSIsTheSame = this.isAltCSIsTheSame(cs1, cs2);
            PdfDictionary f1 = separation.getAsDictionary(3);
            PdfDictionary f2 = sameNameSeparation.getAsDictionary(3);
            tintTransformIsTheSame = f1.getIndirectReference().equals((Object)f2.getIndirectReference());
            if (!altCSIsTheSame || !tintTransformIsTheSame) {
                throw new PdfAConformanceException("tintTransform.and.alternateSpace.shall.be.the.same.for.the.all.separation.cs.with.the.same.name");
            }
        } else {
            this.separationColorSpaces.put(separation.getAsName(0), separation);
        }
    }

    private boolean isAltCSIsTheSame(PdfObject cs1, PdfObject cs2) {
        boolean altCSIsTheSame = false;
        if (cs1 instanceof PdfName) {
            altCSIsTheSame = cs1.equals(cs2);
        } else if (cs1 instanceof PdfArray && cs2 instanceof PdfArray) {
            altCSIsTheSame = ((PdfArray)cs1).get(0).equals(((PdfArray)cs1).get(0));
        }
        return altCSIsTheSame;
    }

    private void fillOrderRecursively(PdfArray orderArray, Set<PdfObject> order) {
        for (PdfObject orderItem : orderArray) {
            if (!orderItem.isArray()) {
                order.add(orderItem);
                continue;
            }
            this.fillOrderRecursively((PdfArray)orderItem, order);
        }
    }

    private boolean checkDefaultCS(PdfDictionary currentColorSpaces, Boolean fill, PdfName defaultCsName, int numOfComponents) {
        if (currentColorSpaces == null) {
            return false;
        }
        if (!currentColorSpaces.containsKey(defaultCsName)) {
            return false;
        }
        PdfObject defaultCsObj = currentColorSpaces.get(defaultCsName);
        PdfColorSpace defaultCs = PdfColorSpace.makeColorSpace((PdfObject)defaultCsObj);
        if (defaultCs instanceof PdfDeviceCs) {
            throw new PdfAConformanceException("color.space.1.shall.be.device.independent").setMessageParams(new Object[]{defaultCsName.toString()});
        }
        if (defaultCs.getNumberOfComponents() != numOfComponents) {
            throw new PdfAConformanceException("color.space.1.shall.have.2.components").setMessageParams(new Object[]{defaultCsName.toString(), numOfComponents});
        }
        this.checkColorSpace(defaultCs, currentColorSpaces, false, fill);
        return true;
    }
}

