/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties.grid;

import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.grid.FunctionValue;
import com.itextpdf.layout.properties.grid.LengthValue;
import com.itextpdf.layout.properties.grid.PercentValue;
import com.itextpdf.layout.properties.grid.PointValue;
import com.itextpdf.layout.properties.grid.TemplateValue;

public class FitContentValue
extends FunctionValue {
    private LengthValue length;

    public FitContentValue(LengthValue length) {
        super(TemplateValue.ValueType.FIT_CONTENT);
        this.length = length;
    }

    public FitContentValue(UnitValue length) {
        super(TemplateValue.ValueType.FIT_CONTENT);
        if (length != null) {
            if (length.isPointValue()) {
                this.length = new PointValue(length.getValue());
            } else if (length.isPercentValue()) {
                this.length = new PercentValue(length.getValue());
            }
        }
    }

    public LengthValue getLength() {
        return this.length;
    }

    public float getMaxSizeForSpace(float space) {
        if (this.length.getType() == TemplateValue.ValueType.POINT) {
            return this.length.getValue();
        }
        return this.length.getValue() / 100.0f * space;
    }
}

