/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructureAttributes;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.IListSymbolFactory;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleTypes;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibleAttributesApplier {
    public static PdfStructureAttributes getLayoutAttributes(AbstractRenderer renderer, TagTreePointer taggingPointer) {
        IRoleMappingResolver resolvedMapping = AccessibleAttributesApplier.resolveMappingToStandard(taggingPointer);
        if (resolvedMapping == null) {
            return null;
        }
        String role = resolvedMapping.getRole();
        int tagType = AccessibleTypes.identifyType(role);
        PdfDictionary attributes = new PdfDictionary();
        attributes.put(PdfName.O, (PdfObject)PdfName.Layout);
        AccessibleAttributesApplier.applyCommonLayoutAttributes(renderer, attributes);
        if (tagType == AccessibleTypes.BlockLevel) {
            AccessibleAttributesApplier.applyBlockLevelLayoutAttributes(role, renderer, attributes);
        }
        if (tagType == AccessibleTypes.InlineLevel) {
            AccessibleAttributesApplier.applyInlineLevelLayoutAttributes(renderer, attributes);
        }
        if (tagType == AccessibleTypes.Illustration) {
            AccessibleAttributesApplier.applyIllustrationLayoutAttributes(renderer, attributes);
        }
        return attributes.size() > 1 ? new PdfStructureAttributes(attributes) : null;
    }

    public static PdfStructureAttributes getListAttributes(AbstractRenderer renderer, TagTreePointer taggingPointer) {
        IRoleMappingResolver resolvedMapping = null;
        resolvedMapping = AccessibleAttributesApplier.resolveMappingToStandard(taggingPointer);
        if (resolvedMapping == null || !"L".equals(resolvedMapping.getRole())) {
            return null;
        }
        PdfDictionary attributes = new PdfDictionary();
        attributes.put(PdfName.O, (PdfObject)PdfName.List);
        Object listSymbol = renderer.getProperty(37);
        boolean tagStructurePdf2 = AccessibleAttributesApplier.isTagStructurePdf2(resolvedMapping.getNamespace());
        if (listSymbol instanceof ListNumberingType) {
            ListNumberingType numberingType = (ListNumberingType)((Object)listSymbol);
            attributes.put(PdfName.ListNumbering, (PdfObject)AccessibleAttributesApplier.transformNumberingTypeToName(numberingType, tagStructurePdf2));
        } else if (tagStructurePdf2) {
            if (listSymbol instanceof IListSymbolFactory) {
                attributes.put(PdfName.ListNumbering, (PdfObject)PdfName.Ordered);
            } else {
                attributes.put(PdfName.ListNumbering, (PdfObject)PdfName.Unordered);
            }
        }
        return attributes.size() > 1 ? new PdfStructureAttributes(attributes) : null;
    }

    public static PdfStructureAttributes getTableAttributes(AbstractRenderer renderer, TagTreePointer taggingPointer) {
        IRoleMappingResolver resolvedMapping = AccessibleAttributesApplier.resolveMappingToStandard(taggingPointer);
        if (resolvedMapping == null || !"TD".equals(resolvedMapping.getRole()) && !"TH".equals(resolvedMapping.getRole())) {
            return null;
        }
        PdfDictionary attributes = new PdfDictionary();
        attributes.put(PdfName.O, (PdfObject)PdfName.Table);
        if (renderer.getModelElement() instanceof Cell) {
            Cell cell = (Cell)renderer.getModelElement();
            if (cell.getRowspan() != 1) {
                attributes.put(PdfName.RowSpan, (PdfObject)new PdfNumber(cell.getRowspan()));
            }
            if (cell.getColspan() != 1) {
                attributes.put(PdfName.ColSpan, (PdfObject)new PdfNumber(cell.getColspan()));
            }
        }
        return attributes.size() > 1 ? new PdfStructureAttributes(attributes) : null;
    }

    private static void applyCommonLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Background background = (Background)renderer.getProperty(6);
        if (background != null && background.getColor() instanceof DeviceRgb) {
            attributes.put(PdfName.BackgroundColor, (PdfObject)new PdfArray(background.getColor().getColorValue()));
        }
        if (!(renderer.getModelElement() instanceof Cell)) {
            AccessibleAttributesApplier.applyBorderAttributes(renderer, attributes);
        }
        AccessibleAttributesApplier.applyPaddingAttribute(renderer, attributes);
        TransparentColor transparentColor = renderer.getPropertyAsTransparentColor(21);
        if (transparentColor != null && transparentColor.getColor() instanceof DeviceRgb) {
            attributes.put(PdfName.Color, (PdfObject)new PdfArray(transparentColor.getColor().getColorValue()));
        }
    }

    private static void applyBlockLevelLayoutAttributes(String role, AbstractRenderer renderer, PdfDictionary attributes) {
        TextAlignment textAlignment;
        Float firstLineIndent;
        UnitValue endIndent;
        UnitValue startIndent;
        UnitValue spaceAfter;
        int[] marginsOrder;
        UnitValue[] margins = new UnitValue[]{renderer.getPropertyAsUnitValue(46), renderer.getPropertyAsUnitValue(43), renderer.getPropertyAsUnitValue(44), renderer.getPropertyAsUnitValue(45)};
        UnitValue spaceBefore = margins[(marginsOrder = new int[]{0, 1, 2, 3})[0]];
        if (spaceBefore != null) {
            if (!spaceBefore.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{46}));
            }
            if (0.0f != spaceBefore.getValue()) {
                attributes.put(PdfName.SpaceBefore, (PdfObject)new PdfNumber((double)spaceBefore.getValue()));
            }
        }
        if ((spaceAfter = margins[marginsOrder[1]]) != null) {
            if (!spaceAfter.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{43}));
            }
            if (0.0f != spaceAfter.getValue()) {
                attributes.put(PdfName.SpaceAfter, (PdfObject)new PdfNumber((double)spaceAfter.getValue()));
            }
        }
        if ((startIndent = margins[marginsOrder[2]]) != null) {
            if (!startIndent.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
            }
            if (0.0f != startIndent.getValue()) {
                attributes.put(PdfName.StartIndent, (PdfObject)new PdfNumber((double)startIndent.getValue()));
            }
        }
        if ((endIndent = margins[marginsOrder[3]]) != null) {
            if (!endIndent.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
            }
            if (0.0f != endIndent.getValue()) {
                attributes.put(PdfName.EndIndent, (PdfObject)new PdfNumber((double)endIndent.getValue()));
            }
        }
        if ((firstLineIndent = renderer.getPropertyAsFloat(18)) != null && firstLineIndent.floatValue() != 0.0f) {
            attributes.put(PdfName.TextIndent, (PdfObject)new PdfNumber((double)firstLineIndent.floatValue()));
        }
        if ((textAlignment = (TextAlignment)((Object)renderer.getProperty(70))) != null && !role.equals("TH") && !role.equals("TD")) {
            attributes.put(PdfName.TextAlign, (PdfObject)AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
        }
        if (renderer.isLastRendererForModelElement) {
            Rectangle bbox = renderer.getOccupiedArea().getBBox();
            attributes.put(PdfName.BBox, (PdfObject)new PdfArray(bbox));
        }
        if (role.equals("TH") || role.equals("TD") || role.equals("Table")) {
            UnitValue height;
            UnitValue width;
            if ((!(renderer instanceof TableRenderer) || ((Table)renderer.getModelElement()).isComplete()) && (width = (UnitValue)renderer.getProperty(77)) != null && width.isPointValue()) {
                attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)width.getValue()));
            }
            if ((height = (UnitValue)renderer.getProperty(27)) != null && height.isPointValue()) {
                attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)height.getValue()));
            }
        }
        if (role.equals("TH") || role.equals("TD")) {
            HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)renderer.getProperty(28));
            if (horizontalAlignment != null) {
                attributes.put(PdfName.BlockAlign, (PdfObject)AccessibleAttributesApplier.transformBlockAlignToName(horizontalAlignment));
            }
            if (textAlignment != null && textAlignment != TextAlignment.JUSTIFIED && textAlignment != TextAlignment.JUSTIFIED_ALL) {
                attributes.put(PdfName.InlineAlign, (PdfObject)AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
            }
        }
    }

    private static void applyInlineLevelLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Object underlines;
        Float textRise = renderer.getPropertyAsFloat(72);
        if (textRise != null && textRise.floatValue() != 0.0f) {
            attributes.put(PdfName.BaselineShift, (PdfObject)new PdfNumber((double)textRise.floatValue()));
        }
        if ((underlines = renderer.getProperty(74)) != null) {
            UnitValue fontSize = renderer.getPropertyAsUnitValue(24);
            if (!fontSize.isPointValue()) {
                Logger logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
            }
            Underline underline = null;
            if (underlines instanceof List && ((List)underlines).size() > 0 && ((List)underlines).get(0) instanceof Underline) {
                underline = (Underline)((List)underlines).get(0);
            } else if (underlines instanceof Underline) {
                underline = (Underline)underlines;
            }
            if (underline != null) {
                attributes.put(PdfName.TextDecorationType, (PdfObject)(underline.getYPosition(fontSize.getValue()) > 0.0f ? PdfName.LineThrough : PdfName.Underline));
                if (underline.getColor() instanceof DeviceRgb) {
                    attributes.put(PdfName.TextDecorationColor, (PdfObject)new PdfArray(underline.getColor().getColorValue()));
                }
                attributes.put(PdfName.TextDecorationThickness, (PdfObject)new PdfNumber((double)underline.getThickness(fontSize.getValue())));
            }
        }
    }

    private static void applyIllustrationLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Rectangle bbox = renderer.getOccupiedArea().getBBox();
        attributes.put(PdfName.BBox, (PdfObject)new PdfArray(bbox));
        UnitValue width = (UnitValue)renderer.getProperty(77);
        if (width != null && width.isPointValue()) {
            attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)width.getValue()));
        } else {
            attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)bbox.getWidth()));
        }
        UnitValue height = (UnitValue)renderer.getProperty(27);
        if (height != null) {
            attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)height.getValue()));
        } else {
            attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)bbox.getHeight()));
        }
    }

    private static void applyPaddingAttribute(AbstractRenderer renderer, PdfDictionary attributes) {
        Logger logger;
        UnitValue[] paddingsUV = new UnitValue[]{renderer.getPropertyAsUnitValue(50), renderer.getPropertyAsUnitValue(49), renderer.getPropertyAsUnitValue(47), renderer.getPropertyAsUnitValue(48)};
        if (!paddingsUV[0].isPointValue()) {
            logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{50}));
        }
        if (!paddingsUV[1].isPointValue()) {
            logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{49}));
        }
        if (!paddingsUV[2].isPointValue()) {
            logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{47}));
        }
        if (!paddingsUV[3].isPointValue()) {
            logger = LoggerFactory.getLogger(AccessibleAttributesApplier.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{48}));
        }
        float[] paddings = new float[]{paddingsUV[0].getValue(), paddingsUV[1].getValue(), paddingsUV[2].getValue(), paddingsUV[3].getValue()};
        PdfNumber padding = null;
        if (paddings[0] == paddings[1] && paddings[0] == paddings[2] && paddings[0] == paddings[3]) {
            if (paddings[0] != 0.0f) {
                padding = new PdfNumber((double)paddings[0]);
            }
        } else {
            int[] paddingsOrder;
            PdfArray paddingArray = new PdfArray();
            for (int i : paddingsOrder = new int[]{0, 1, 2, 3}) {
                paddingArray.add((PdfObject)new PdfNumber((double)paddings[i]));
            }
            padding = paddingArray;
        }
        if (padding != null) {
            attributes.put(PdfName.Padding, padding);
        }
    }

    private static void applyBorderAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        boolean generalBorderProperties;
        boolean specificBorderProperties = renderer.getProperty(13) != null || renderer.getProperty(12) != null || renderer.getProperty(10) != null || renderer.getProperty(11) != null;
        boolean bl = generalBorderProperties = !specificBorderProperties && renderer.getProperty(9) != null;
        if (generalBorderProperties) {
            Border generalBorder = (Border)renderer.getProperty(9);
            Color generalBorderColor = generalBorder.getColor();
            int borderType = generalBorder.getType();
            float borderWidth = generalBorder.getWidth();
            if (generalBorderColor instanceof DeviceRgb) {
                attributes.put(PdfName.BorderColor, (PdfObject)new PdfArray(generalBorderColor.getColorValue()));
                attributes.put(PdfName.BorderStyle, (PdfObject)AccessibleAttributesApplier.transformBorderTypeToName(borderType));
                attributes.put(PdfName.BorderThickness, (PdfObject)new PdfNumber((double)borderWidth));
            }
        }
        if (specificBorderProperties) {
            int[] borderOrder;
            PdfArray borderColors = new PdfArray();
            PdfArray borderTypes = new PdfArray();
            PdfArray borderWidths = new PdfArray();
            boolean atLeastOneRgb = false;
            Border[] borders = renderer.getBorders();
            boolean allColorsEqual = true;
            boolean allTypesEqual = true;
            boolean allWidthsEqual = true;
            for (int i = 1; i < borders.length; ++i) {
                Border border = borders[i];
                if (border == null) continue;
                if (null == borders[0] || !border.getColor().equals((Object)borders[0].getColor())) {
                    allColorsEqual = false;
                }
                if (null == borders[0] || border.getWidth() != borders[0].getWidth()) {
                    allWidthsEqual = false;
                }
                if (null != borders[0] && border.getType() == borders[0].getType()) continue;
                allTypesEqual = false;
            }
            for (int i : borderOrder = new int[]{0, 1, 2, 3}) {
                if (borders[i] != null) {
                    if (borders[i].getColor() instanceof DeviceRgb) {
                        borderColors.add((PdfObject)new PdfArray(borders[i].getColor().getColorValue()));
                        atLeastOneRgb = true;
                    } else {
                        borderColors.add((PdfObject)PdfNull.PDF_NULL);
                    }
                    borderTypes.add((PdfObject)AccessibleAttributesApplier.transformBorderTypeToName(borders[i].getType()));
                    borderWidths.add((PdfObject)new PdfNumber((double)borders[i].getWidth()));
                    continue;
                }
                borderColors.add((PdfObject)PdfNull.PDF_NULL);
                borderTypes.add((PdfObject)PdfName.None);
                borderWidths.add((PdfObject)PdfNull.PDF_NULL);
            }
            if (atLeastOneRgb) {
                if (allColorsEqual) {
                    attributes.put(PdfName.BorderColor, borderColors.get(0));
                } else {
                    attributes.put(PdfName.BorderColor, (PdfObject)borderColors);
                }
            }
            if (allTypesEqual) {
                attributes.put(PdfName.BorderStyle, borderTypes.get(0));
            } else {
                attributes.put(PdfName.BorderStyle, (PdfObject)borderTypes);
            }
            if (allWidthsEqual) {
                attributes.put(PdfName.BorderThickness, borderWidths.get(0));
            } else {
                attributes.put(PdfName.BorderThickness, (PdfObject)borderWidths);
            }
        }
    }

    private static IRoleMappingResolver resolveMappingToStandard(TagTreePointer taggingPointer) {
        TagStructureContext tagContext = taggingPointer.getDocument().getTagStructureContext();
        PdfNamespace namespace = taggingPointer.getProperties().getNamespace();
        return tagContext.resolveMappingToStandardOrDomainSpecificRole(taggingPointer.getRole(), namespace);
    }

    private static boolean isTagStructurePdf2(PdfNamespace namespace) {
        return namespace != null && "http://iso.org/pdf2/ssn".equals(namespace.getNamespaceName());
    }

    private static PdfName transformTextAlignmentValueToName(TextAlignment textAlignment) {
        boolean isLeftToRight = true;
        switch (textAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Start;
                }
                return PdfName.End;
            }
            case CENTER: {
                return PdfName.Center;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.End;
                }
                return PdfName.Start;
            }
            case JUSTIFIED: 
            case JUSTIFIED_ALL: {
                return PdfName.Justify;
            }
        }
        return PdfName.Start;
    }

    private static PdfName transformBlockAlignToName(HorizontalAlignment horizontalAlignment) {
        boolean isLeftToRight = true;
        switch (horizontalAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Before;
                }
                return PdfName.After;
            }
            case CENTER: {
                return PdfName.Middle;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.After;
                }
                return PdfName.Before;
            }
        }
        return PdfName.Before;
    }

    private static PdfName transformBorderTypeToName(int borderType) {
        switch (borderType) {
            case 0: {
                return PdfName.Solid;
            }
            case 1: {
                return PdfName.Dashed;
            }
            case 2: {
                return PdfName.Dotted;
            }
            case 4: {
                return PdfName.Dotted;
            }
            case 3: {
                return PdfName.Double;
            }
            case 5: {
                return PdfName.Groove;
            }
            case 6: {
                return PdfName.Inset;
            }
            case 7: {
                return PdfName.Outset;
            }
            case 8: {
                return PdfName.Ridge;
            }
        }
        return PdfName.Solid;
    }

    private static PdfName transformNumberingTypeToName(ListNumberingType numberingType, boolean isTagStructurePdf2) {
        switch (numberingType) {
            case DECIMAL: 
            case DECIMAL_LEADING_ZERO: {
                return PdfName.Decimal;
            }
            case ROMAN_UPPER: {
                return PdfName.UpperRoman;
            }
            case ROMAN_LOWER: {
                return PdfName.LowerRoman;
            }
            case ENGLISH_UPPER: 
            case GREEK_UPPER: {
                return PdfName.UpperAlpha;
            }
            case ENGLISH_LOWER: 
            case GREEK_LOWER: {
                return PdfName.LowerAlpha;
            }
        }
        if (isTagStructurePdf2) {
            return PdfName.Ordered;
        }
        return PdfName.None;
    }
}

