/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.property.BackgroundImage;
import com.itextpdf.layout.property.BackgroundSize;
import com.itextpdf.layout.property.UnitValue;

final class BackgroundSizeCalculationUtil {
    private static final int PERCENT_100 = 100;
    private static final UnitValue PERCENT_VALUE_100 = UnitValue.createPercentValue(100.0f);

    private BackgroundSizeCalculationUtil() {
    }

    public static float[] calculateBackgroundImageSize(BackgroundImage image, float areaWidth, float areaHeight) {
        boolean needScale;
        boolean isGradient = image.getLinearGradientBuilder() != null;
        BackgroundSize size = !isGradient && image.getBackgroundSize().isSpecificSize() ? BackgroundSizeCalculationUtil.calculateBackgroundSizeForArea(image, areaWidth, areaHeight) : image.getBackgroundSize();
        UnitValue width = size.getBackgroundWidthSize();
        UnitValue height = size.getBackgroundHeightSize();
        Float[] widthAndHeight = new Float[2];
        if (width != null && width.getValue() >= 0.0f) {
            needScale = !isGradient && height == null;
            BackgroundSizeCalculationUtil.calculateBackgroundWidth(width, areaWidth, needScale, image, widthAndHeight);
        }
        if (height != null && height.getValue() >= 0.0f) {
            needScale = !isGradient && width == null;
            BackgroundSizeCalculationUtil.calculateBackgroundHeight(height, areaHeight, needScale, image, widthAndHeight);
        }
        BackgroundSizeCalculationUtil.setDefaultSizeIfNull(widthAndHeight, areaWidth, areaHeight, image, isGradient);
        return new float[]{widthAndHeight[0].floatValue(), widthAndHeight[1].floatValue()};
    }

    private static BackgroundSize calculateBackgroundSizeForArea(BackgroundImage image, float areaWidth, float areaHeight) {
        double widthDifference = areaWidth / image.getImageWidth();
        double heightDifference = areaHeight / image.getImageHeight();
        if (image.getBackgroundSize().isCover()) {
            return BackgroundSizeCalculationUtil.createSizeWithMaxValueSide(widthDifference > heightDifference);
        }
        if (image.getBackgroundSize().isContain()) {
            return BackgroundSizeCalculationUtil.createSizeWithMaxValueSide(widthDifference < heightDifference);
        }
        return new BackgroundSize();
    }

    private static BackgroundSize createSizeWithMaxValueSide(boolean maxWidth) {
        BackgroundSize size = new BackgroundSize();
        if (maxWidth) {
            size.setBackgroundSizeToValues(PERCENT_VALUE_100, null);
        } else {
            size.setBackgroundSizeToValues(null, PERCENT_VALUE_100);
        }
        return size;
    }

    private static void calculateBackgroundWidth(UnitValue width, float areaWidth, boolean scale, BackgroundImage image, Float[] widthAndHeight) {
        if (scale) {
            if (width.isPercentValue()) {
                BackgroundSizeCalculationUtil.scaleWidth(areaWidth * width.getValue() / 100.0f, image, widthAndHeight);
            } else {
                BackgroundSizeCalculationUtil.scaleWidth(width.getValue(), image, widthAndHeight);
            }
        } else {
            widthAndHeight[0] = width.isPercentValue() ? Float.valueOf(areaWidth * width.getValue() / 100.0f) : Float.valueOf(width.getValue());
        }
    }

    private static void calculateBackgroundHeight(UnitValue height, float areaHeight, boolean scale, BackgroundImage image, Float[] widthAndHeight) {
        if (scale) {
            if (height.isPercentValue()) {
                BackgroundSizeCalculationUtil.scaleHeight(areaHeight * height.getValue() / 100.0f, image, widthAndHeight);
            } else {
                BackgroundSizeCalculationUtil.scaleHeight(height.getValue(), image, widthAndHeight);
            }
        } else {
            widthAndHeight[1] = height.isPercentValue() ? Float.valueOf(areaHeight * height.getValue() / 100.0f) : Float.valueOf(height.getValue());
        }
    }

    private static void scaleWidth(float newWidth, BackgroundImage image, Float[] imageWidthAndHeight) {
        float difference = image.getImageWidth() == 0.0f ? 1.0f : newWidth / image.getImageWidth();
        imageWidthAndHeight[0] = Float.valueOf(newWidth);
        imageWidthAndHeight[1] = Float.valueOf(image.getImageHeight() * difference);
    }

    private static void scaleHeight(float newHeight, BackgroundImage image, Float[] imageWidthAndHeight) {
        float difference = image.getImageHeight() == 0.0f ? 1.0f : newHeight / image.getImageHeight();
        imageWidthAndHeight[0] = Float.valueOf(image.getImageWidth() * difference);
        imageWidthAndHeight[1] = Float.valueOf(newHeight);
    }

    private static void setDefaultSizeIfNull(Float[] widthAndHeight, float areaWidth, float areaHeight, BackgroundImage image, boolean isGradient) {
        if (isGradient) {
            widthAndHeight[0] = Float.valueOf(widthAndHeight[0] == null ? areaWidth : widthAndHeight[0].floatValue());
            widthAndHeight[1] = Float.valueOf(widthAndHeight[1] == null ? areaHeight : widthAndHeight[1].floatValue());
        } else {
            widthAndHeight[0] = Float.valueOf(widthAndHeight[0] == null ? image.getImageWidth() : widthAndHeight[0].floatValue());
            widthAndHeight[1] = Float.valueOf(widthAndHeight[1] == null ? image.getImageHeight() : widthAndHeight[1].floatValue());
        }
    }
}

