/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.margincollapse;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.margincollapse.MarginsCollapse;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarginsCollapseHandler {
    private IRenderer renderer;
    private MarginsCollapseInfo collapseInfo;
    private MarginsCollapseInfo childMarginInfo;
    private MarginsCollapseInfo prevChildMarginInfo;
    private int firstNotEmptyKidIndex = 0;
    private int processedChildrenNum = 0;
    private List<IRenderer> rendererChildren = new ArrayList<IRenderer>();
    private Rectangle backupLayoutBox;
    private MarginsCollapseInfo backupCollapseInfo;
    private boolean lastKidCollapsedAfterHasClearanceApplied;

    public MarginsCollapseHandler(IRenderer renderer, MarginsCollapseInfo marginsCollapseInfo) {
        this.renderer = renderer;
        this.collapseInfo = marginsCollapseInfo != null ? marginsCollapseInfo : new MarginsCollapseInfo();
    }

    public void processFixedHeightAdjustment(float heightDelta) {
        this.collapseInfo.setBufferSpaceOnTop(this.collapseInfo.getBufferSpaceOnTop() + heightDelta);
        this.collapseInfo.setBufferSpaceOnBottom(this.collapseInfo.getBufferSpaceOnBottom() + heightDelta);
    }

    public MarginsCollapseInfo startChildMarginsHandling(IRenderer child, Rectangle layoutBox) {
        if (this.backupLayoutBox != null) {
            this.restoreLayoutBoxAfterFailedLayoutAttempt(layoutBox);
            this.removeRendererChild(--this.processedChildrenNum);
            this.childMarginInfo = null;
        }
        this.rendererChildren.add(child);
        int childIndex = this.processedChildrenNum++;
        boolean childIsBlockElement = !MarginsCollapseHandler.rendererIsFloated(child) && MarginsCollapseHandler.isBlockElement(child);
        this.backupLayoutBox = layoutBox.clone();
        this.backupCollapseInfo = new MarginsCollapseInfo();
        this.collapseInfo.copyTo(this.backupCollapseInfo);
        this.prepareBoxForLayoutAttempt(layoutBox, childIndex, childIsBlockElement);
        if (childIsBlockElement) {
            this.childMarginInfo = this.createMarginsInfoForBlockChild(childIndex);
        }
        return this.childMarginInfo;
    }

    public void applyClearance(float clearHeightCorrection) {
        this.collapseInfo.setClearanceApplied(true);
        this.collapseInfo.getCollapseBefore().joinMargin(clearHeightCorrection);
    }

    private MarginsCollapseInfo createMarginsInfoForBlockChild(int childIndex) {
        MarginsCollapse childCollapseBefore;
        boolean ignoreChildTopMargin = false;
        boolean ignoreChildBottomMargin = MarginsCollapseHandler.lastChildMarginAdjoinedToParent(this.renderer);
        if (childIndex == this.firstNotEmptyKidIndex) {
            ignoreChildTopMargin = MarginsCollapseHandler.firstChildMarginAdjoinedToParent(this.renderer);
        }
        if (childIndex == 0) {
            MarginsCollapse parentCollapseBefore = this.collapseInfo.getCollapseBefore();
            childCollapseBefore = ignoreChildTopMargin ? parentCollapseBefore : new MarginsCollapse();
        } else {
            MarginsCollapse prevChildCollapseAfter = this.prevChildMarginInfo != null ? this.prevChildMarginInfo.getOwnCollapseAfter() : null;
            childCollapseBefore = prevChildCollapseAfter != null ? prevChildCollapseAfter : new MarginsCollapse();
        }
        MarginsCollapse parentCollapseAfter = this.collapseInfo.getCollapseAfter().clone();
        MarginsCollapse childCollapseAfter = ignoreChildBottomMargin ? parentCollapseAfter : new MarginsCollapse();
        MarginsCollapseInfo childMarginsInfo = new MarginsCollapseInfo(ignoreChildTopMargin, ignoreChildBottomMargin, childCollapseBefore, childCollapseAfter);
        if (ignoreChildTopMargin && childIndex == this.firstNotEmptyKidIndex) {
            childMarginsInfo.setBufferSpaceOnTop(this.collapseInfo.getBufferSpaceOnTop());
        }
        if (ignoreChildBottomMargin) {
            childMarginsInfo.setBufferSpaceOnBottom(this.collapseInfo.getBufferSpaceOnBottom());
        }
        return childMarginsInfo;
    }

    public void endChildMarginsHandling(Rectangle layoutBox) {
        int childIndex = this.processedChildrenNum - 1;
        if (MarginsCollapseHandler.rendererIsFloated(this.getRendererChild(childIndex))) {
            return;
        }
        if (this.childMarginInfo != null) {
            if (this.firstNotEmptyKidIndex == childIndex && this.childMarginInfo.isSelfCollapsing()) {
                this.firstNotEmptyKidIndex = childIndex + 1;
            }
            this.collapseInfo.setSelfCollapsing(this.collapseInfo.isSelfCollapsing() && this.childMarginInfo.isSelfCollapsing());
            this.lastKidCollapsedAfterHasClearanceApplied = this.childMarginInfo.isSelfCollapsing() && this.childMarginInfo.isClearanceApplied();
        } else {
            this.lastKidCollapsedAfterHasClearanceApplied = false;
            this.collapseInfo.setSelfCollapsing(false);
        }
        if (this.prevChildMarginInfo != null) {
            this.fixPrevChildOccupiedArea(childIndex);
            this.updateCollapseBeforeIfPrevKidIsFirstAndSelfCollapsed(this.prevChildMarginInfo.getOwnCollapseAfter());
        }
        if (this.firstNotEmptyKidIndex == childIndex && MarginsCollapseHandler.firstChildMarginAdjoinedToParent(this.renderer) && !this.collapseInfo.isSelfCollapsing()) {
            this.getRidOfCollapseArtifactsAtopOccupiedArea();
            if (this.childMarginInfo != null) {
                this.processUsedChildBufferSpaceOnTop(layoutBox);
            }
        }
        this.prevChildMarginInfo = this.childMarginInfo;
        this.childMarginInfo = null;
        this.backupLayoutBox = null;
        this.backupCollapseInfo = null;
    }

    public void startMarginsCollapse(Rectangle parentBBox) {
        this.collapseInfo.getCollapseBefore().joinMargin(MarginsCollapseHandler.getModelTopMargin(this.renderer));
        this.collapseInfo.getCollapseAfter().joinMargin(MarginsCollapseHandler.getModelBottomMargin(this.renderer));
        if (!MarginsCollapseHandler.firstChildMarginAdjoinedToParent(this.renderer)) {
            float topIndent = this.collapseInfo.getCollapseBefore().getCollapsedMarginsSize();
            this.applyTopMargin(parentBBox, topIndent);
        }
        if (!MarginsCollapseHandler.lastChildMarginAdjoinedToParent(this.renderer)) {
            float bottomIndent = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize();
            this.applyBottomMargin(parentBBox, bottomIndent);
        }
        MarginsCollapseHandler.ignoreModelTopMargin(this.renderer);
        MarginsCollapseHandler.ignoreModelBottomMargin(this.renderer);
    }

    public void endMarginsCollapse(Rectangle layoutBox) {
        float collapsedMargins;
        if (this.backupLayoutBox != null) {
            this.restoreLayoutBoxAfterFailedLayoutAttempt(layoutBox);
        }
        if (this.prevChildMarginInfo != null) {
            this.updateCollapseBeforeIfPrevKidIsFirstAndSelfCollapsed(this.prevChildMarginInfo.getCollapseAfter());
        }
        boolean couldBeSelfCollapsing = MarginsCollapseHandler.marginsCouldBeSelfCollapsing(this.renderer) && !this.lastKidCollapsedAfterHasClearanceApplied;
        boolean blockHasNoKidsWithContent = this.collapseInfo.isSelfCollapsing();
        if (MarginsCollapseHandler.firstChildMarginAdjoinedToParent(this.renderer) && blockHasNoKidsWithContent && !couldBeSelfCollapsing) {
            this.addNotYetAppliedTopMargin(layoutBox);
        }
        this.collapseInfo.setSelfCollapsing(this.collapseInfo.isSelfCollapsing() && couldBeSelfCollapsing);
        if (!blockHasNoKidsWithContent && this.lastKidCollapsedAfterHasClearanceApplied) {
            this.applySelfCollapsedKidMarginWithClearance(layoutBox);
        }
        boolean lastChildMarginJoinedToParent = this.prevChildMarginInfo != null && this.prevChildMarginInfo.isIgnoreOwnMarginBottom() && !this.lastKidCollapsedAfterHasClearanceApplied;
        MarginsCollapse ownCollapseAfter = lastChildMarginJoinedToParent ? this.prevChildMarginInfo.getOwnCollapseAfter() : new MarginsCollapse();
        ownCollapseAfter.joinMargin(MarginsCollapseHandler.getModelBottomMargin(this.renderer));
        this.collapseInfo.setOwnCollapseAfter(ownCollapseAfter);
        if (this.collapseInfo.isSelfCollapsing()) {
            if (this.prevChildMarginInfo != null) {
                this.collapseInfo.setCollapseAfter(this.prevChildMarginInfo.getCollapseAfter());
            } else {
                this.collapseInfo.getCollapseAfter().joinMargin(this.collapseInfo.getCollapseBefore());
                this.collapseInfo.getOwnCollapseAfter().joinMargin(this.collapseInfo.getCollapseBefore());
            }
            if (!this.collapseInfo.isIgnoreOwnMarginBottom() && !this.collapseInfo.isIgnoreOwnMarginTop()) {
                collapsedMargins = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize();
                MarginsCollapseHandler.overrideModelBottomMargin(this.renderer, collapsedMargins);
            }
        } else {
            float collapsedMargins2;
            MarginsCollapse marginsCollapseBefore = this.collapseInfo.getCollapseBefore();
            if (!this.collapseInfo.isIgnoreOwnMarginTop()) {
                collapsedMargins2 = marginsCollapseBefore.getCollapsedMarginsSize();
                MarginsCollapseHandler.overrideModelTopMargin(this.renderer, collapsedMargins2);
            }
            if (lastChildMarginJoinedToParent) {
                this.collapseInfo.setCollapseAfter(this.prevChildMarginInfo.getCollapseAfter());
            }
            if (!this.collapseInfo.isIgnoreOwnMarginBottom()) {
                collapsedMargins2 = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize();
                MarginsCollapseHandler.overrideModelBottomMargin(this.renderer, collapsedMargins2);
            }
        }
        if (MarginsCollapseHandler.lastChildMarginAdjoinedToParent(this.renderer) && (this.prevChildMarginInfo != null || blockHasNoKidsWithContent)) {
            collapsedMargins = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize();
            this.applyBottomMargin(layoutBox, collapsedMargins);
        }
    }

    private void updateCollapseBeforeIfPrevKidIsFirstAndSelfCollapsed(MarginsCollapse collapseAfter) {
        if (this.prevChildMarginInfo.isSelfCollapsing() && this.prevChildMarginInfo.isIgnoreOwnMarginTop()) {
            this.collapseInfo.getCollapseBefore().joinMargin(collapseAfter);
        }
    }

    private void prepareBoxForLayoutAttempt(Rectangle layoutBox, int childIndex, boolean childIsBlockElement) {
        if (this.prevChildMarginInfo != null) {
            boolean prevChildCanApplyCollapseAfter;
            boolean prevChildHasAppliedCollapseAfter;
            boolean bl = prevChildHasAppliedCollapseAfter = !this.prevChildMarginInfo.isIgnoreOwnMarginBottom() && (!this.prevChildMarginInfo.isSelfCollapsing() || !this.prevChildMarginInfo.isIgnoreOwnMarginTop());
            if (prevChildHasAppliedCollapseAfter) {
                layoutBox.setHeight(layoutBox.getHeight() + this.prevChildMarginInfo.getCollapseAfter().getCollapsedMarginsSize());
            }
            boolean bl2 = prevChildCanApplyCollapseAfter = !this.prevChildMarginInfo.isSelfCollapsing() || !this.prevChildMarginInfo.isIgnoreOwnMarginTop();
            if (!childIsBlockElement && prevChildCanApplyCollapseAfter) {
                MarginsCollapse ownCollapseAfter = this.prevChildMarginInfo.getOwnCollapseAfter();
                float ownCollapsedMargins = ownCollapseAfter == null ? 0.0f : ownCollapseAfter.getCollapsedMarginsSize();
                layoutBox.setHeight(layoutBox.getHeight() - ownCollapsedMargins);
            }
        } else if (childIndex > this.firstNotEmptyKidIndex && MarginsCollapseHandler.lastChildMarginAdjoinedToParent(this.renderer)) {
            float bottomIndent = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize() - this.collapseInfo.getUsedBufferSpaceOnBottom();
            this.collapseInfo.setBufferSpaceOnBottom(this.collapseInfo.getBufferSpaceOnBottom() + this.collapseInfo.getUsedBufferSpaceOnBottom());
            this.collapseInfo.setUsedBufferSpaceOnBottom(0.0f);
            layoutBox.setY(layoutBox.getY() - bottomIndent);
            layoutBox.setHeight(layoutBox.getHeight() + bottomIndent);
        }
        if (!childIsBlockElement) {
            if (childIndex == this.firstNotEmptyKidIndex && MarginsCollapseHandler.firstChildMarginAdjoinedToParent(this.renderer)) {
                float topIndent = this.collapseInfo.getCollapseBefore().getCollapsedMarginsSize();
                this.applyTopMargin(layoutBox, topIndent);
            }
            if (MarginsCollapseHandler.lastChildMarginAdjoinedToParent(this.renderer)) {
                float bottomIndent = this.collapseInfo.getCollapseAfter().getCollapsedMarginsSize();
                this.applyBottomMargin(layoutBox, bottomIndent);
            }
        }
    }

    private void restoreLayoutBoxAfterFailedLayoutAttempt(Rectangle layoutBox) {
        layoutBox.setX(this.backupLayoutBox.getX()).setY(this.backupLayoutBox.getY()).setWidth(this.backupLayoutBox.getWidth()).setHeight(this.backupLayoutBox.getHeight());
        this.backupCollapseInfo.copyTo(this.collapseInfo);
        this.backupLayoutBox = null;
        this.backupCollapseInfo = null;
    }

    private void applyTopMargin(Rectangle box, float topIndent) {
        float bufferLeftoversOnTop = this.collapseInfo.getBufferSpaceOnTop() - topIndent;
        float usedTopBuffer = bufferLeftoversOnTop > 0.0f ? topIndent : this.collapseInfo.getBufferSpaceOnTop();
        this.collapseInfo.setUsedBufferSpaceOnTop(usedTopBuffer);
        this.subtractUsedTopBufferFromBottomBuffer(usedTopBuffer);
        if (bufferLeftoversOnTop >= 0.0f) {
            this.collapseInfo.setBufferSpaceOnTop(bufferLeftoversOnTop);
            box.moveDown(topIndent);
        } else {
            box.moveDown(this.collapseInfo.getBufferSpaceOnTop());
            this.collapseInfo.setBufferSpaceOnTop(0.0f);
            box.setHeight(box.getHeight() + bufferLeftoversOnTop);
        }
    }

    private void applyBottomMargin(Rectangle box, float bottomIndent) {
        float bottomIndentLeftovers = bottomIndent - this.collapseInfo.getBufferSpaceOnBottom();
        if (bottomIndentLeftovers < 0.0f) {
            this.collapseInfo.setUsedBufferSpaceOnBottom(bottomIndent);
            this.collapseInfo.setBufferSpaceOnBottom(-bottomIndentLeftovers);
        } else {
            this.collapseInfo.setUsedBufferSpaceOnBottom(this.collapseInfo.getBufferSpaceOnBottom());
            this.collapseInfo.setBufferSpaceOnBottom(0.0f);
            box.setY(box.getY() + bottomIndentLeftovers);
            box.setHeight(box.getHeight() - bottomIndentLeftovers);
        }
    }

    private void processUsedChildBufferSpaceOnTop(Rectangle layoutBox) {
        float childUsedBufferSpaceOnTop = this.childMarginInfo.getUsedBufferSpaceOnTop();
        if (childUsedBufferSpaceOnTop > 0.0f) {
            if (childUsedBufferSpaceOnTop > this.collapseInfo.getBufferSpaceOnTop()) {
                childUsedBufferSpaceOnTop = this.collapseInfo.getBufferSpaceOnTop();
            }
            this.collapseInfo.setBufferSpaceOnTop(this.collapseInfo.getBufferSpaceOnTop() - childUsedBufferSpaceOnTop);
            this.collapseInfo.setUsedBufferSpaceOnTop(childUsedBufferSpaceOnTop);
            layoutBox.moveDown(childUsedBufferSpaceOnTop);
            this.subtractUsedTopBufferFromBottomBuffer(childUsedBufferSpaceOnTop);
        }
    }

    private void subtractUsedTopBufferFromBottomBuffer(float usedTopBuffer) {
        if (this.collapseInfo.getBufferSpaceOnTop() > this.collapseInfo.getBufferSpaceOnBottom()) {
            float bufferLeftoversOnTop = this.collapseInfo.getBufferSpaceOnTop() - usedTopBuffer;
            if (bufferLeftoversOnTop < this.collapseInfo.getBufferSpaceOnBottom()) {
                this.collapseInfo.setBufferSpaceOnBottom(bufferLeftoversOnTop);
            }
        } else {
            this.collapseInfo.setBufferSpaceOnBottom(this.collapseInfo.getBufferSpaceOnBottom() - usedTopBuffer);
        }
    }

    private void fixPrevChildOccupiedArea(int childIndex) {
        boolean prevChildCanApplyCollapseAfter;
        boolean prevChildHasAppliedCollapseAfter;
        IRenderer prevRenderer = this.getRendererChild(childIndex - 1);
        Rectangle bBox = prevRenderer.getOccupiedArea().getBBox();
        boolean bl = prevChildHasAppliedCollapseAfter = !this.prevChildMarginInfo.isIgnoreOwnMarginBottom() && (!this.prevChildMarginInfo.isSelfCollapsing() || !this.prevChildMarginInfo.isIgnoreOwnMarginTop());
        if (prevChildHasAppliedCollapseAfter) {
            float bottomMargin = this.prevChildMarginInfo.getCollapseAfter().getCollapsedMarginsSize();
            bBox.setHeight(bBox.getHeight() - bottomMargin);
            bBox.moveUp(bottomMargin);
            MarginsCollapseHandler.ignoreModelBottomMargin(prevRenderer);
        }
        boolean isNotBlockChild = !MarginsCollapseHandler.isBlockElement(this.getRendererChild(childIndex));
        boolean bl2 = prevChildCanApplyCollapseAfter = !this.prevChildMarginInfo.isSelfCollapsing() || !this.prevChildMarginInfo.isIgnoreOwnMarginTop();
        if (isNotBlockChild && prevChildCanApplyCollapseAfter) {
            float ownCollapsedMargins = this.prevChildMarginInfo.getOwnCollapseAfter().getCollapsedMarginsSize();
            bBox.setHeight(bBox.getHeight() + ownCollapsedMargins);
            bBox.moveDown(ownCollapsedMargins);
            MarginsCollapseHandler.overrideModelBottomMargin(prevRenderer, ownCollapsedMargins);
        }
    }

    private void addNotYetAppliedTopMargin(Rectangle layoutBox) {
        float indentTop = this.collapseInfo.getCollapseBefore().getCollapsedMarginsSize();
        this.renderer.getOccupiedArea().getBBox().moveDown(indentTop);
        this.applyTopMargin(layoutBox, indentTop);
    }

    private void applySelfCollapsedKidMarginWithClearance(Rectangle layoutBox) {
        float clearedKidMarginWithClearance = this.prevChildMarginInfo.getOwnCollapseAfter().getCollapsedMarginsSize();
        this.renderer.getOccupiedArea().getBBox().increaseHeight(clearedKidMarginWithClearance).moveDown(clearedKidMarginWithClearance);
        layoutBox.decreaseHeight(clearedKidMarginWithClearance);
    }

    private IRenderer getRendererChild(int index) {
        return this.rendererChildren.get(index);
    }

    private IRenderer removeRendererChild(int index) {
        return this.rendererChildren.remove(index);
    }

    private void getRidOfCollapseArtifactsAtopOccupiedArea() {
        Rectangle bBox = this.renderer.getOccupiedArea().getBBox();
        bBox.setHeight(bBox.getHeight() - this.collapseInfo.getCollapseBefore().getCollapsedMarginsSize());
    }

    private static boolean marginsCouldBeSelfCollapsing(IRenderer renderer) {
        return !(renderer instanceof TableRenderer) && !MarginsCollapseHandler.rendererIsFloated(renderer) && !MarginsCollapseHandler.hasBottomBorders(renderer) && !MarginsCollapseHandler.hasTopBorders(renderer) && !MarginsCollapseHandler.hasBottomPadding(renderer) && !MarginsCollapseHandler.hasTopPadding(renderer) && !MarginsCollapseHandler.hasPositiveHeight(renderer) && (!MarginsCollapseHandler.isBlockElement(renderer) || !(renderer instanceof AbstractRenderer) || !(((AbstractRenderer)renderer).getParent() instanceof LineRenderer));
    }

    private static boolean firstChildMarginAdjoinedToParent(IRenderer parent) {
        return !(parent instanceof RootRenderer) && !(parent instanceof TableRenderer) && !(parent instanceof CellRenderer) && !MarginsCollapseHandler.rendererIsFloated(parent) && !MarginsCollapseHandler.hasTopBorders(parent) && !MarginsCollapseHandler.hasTopPadding(parent);
    }

    private static boolean lastChildMarginAdjoinedToParent(IRenderer parent) {
        return !(parent instanceof RootRenderer) && !(parent instanceof TableRenderer) && !(parent instanceof CellRenderer) && !MarginsCollapseHandler.rendererIsFloated(parent) && !MarginsCollapseHandler.hasBottomBorders(parent) && !MarginsCollapseHandler.hasBottomPadding(parent) && !MarginsCollapseHandler.hasHeightProp(parent);
    }

    private static boolean isBlockElement(IRenderer renderer) {
        return renderer instanceof BlockRenderer || renderer instanceof TableRenderer;
    }

    private static boolean hasHeightProp(IRenderer renderer) {
        return renderer.getModelElement().hasProperty(27);
    }

    private static boolean hasPositiveHeight(IRenderer renderer) {
        float height = renderer.getOccupiedArea().getBBox().getHeight();
        if (height == 0.0f) {
            UnitValue heightPropVal = (UnitValue)renderer.getProperty(27);
            UnitValue minHeightPropVal = (UnitValue)renderer.getProperty(85);
            height = minHeightPropVal != null ? minHeightPropVal.getValue() : (heightPropVal != null ? heightPropVal.getValue() : 0.0f);
        }
        return height > 0.0f;
    }

    private static boolean hasTopPadding(IRenderer renderer) {
        UnitValue padding = (UnitValue)renderer.getModelElement().getProperty(50);
        if (null != padding && !padding.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MarginsCollapseHandler.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{50}));
        }
        return padding != null && padding.getValue() > 0.0f;
    }

    private static boolean hasBottomPadding(IRenderer renderer) {
        UnitValue padding = (UnitValue)renderer.getModelElement().getProperty(47);
        if (null != padding && !padding.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MarginsCollapseHandler.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{47}));
        }
        return padding != null && padding.getValue() > 0.0f;
    }

    private static boolean hasTopBorders(IRenderer renderer) {
        IPropertyContainer modelElement = renderer.getModelElement();
        return modelElement.hasProperty(13) || modelElement.hasProperty(9);
    }

    private static boolean hasBottomBorders(IRenderer renderer) {
        IPropertyContainer modelElement = renderer.getModelElement();
        return modelElement.hasProperty(10) || modelElement.hasProperty(9);
    }

    private static boolean rendererIsFloated(IRenderer renderer) {
        if (renderer == null) {
            return false;
        }
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)renderer.getProperty(99));
        return floatPropertyValue != null && !floatPropertyValue.equals((Object)FloatPropertyValue.NONE);
    }

    private static float getModelTopMargin(IRenderer renderer) {
        UnitValue marginUV = (UnitValue)renderer.getModelElement().getProperty(46);
        if (null != marginUV && !marginUV.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MarginsCollapseHandler.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{46}));
        }
        return marginUV != null && !(renderer instanceof CellRenderer) ? marginUV.getValue() : 0.0f;
    }

    private static void ignoreModelTopMargin(IRenderer renderer) {
        renderer.setProperty(46, UnitValue.createPointValue(0.0f));
    }

    private static void overrideModelTopMargin(IRenderer renderer, float collapsedMargins) {
        renderer.setProperty(46, UnitValue.createPointValue(collapsedMargins));
    }

    private static float getModelBottomMargin(IRenderer renderer) {
        UnitValue marginUV = (UnitValue)renderer.getModelElement().getProperty(43);
        if (null != marginUV && !marginUV.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(MarginsCollapseHandler.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{46}));
        }
        return marginUV != null && !(renderer instanceof CellRenderer) ? marginUV.getValue() : 0.0f;
    }

    private static void ignoreModelBottomMargin(IRenderer renderer) {
        renderer.setProperty(43, UnitValue.createPointValue(0.0f));
    }

    private static void overrideModelBottomMargin(IRenderer renderer, float collapsedMargins) {
        renderer.setProperty(43, UnitValue.createPointValue(collapsedMargins));
    }
}

