/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public class DoubleBorder
extends Border {
    public DoubleBorder(float width) {
        super(width);
    }

    public DoubleBorder(Color color, float width) {
        super(color, width);
    }

    public DoubleBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        float thirdOfWidth = this.width / 3.0f;
        float thirdOfWidthBefore = borderWidthBefore / 3.0f;
        float thirdOfWidthAfter = borderWidthAfter / 3.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + thirdOfWidthAfter;
                y3 = y2 + thirdOfWidth;
                x4 = x1 - thirdOfWidthBefore;
                y4 = y1 + thirdOfWidth;
                break;
            }
            case RIGHT: {
                x3 = x2 + thirdOfWidth;
                y3 = y2 - thirdOfWidthAfter;
                x4 = x1 + thirdOfWidth;
                y4 = y1 + thirdOfWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - thirdOfWidthAfter;
                y3 = y2 - thirdOfWidth;
                x4 = x1 + thirdOfWidthBefore;
                y4 = y1 - thirdOfWidth;
                break;
            }
            case LEFT: {
                x3 = x2 - thirdOfWidth;
                y3 = y2 + thirdOfWidthAfter;
                x4 = x1 - thirdOfWidth;
                y4 = y1 - thirdOfWidthBefore;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).lineTo((double)x3, (double)y3).lineTo((double)x4, (double)y4).lineTo((double)x1, (double)y1).fill();
        switch (borderSide) {
            case TOP: {
                x2 += 2.0f * thirdOfWidthAfter;
                y2 += 2.0f * thirdOfWidth;
                x3 += 2.0f * thirdOfWidthAfter;
                y3 += 2.0f * thirdOfWidth;
                x4 -= 2.0f * thirdOfWidthBefore;
                y4 += 2.0f * thirdOfWidth;
                x1 -= 2.0f * thirdOfWidthBefore;
                y1 += 2.0f * thirdOfWidth;
                break;
            }
            case RIGHT: {
                x2 += 2.0f * thirdOfWidth;
                y2 -= 2.0f * thirdOfWidthAfter;
                x3 += 2.0f * thirdOfWidth;
                y3 -= 2.0f * thirdOfWidthAfter;
                x4 += 2.0f * thirdOfWidth;
                y4 += 2.0f * thirdOfWidthBefore;
                x1 += 2.0f * thirdOfWidth;
                y1 += 2.0f * thirdOfWidthBefore;
                break;
            }
            case BOTTOM: {
                x2 -= 2.0f * thirdOfWidthAfter;
                y2 -= 2.0f * thirdOfWidth;
                x3 -= 2.0f * thirdOfWidthAfter;
                y3 -= 2.0f * thirdOfWidth;
                x4 += 2.0f * thirdOfWidthBefore;
                y4 -= 2.0f * thirdOfWidth;
                x1 += 2.0f * thirdOfWidthBefore;
                y1 -= 2.0f * thirdOfWidth;
                break;
            }
            case LEFT: {
                x2 -= 2.0f * thirdOfWidth;
                y2 += 2.0f * thirdOfWidthAfter;
                x3 -= 2.0f * thirdOfWidth;
                y3 += 2.0f * thirdOfWidthAfter;
                x4 -= 2.0f * thirdOfWidth;
                y4 -= 2.0f * thirdOfWidthBefore;
                x1 -= 2.0f * thirdOfWidth;
                y1 -= 2.0f * thirdOfWidthBefore;
            }
        }
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).lineTo((double)x3, (double)y3).lineTo((double)x4, (double)y4).lineTo((double)x1, (double)y1).fill().restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderRadius, Border.Side side, float borderWidthBefore, float borderWidthAfter) {
        this.draw(canvas, x1, y1, x2, y2, borderWidthBefore, borderWidthAfter);
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        float thirdOfWidth = this.width / 3.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                y2 = y1 -= thirdOfWidth;
                break;
            }
            case RIGHT: {
                x1 -= thirdOfWidth;
                x2 -= thirdOfWidth;
                y1 += thirdOfWidth;
                y2 -= thirdOfWidth;
                break;
            }
            case BOTTOM: {
                break;
            }
        }
        canvas.saveState().setLineWidth(thirdOfWidth).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
        switch (borderSide) {
            case TOP: {
                y2 += 2.0f * thirdOfWidth;
                y1 += 2.0f * thirdOfWidth;
                break;
            }
            case RIGHT: {
                x2 += 2.0f * thirdOfWidth;
                x1 += 2.0f * thirdOfWidth;
                break;
            }
            case BOTTOM: {
                x2 -= 2.0f * thirdOfWidth;
                y2 -= 2.0f * thirdOfWidth;
                x1 += 2.0f * thirdOfWidth;
                y1 -= 2.0f * thirdOfWidth;
                break;
            }
            case LEFT: {
                y2 += 2.0f * thirdOfWidth;
                x1 -= 2.0f * thirdOfWidth;
                y1 -= 2.0f * thirdOfWidth;
            }
        }
        canvas.saveState().setLineWidth(thirdOfWidth).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }
}

