/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.navigation;

import com.itextpdf.kernel.pdf.IPdfNameTreeAccess;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitRemoteGoToDestination;
import com.itextpdf.kernel.pdf.navigation.PdfNamedDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStringDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStructureDestination;

public abstract class PdfDestination
extends PdfObjectWrapper<PdfObject> {
    protected PdfDestination(PdfObject pdfObject) {
        super(pdfObject);
    }

    public abstract PdfObject getDestinationPage(IPdfNameTreeAccess var1);

    public static PdfDestination makeDestination(PdfObject pdfObject) {
        return PdfDestination.makeDestination(pdfObject, true);
    }

    public static PdfDestination makeDestination(PdfObject pdfObject, boolean throwException) {
        if (pdfObject.getType() == 10) {
            return new PdfStringDestination((PdfString)pdfObject);
        }
        if (pdfObject.getType() == 6) {
            return new PdfNamedDestination((PdfName)pdfObject);
        }
        if (pdfObject.getType() == 1) {
            PdfArray destArray = (PdfArray)pdfObject;
            if (destArray.isEmpty()) {
                if (throwException) {
                    throw new IllegalArgumentException();
                }
                return null;
            }
            PdfObject firstObj = destArray.get(0);
            if (firstObj.isNumber()) {
                return new PdfExplicitRemoteGoToDestination(destArray);
            }
            if (firstObj.isDictionary() && PdfName.Page.equals(((PdfDictionary)firstObj).getAsName(PdfName.Type))) {
                return new PdfExplicitDestination(destArray);
            }
            return new PdfStructureDestination(destArray);
        }
        if (throwException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }
}

