/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.mac.MacProperties;
import java.security.SecureRandom;
import java.security.cert.Certificate;

public class EncryptionProperties {
    protected int encryptionAlgorithm;
    protected byte[] userPassword;
    protected byte[] ownerPassword;
    protected int standardEncryptPermissions;
    protected Certificate[] publicCertificates;
    protected int[] publicKeyEncryptPermissions;
    protected MacProperties macProperties;
    static final MacProperties DEFAULT_MAC_PROPERTIES = new MacProperties(MacProperties.MacDigestAlgorithm.SHA3_512);

    public EncryptionProperties setStandardEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, int encryptionAlgorithm) {
        return this.setStandardEncryption(userPassword, ownerPassword, permissions, encryptionAlgorithm, DEFAULT_MAC_PROPERTIES);
    }

    public EncryptionProperties setStandardEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, int encryptionAlgorithm, MacProperties macProperties) {
        this.clearEncryption();
        this.userPassword = userPassword;
        if (ownerPassword != null) {
            this.ownerPassword = ownerPassword;
        } else {
            this.ownerPassword = new byte[16];
            EncryptionProperties.randomBytes(this.ownerPassword);
        }
        this.standardEncryptPermissions = permissions;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.macProperties = macProperties;
        return this;
    }

    public EncryptionProperties setPublicKeyEncryption(Certificate[] certs, int[] permissions, int encryptionAlgorithm, MacProperties macProperties) {
        this.clearEncryption();
        this.publicCertificates = certs;
        this.publicKeyEncryptPermissions = permissions;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.macProperties = macProperties;
        return this;
    }

    boolean isStandardEncryptionUsed() {
        return this.ownerPassword != null;
    }

    boolean isPublicKeyEncryptionUsed() {
        return this.publicCertificates != null;
    }

    private void clearEncryption() {
        this.publicCertificates = null;
        this.publicKeyEncryptPermissions = null;
        this.userPassword = null;
        this.ownerPassword = null;
        this.macProperties = null;
    }

    private static void randomBytes(byte[] bytes) {
        new SecureRandom().nextBytes(bytes);
    }
}

