/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;

public class PdfUserProperty
extends PdfObjectWrapper<PdfDictionary> {
    public PdfUserProperty(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfUserProperty(String name, String value) {
        super(new PdfDictionary());
        this.setName(name);
        this.setValue(value);
    }

    public PdfUserProperty(String name, int value) {
        super(new PdfDictionary());
        this.setName(name);
        this.setValue(value);
    }

    public PdfUserProperty(String name, float value) {
        super(new PdfDictionary());
        this.setName(name);
        this.setValue(value);
    }

    public PdfUserProperty(String name, boolean value) {
        super(new PdfDictionary());
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.N).toUnicodeString();
    }

    public PdfUserProperty setName(String name) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.N, new PdfString(name, "UnicodeBig"));
        return this;
    }

    public ValueType getValueType() {
        PdfObject valObj = ((PdfDictionary)this.getPdfObject()).get(PdfName.V);
        if (valObj == null) {
            return ValueType.UNKNOWN;
        }
        switch (valObj.getType()) {
            case 2: {
                return ValueType.BOOLEAN;
            }
            case 8: {
                return ValueType.NUMBER;
            }
            case 10: {
                return ValueType.TEXT;
            }
        }
        return ValueType.UNKNOWN;
    }

    public PdfUserProperty setValue(String value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfString(value, "UnicodeBig"));
        return this;
    }

    public PdfUserProperty setValue(int value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfNumber(value));
        return this;
    }

    public PdfUserProperty setValue(float value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfNumber(value));
        return this;
    }

    public PdfUserProperty setValue(boolean value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfBoolean(value));
        return this;
    }

    public String getValueAsText() {
        PdfString str = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.V);
        return str != null ? str.toUnicodeString() : null;
    }

    public Float getValueAsFloat() {
        PdfNumber num = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.V);
        return num != null ? Float.valueOf(num.floatValue()) : (Float)null;
    }

    public Boolean getValueAsBool() {
        return ((PdfDictionary)this.getPdfObject()).getAsBool(PdfName.V);
    }

    public String getValueFormattedRepresentation() {
        PdfString f = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.F);
        return f != null ? f.toUnicodeString() : null;
    }

    public PdfUserProperty setValueFormattedRepresentation(String formattedRepresentation) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.F, new PdfString(formattedRepresentation, "UnicodeBig"));
        return this;
    }

    public Boolean isHidden() {
        return ((PdfDictionary)this.getPdfObject()).getAsBool(PdfName.H);
    }

    public PdfUserProperty setHidden(boolean isHidden) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.H, new PdfBoolean(isHidden));
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    public static enum ValueType {
        UNKNOWN,
        TEXT,
        NUMBER,
        BOOLEAN;

    }
}

