/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.IConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.properties.XMPProperty;

public class PdfAConformanceLevel
implements IConformanceLevel {
    public static final PdfAConformanceLevel PDF_A_1A = new PdfAConformanceLevel("1", "A");
    public static final PdfAConformanceLevel PDF_A_1B = new PdfAConformanceLevel("1", "B");
    public static final PdfAConformanceLevel PDF_A_2A = new PdfAConformanceLevel("2", "A");
    public static final PdfAConformanceLevel PDF_A_2B = new PdfAConformanceLevel("2", "B");
    public static final PdfAConformanceLevel PDF_A_2U = new PdfAConformanceLevel("2", "U");
    public static final PdfAConformanceLevel PDF_A_3A = new PdfAConformanceLevel("3", "A");
    public static final PdfAConformanceLevel PDF_A_3B = new PdfAConformanceLevel("3", "B");
    public static final PdfAConformanceLevel PDF_A_3U = new PdfAConformanceLevel("3", "U");
    public static final PdfAConformanceLevel PDF_A_4 = new PdfAConformanceLevel("4", null);
    public static final PdfAConformanceLevel PDF_A_4E = new PdfAConformanceLevel("4", "E");
    public static final PdfAConformanceLevel PDF_A_4F = new PdfAConformanceLevel("4", "F");
    public static final String PDF_A_4_REVISION = "2020";
    private final String conformance;
    private final String part;

    private PdfAConformanceLevel(String part, String conformance) {
        this.conformance = conformance;
        this.part = part;
    }

    public String getConformance() {
        return this.conformance;
    }

    public String getPart() {
        return this.part;
    }

    public static PdfAConformanceLevel getConformanceLevel(String part, String conformance) {
        String lowLetter = conformance == null ? null : conformance.toUpperCase();
        boolean aLevel = "A".equals(lowLetter);
        boolean bLevel = "B".equals(lowLetter);
        boolean uLevel = "U".equals(lowLetter);
        boolean eLevel = "E".equals(lowLetter);
        boolean fLevel = "F".equals(lowLetter);
        switch (part) {
            case "1": {
                if (aLevel) {
                    return PDF_A_1A;
                }
                if (!bLevel) break;
                return PDF_A_1B;
            }
            case "2": {
                if (aLevel) {
                    return PDF_A_2A;
                }
                if (bLevel) {
                    return PDF_A_2B;
                }
                if (!uLevel) break;
                return PDF_A_2U;
            }
            case "3": {
                if (aLevel) {
                    return PDF_A_3A;
                }
                if (bLevel) {
                    return PDF_A_3B;
                }
                if (!uLevel) break;
                return PDF_A_3U;
            }
            case "4": {
                if (eLevel) {
                    return PDF_A_4E;
                }
                if (fLevel) {
                    return PDF_A_4F;
                }
                return PDF_A_4;
            }
        }
        return null;
    }

    public static PdfAConformanceLevel getConformanceLevel(XMPMeta meta) {
        XMPProperty conformanceXmpProperty = null;
        XMPProperty partXmpProperty = null;
        try {
            conformanceXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance");
            partXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "part");
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        if (partXmpProperty == null || conformanceXmpProperty == null && !"4".equals(partXmpProperty.getValue())) {
            return null;
        }
        return PdfAConformanceLevel.getConformanceLevel(partXmpProperty.getValue(), conformanceXmpProperty == null ? null : conformanceXmpProperty.getValue());
    }

    @Deprecated
    public static PdfAConformanceLevel getPDFAConformance(IConformanceLevel possibleConformance, PdfDocument document) {
        if (possibleConformance instanceof PdfAConformanceLevel) {
            return (PdfAConformanceLevel)possibleConformance;
        }
        if (document == null) {
            return null;
        }
        if (document.getConformanceLevel() instanceof PdfAConformanceLevel) {
            return (PdfAConformanceLevel)document.getConformanceLevel();
        }
        return null;
    }
}

