/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OutputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.commons.bouncycastle.asn1.cms.IContentInfo;
import com.itextpdf.commons.bouncycastle.asn1.cms.IEncryptedContentInfo;
import com.itextpdf.commons.bouncycastle.asn1.cms.IEnvelopedData;
import com.itextpdf.commons.bouncycastle.asn1.cms.IIssuerAndSerialNumber;
import com.itextpdf.commons.bouncycastle.asn1.cms.IKeyTransRecipientInfo;
import com.itextpdf.commons.bouncycastle.asn1.cms.IRecipientIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x509.ITBSCertificate;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.crypto.CryptoUtil;
import com.itextpdf.kernel.crypto.securityhandler.EncryptionUtils;
import com.itextpdf.kernel.crypto.securityhandler.PublicKeyRecipient;
import com.itextpdf.kernel.crypto.securityhandler.SecurityHandler;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public abstract class PubKeySecurityHandler
extends SecurityHandler {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final int SEED_LENGTH = 20;
    private List<PublicKeyRecipient> recipients = null;
    private byte[] seed = EncryptionUtils.generateSeed(20);

    protected PubKeySecurityHandler() {
        this.recipients = new ArrayList<PublicKeyRecipient>();
    }

    protected byte[] computeGlobalKey(String messageDigestAlgorithm, boolean encryptMetadata) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(messageDigestAlgorithm);
            md.update(this.getSeed());
            for (int i = 0; i < this.getRecipientsSize(); ++i) {
                byte[] encodedRecipient = this.getEncodedRecipient(i);
                md.update(encodedRecipient);
            }
            if (!encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        return md.digest();
    }

    protected static byte[] computeGlobalKeyOnReading(PdfDictionary encryptionDictionary, PrivateKey certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata, String digestAlgorithm) {
        byte[] encryptionKey;
        PdfArray recipients = encryptionDictionary.getAsArray(PdfName.Recipients);
        if (recipients == null) {
            recipients = encryptionDictionary.getAsDictionary(PdfName.CF).getAsDictionary(PdfName.DefaultCryptFilter).getAsArray(PdfName.Recipients);
        }
        byte[] envelopedData = EncryptionUtils.fetchEnvelopedData(certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, recipients);
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(envelopedData, 0, 20);
            for (int i = 0; i < recipients.size(); ++i) {
                byte[] encodedRecipient = recipients.getAsString(i).getValueBytes();
                md.update(encodedRecipient);
            }
            if (!encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            encryptionKey = md.digest();
        }
        catch (Exception f) {
            throw new PdfException("Exception occurred with PDF document decryption. One of the possible reasons is wrong password or wrong public key certificate and private key.", f);
        }
        return encryptionKey;
    }

    protected void addAllRecipients(Certificate[] certs, int[] permissions) {
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                this.addRecipient(certs[i], permissions[i]);
            }
        }
    }

    protected PdfArray createRecipientsArray() {
        PdfArray recipients;
        try {
            recipients = this.getEncodedRecipients();
        }
        catch (Exception e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        return recipients;
    }

    protected abstract void setPubSecSpecificHandlerDicEntries(PdfDictionary var1, boolean var2, boolean var3);

    protected abstract String getDigestAlgorithm();

    protected abstract void initKey(byte[] var1, int var2);

    protected void initKeyAndFillDictionary(PdfDictionary encryptionDictionary, Certificate[] certs, int[] permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        this.addAllRecipients(certs, permissions);
        Integer keyLen = encryptionDictionary.getAsInt(PdfName.Length);
        int keyLength = keyLen != null ? keyLen : 40;
        String digestAlgorithm = this.getDigestAlgorithm();
        byte[] digest = this.computeGlobalKey(digestAlgorithm, encryptMetadata);
        this.initKey(digest, keyLength);
        this.setPubSecSpecificHandlerDicEntries(encryptionDictionary, encryptMetadata, embeddedFilesOnly);
    }

    protected void initKeyAndReadDictionary(PdfDictionary encryptionDictionary, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess, boolean encryptMetadata) {
        String digestAlgorithm = this.getDigestAlgorithm();
        byte[] encryptionKey = PubKeySecurityHandler.computeGlobalKeyOnReading(encryptionDictionary, (PrivateKey)certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, encryptMetadata, digestAlgorithm);
        Integer keyLen = encryptionDictionary.getAsInt(PdfName.Length);
        int keyLength = keyLen != null ? keyLen : 40;
        this.initKey(encryptionKey, keyLength);
    }

    private void addRecipient(Certificate cert, int permission) {
        this.recipients.add(new PublicKeyRecipient(cert, permission));
    }

    private byte[] getSeed() {
        byte[] clonedSeed = new byte[this.seed.length];
        System.arraycopy(this.seed, 0, clonedSeed, 0, this.seed.length);
        return clonedSeed;
    }

    private int getRecipientsSize() {
        return this.recipients.size();
    }

    private byte[] getEncodedRecipient(int index) throws IOException, GeneralSecurityException {
        PublicKeyRecipient recipient = this.recipients.get(index);
        byte[] cms = recipient.getCms();
        if (cms != null) {
            return cms;
        }
        Certificate certificate = recipient.getCertificate();
        int permission = recipient.getPermission();
        permission |= 0xFFFFF0C0;
        permission &= 0xFFFFFFFC;
        byte[] pkcs7input = new byte[24];
        byte one = (byte)(++permission);
        byte two = (byte)(permission >> 8);
        byte three = (byte)(permission >> 16);
        byte four = (byte)(permission >> 24);
        System.arraycopy(this.seed, 0, pkcs7input, 0, 20);
        pkcs7input[20] = four;
        pkcs7input[21] = three;
        pkcs7input[22] = two;
        pkcs7input[23] = one;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (IASN1OutputStream k = CryptoUtil.createAsn1OutputStream(baos, BOUNCY_CASTLE_FACTORY.createASN1Encoding().getDer());){
            IASN1Primitive obj = this.createDERForRecipient(pkcs7input, (X509Certificate)certificate);
            k.writeObject(obj);
        }
        cms = baos.toByteArray();
        recipient.setCms(cms);
        return cms;
    }

    private PdfArray getEncodedRecipients() {
        PdfArray EncodedRecipients = new PdfArray();
        for (int i = 0; i < this.recipients.size(); ++i) {
            try {
                byte[] cms = this.getEncodedRecipient(i);
                EncodedRecipients.add(new PdfLiteral(StreamUtil.createEscapedString((byte[])cms)));
                continue;
            }
            catch (IOException | GeneralSecurityException e) {
                EncodedRecipients = null;
                break;
            }
        }
        return EncodedRecipients;
    }

    private IASN1Primitive createDERForRecipient(byte[] in, X509Certificate cert) throws IOException, GeneralSecurityException {
        EncryptionUtils.DERForRecipientParams parameters = EncryptionUtils.calculateDERForRecipientParams(in);
        IKeyTransRecipientInfo keytransrecipientinfo = this.computeRecipientInfo(cert, parameters.abyte0);
        IDEROctetString deroctetstring = BOUNCY_CASTLE_FACTORY.createDEROctetString(parameters.abyte1);
        IDERSet derset = BOUNCY_CASTLE_FACTORY.createDERSet(BOUNCY_CASTLE_FACTORY.createRecipientInfo(keytransrecipientinfo));
        IEncryptedContentInfo encryptedcontentinfo = BOUNCY_CASTLE_FACTORY.createEncryptedContentInfo(BOUNCY_CASTLE_FACTORY.createPKCSObjectIdentifiers().getData(), parameters.algorithmIdentifier, (IASN1OctetString)deroctetstring);
        IEnvelopedData env = BOUNCY_CASTLE_FACTORY.createEnvelopedData(BOUNCY_CASTLE_FACTORY.createNullOriginatorInfo(), (IASN1Set)derset, encryptedcontentinfo, BOUNCY_CASTLE_FACTORY.createNullASN1Set());
        IContentInfo contentinfo = BOUNCY_CASTLE_FACTORY.createContentInfo(BOUNCY_CASTLE_FACTORY.createPKCSObjectIdentifiers().getEnvelopedData(), (IASN1Encodable)env);
        return contentinfo.toASN1Primitive();
    }

    private IKeyTransRecipientInfo computeRecipientInfo(X509Certificate x509Certificate, byte[] abyte0) throws GeneralSecurityException, IOException {
        ITBSCertificate tbsCertificate;
        try (IASN1InputStream asn1InputStream = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(x509Certificate.getTBSCertificate()));){
            tbsCertificate = BOUNCY_CASTLE_FACTORY.createTBSCertificate((IASN1Encodable)asn1InputStream.readObject());
        }
        IAlgorithmIdentifier algorithmIdentifier = tbsCertificate.getSubjectPublicKeyInfo().getAlgorithm();
        IIssuerAndSerialNumber issuerAndSerialNumber = BOUNCY_CASTLE_FACTORY.createIssuerAndSerialNumber(tbsCertificate.getIssuer(), tbsCertificate.getSerialNumber().getValue());
        byte[] cipheredBytes = EncryptionUtils.cipherBytes(x509Certificate, abyte0, algorithmIdentifier);
        IDEROctetString derOctetString = BOUNCY_CASTLE_FACTORY.createDEROctetString(cipheredBytes);
        IRecipientIdentifier recipId = BOUNCY_CASTLE_FACTORY.createRecipientIdentifier(issuerAndSerialNumber);
        return BOUNCY_CASTLE_FACTORY.createKeyTransRecipientInfo(recipId, algorithmIdentifier, (IASN1OctetString)derOctetString);
    }
}

