/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.utils.ICopyFilter;
import java.util.Collections;
import java.util.List;

public class DestinationResolverCopyFilter
implements ICopyFilter {
    private static final List<PdfName> EXCLUDE_KEYS_ACTIONCOPY = Collections.singletonList(PdfName.D);
    private final PdfDocument targetDocument;
    private final PdfDocument fromDocument;

    public DestinationResolverCopyFilter(PdfDocument fromDocument, PdfDocument targetDocument) {
        this.fromDocument = fromDocument;
        this.targetDocument = targetDocument;
    }

    @Override
    public boolean shouldProcess(PdfObject newParent, PdfName name, PdfObject value) {
        PdfObject workRef = DestinationResolverCopyFilter.getDirectPdfObject(value);
        if (workRef.getType() == 3) {
            PdfDictionary dict = (PdfDictionary)workRef;
            if (dict.getAsName(PdfName.S) == PdfName.GoTo) {
                this.processAction(newParent, name, dict);
                return false;
            }
            if (PdfName.Link.equals(dict.getAsName(PdfName.Subtype)) && newParent.isDictionary()) {
                return this.processLinkAnnotion(newParent, value, dict);
            }
        }
        return true;
    }

    private boolean processLinkAnnotion(PdfObject newParent, PdfObject value, PdfDictionary dict) {
        if (dict.get(PdfName.Dest) != null) {
            this.fromDocument.storeDestinationToReaddress(PdfDestination.makeDestination(dict.get(PdfName.Dest)), nd -> {
                PdfObject newVal = value.copyTo(this.targetDocument, this);
                new PdfPage((PdfDictionary)newParent).addAnnotation(-1, PdfAnnotation.makeAnnotation(newVal), false);
            }, od -> {});
            return false;
        }
        if (dict.getAsDictionary(PdfName.A) != null && dict.getAsDictionary(PdfName.A).get(PdfName.D) != null) {
            this.fromDocument.storeDestinationToReaddress(PdfDestination.makeDestination(dict.getAsDictionary(PdfName.A).get(PdfName.D)), nd -> {
                PdfObject newAnnot = value.copyTo(this.targetDocument);
                ((PdfDictionary)newAnnot).getAsDictionary(PdfName.A).put(PdfName.D, (PdfObject)nd.getPdfObject());
                new PdfPage((PdfDictionary)newParent).addAnnotation(-1, PdfAnnotation.makeAnnotation(newAnnot), false);
            }, od -> {});
            return false;
        }
        return true;
    }

    private void processAction(PdfObject newParent, PdfName name, PdfDictionary dict) {
        this.fromDocument.storeDestinationToReaddress(PdfDestination.makeDestination(dict.get(PdfName.D)), nd -> {
            PdfDictionary newVal = dict.copyTo(this.targetDocument, EXCLUDE_KEYS_ACTIONCOPY, false);
            newVal.put(PdfName.D, (PdfObject)nd.getPdfObject());
            if (newParent.getType() == 3) {
                ((PdfDictionary)newParent).put(name, newVal);
            } else {
                ((PdfArray)newParent).add(newVal);
            }
        }, od -> {});
    }

    private static PdfObject getDirectPdfObject(PdfObject value) {
        PdfObject workRef = value;
        if (value.isIndirectReference()) {
            workRef = ((PdfIndirectReference)value).getRefersTo();
        }
        return workRef;
    }
}

