/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter;

import com.itextpdf.kernel.counter.context.GenericContext;
import com.itextpdf.kernel.counter.context.IContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextManager {
    private static final ContextManager instance = new ContextManager();
    private static final long SECURITY_ERROR_LOGGING_INTERVAL = 60000L;
    private volatile long securityErrorLastLogged = 0L;
    private final Map<String, IContext> contextMappings = new ConcurrentHashMap<String, IContext>();

    private ContextManager() {
        this.registerGenericContext(Arrays.asList("com.itextpdf.io", "com.itextpdf.kernel", "com.itextpdf.layout", "com.itextpdf.barcodes", "com.itextpdf.pdfa", "com.itextpdf.signatures", "com.itextpdf.forms", "com.itextpdf.styledxmlparser", "com.itextpdf.svg"), Collections.singletonList("com.itextpdf"));
        this.registerGenericContext(Collections.singletonList("com.itextpdf.pdfdebug"), Collections.singletonList("com.itextpdf.pdfdebug"));
        this.registerGenericContext(Collections.singletonList("com.itextpdf.html2pdf"), Collections.singletonList("com.itextpdf.html2pdf"));
        this.registerGenericContext(Collections.singletonList("com.itextpdf.zugferd"), Collections.singletonList("com.itextpdf.zugferd"));
        this.registerGenericContext(Collections.singletonList("com.itextpdf.pdfcleanup"), Collections.singletonList("com.itextpdf.pdfcleanup"));
    }

    public static ContextManager getInstance() {
        return instance;
    }

    public IContext getContext(Class<?> clazz) {
        return clazz != null ? this.getContext(clazz.getName()) : null;
    }

    public IContext getContext(String className) {
        return this.getNamespaceMapping(this.getRecognisedNamespace(className));
    }

    private String getRecognisedNamespace(String className) {
        if (className != null) {
            for (String namespace : this.contextMappings.keySet()) {
                if (!className.toLowerCase().startsWith(namespace)) continue;
                return namespace;
            }
        }
        return null;
    }

    private IContext getNamespaceMapping(String namespace) {
        if (namespace != null) {
            return this.contextMappings.get(namespace);
        }
        return null;
    }

    private void registerGenericContext(Collection<String> namespaces, Collection<String> eventIds) {
        GenericContext context = new GenericContext(eventIds);
        for (String namespace : namespaces) {
            this.registerContext(namespace.toLowerCase(), context);
        }
    }

    private void registerContext(String namespace, IContext context) {
        this.contextMappings.put(namespace, context);
    }
}

