/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter;

import com.itextpdf.kernel.counter.EventCounter;
import com.itextpdf.kernel.counter.context.IContext;
import com.itextpdf.kernel.counter.context.UnknownContext;
import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.EventDataHandler;
import com.itextpdf.kernel.counter.data.EventDataHandlerUtil;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import java.io.Closeable;

public class DataHandlerCounter<T, V extends EventData<T>>
extends EventCounter
implements Closeable {
    private volatile boolean closed = false;
    private final EventDataHandler<T, V> dataHandler;

    public DataHandlerCounter(EventDataHandler<T, V> dataHandler) {
        this(dataHandler, UnknownContext.PERMISSIVE);
    }

    public DataHandlerCounter(EventDataHandler<T, V> dataHandler, IContext fallback) {
        super(fallback);
        this.dataHandler = dataHandler;
        EventDataHandlerUtil.registerProcessAllShutdownHook(this.dataHandler);
        EventDataHandlerUtil.registerTimedProcessing(this.dataHandler);
    }

    @Override
    protected void onEvent(IEvent event, IMetaInfo metaInfo) {
        if (this.closed) {
            throw new IllegalStateException("Data handler counter has been disabled");
        }
        this.dataHandler.register(event, metaInfo);
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            EventDataHandlerUtil.disableShutdownHooks(this.dataHandler);
            EventDataHandlerUtil.disableTimedProcessing(this.dataHandler);
        }
        finally {
            this.dataHandler.tryProcessRest();
        }
    }
}

