/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.xmp.impl;

import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.impl.CountOutputStream;
import com.itextpdf.kernel.xmp.impl.QName;
import com.itextpdf.kernel.xmp.impl.Utils;
import com.itextpdf.kernel.xmp.impl.XMPMetaImpl;
import com.itextpdf.kernel.xmp.impl.XMPNode;
import com.itextpdf.kernel.xmp.impl.XMPNodeUtils;
import com.itextpdf.kernel.xmp.options.SerializeOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class XMPSerializerRDF {
    private static final int DEFAULT_PAD = 2048;
    private static final String PACKET_HEADER = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>";
    private static final String PACKET_TRAILER = "<?xpacket end=\"";
    private static final String PACKET_TRAILER2 = "\"?>";
    private static final String RDF_XMPMETA_START = "<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"";
    private static final String RDF_XMPMETA_END = "</x:xmpmeta>";
    private static final String RDF_RDF_START = "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">";
    private static final String RDF_RDF_END = "</rdf:RDF>";
    private static final String RDF_SCHEMA_START = "<rdf:Description rdf:about=";
    private static final String RDF_SCHEMA_END = "</rdf:Description>";
    private static final String RDF_STRUCT_START = "<rdf:Description";
    private static final String RDF_STRUCT_END = "</rdf:Description>";
    private static final String RDF_EMPTY_STRUCT = "<rdf:Description/>";
    static final Set<String> RDF_ATTR_QUALIFIER = new HashSet<String>(Arrays.asList("xml:lang", "rdf:resource", "rdf:ID", "rdf:bagID", "rdf:nodeID"));
    private XMPMetaImpl xmp;
    private CountOutputStream outputStream;
    private OutputStreamWriter writer;
    private SerializeOptions options;
    private int unicodeSize = 1;
    private int padding;

    public void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        try {
            this.outputStream = new CountOutputStream(out);
            this.xmp = (XMPMetaImpl)xmp;
            this.options = options;
            this.padding = options.getPadding();
            this.writer = new OutputStreamWriter((OutputStream)this.outputStream, options.getEncoding());
            this.checkOptionsConsistence();
            String tailStr = this.serializeAsRDF();
            this.writer.flush();
            this.addPadding(tailStr.length());
            this.write(tailStr);
            this.writer.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new XMPException("Error writing to the OutputStream", 0);
        }
    }

    private void addPadding(int tailLength) throws XMPException, IOException {
        if (this.options.getExactPacketLength()) {
            int minSize = this.outputStream.getBytesWritten() + tailLength * this.unicodeSize;
            if (minSize > this.padding) {
                throw new XMPException("Can't fit into specified packet size", 107);
            }
            this.padding -= minSize;
        }
        this.padding /= this.unicodeSize;
        int newlineLen = this.options.getNewline().length();
        if (this.padding >= newlineLen) {
            this.padding -= newlineLen;
            while (this.padding >= 100 + newlineLen) {
                this.writeChars(100, ' ');
                this.writeNewline();
                this.padding -= 100 + newlineLen;
            }
            this.writeChars(this.padding, ' ');
            this.writeNewline();
        } else {
            this.writeChars(this.padding, ' ');
        }
    }

    protected void checkOptionsConsistence() throws XMPException {
        if (this.options.getEncodeUTF16BE() | this.options.getEncodeUTF16LE()) {
            this.unicodeSize = 2;
        }
        if (this.options.getExactPacketLength()) {
            if (this.options.getOmitPacketWrapper() | this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for exact size serialize", 103);
            }
            if ((this.options.getPadding() & this.unicodeSize - 1) != 0) {
                throw new XMPException("Exact size must be a multiple of the Unicode element", 103);
            }
        } else if (this.options.getReadOnlyPacket()) {
            if (this.options.getOmitPacketWrapper() | this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for read-only packet", 103);
            }
            this.padding = 0;
        } else if (this.options.getOmitPacketWrapper()) {
            if (this.options.getIncludeThumbnailPad()) {
                throw new XMPException("Inconsistent options for non-packet serialize", 103);
            }
            this.padding = 0;
        } else {
            if (this.padding == 0) {
                this.padding = 2048 * this.unicodeSize;
            }
            if (this.options.getIncludeThumbnailPad() && !this.xmp.doesPropertyExist("http://ns.adobe.com/xap/1.0/", "Thumbnails")) {
                this.padding += 10000 * this.unicodeSize;
            }
        }
    }

    private String serializeAsRDF() throws IOException, XMPException {
        int level = 0;
        if (!this.options.getOmitPacketWrapper()) {
            this.writeIndent(level);
            this.write(PACKET_HEADER);
            this.writeNewline();
        }
        if (!this.options.getOmitXmpMetaElement()) {
            this.writeIndent(level);
            this.write(RDF_XMPMETA_START);
            if (!this.options.getOmitVersionAttribute()) {
                this.write(XMPMetaFactory.getVersionInfo().getMessage());
            }
            this.write("\">");
            this.writeNewline();
            ++level;
        }
        this.writeIndent(level);
        this.write(RDF_RDF_START);
        this.writeNewline();
        if (this.options.getUseCanonicalFormat()) {
            this.serializeCanonicalRDFSchemas(level);
        } else {
            this.serializeCompactRDFSchemas(level);
        }
        this.writeIndent(level);
        this.write(RDF_RDF_END);
        this.writeNewline();
        if (!this.options.getOmitXmpMetaElement()) {
            this.writeIndent(--level);
            this.write(RDF_XMPMETA_END);
            this.writeNewline();
        }
        String tailStr = "";
        if (!this.options.getOmitPacketWrapper()) {
            for (level = this.options.getBaseIndent(); level > 0; --level) {
                tailStr = tailStr + this.options.getIndent();
            }
            tailStr = tailStr + PACKET_TRAILER;
            tailStr = tailStr + (this.options.getReadOnlyPacket() ? (char)'r' : 'w');
            tailStr = tailStr + PACKET_TRAILER2;
        }
        return tailStr;
    }

    private void serializeCanonicalRDFSchemas(int level) throws IOException, XMPException {
        if (this.xmp.getRoot().getChildrenLength() > 0) {
            this.startOuterRDFDescription(this.xmp.getRoot(), level);
            Iterator it = this.xmp.getRoot().iterateChildren();
            while (it.hasNext()) {
                XMPNode currSchema = (XMPNode)it.next();
                this.serializeCanonicalRDFSchema(currSchema, level);
            }
            this.endOuterRDFDescription(level);
        } else {
            this.writeIndent(level + 1);
            this.write(RDF_SCHEMA_START);
            this.writeTreeName();
            this.write("/>");
            this.writeNewline();
        }
    }

    private void writeTreeName() throws IOException {
        this.write(34);
        String name = this.xmp.getRoot().getName();
        if (name != null) {
            this.appendNodeValue(name, true);
        }
        this.write(34);
    }

    private void serializeCompactRDFSchemas(int level) throws IOException, XMPException {
        XMPNode schema;
        this.writeIndent(level + 1);
        this.write(RDF_SCHEMA_START);
        this.writeTreeName();
        HashSet<String> usedPrefixes = new HashSet<String>();
        usedPrefixes.add("xml");
        usedPrefixes.add("rdf");
        Iterator it = this.xmp.getRoot().iterateChildren();
        while (it.hasNext()) {
            XMPNode schema2 = (XMPNode)it.next();
            this.declareUsedNamespaces(schema2, usedPrefixes, level + 3);
        }
        boolean allAreAttrs = true;
        Iterator it2 = this.xmp.getRoot().iterateChildren();
        while (it2.hasNext()) {
            schema = (XMPNode)it2.next();
            allAreAttrs &= this.serializeCompactRDFAttrProps(schema, level + 2);
        }
        if (allAreAttrs) {
            this.write("/>");
            this.writeNewline();
            return;
        }
        this.write(62);
        this.writeNewline();
        it2 = this.xmp.getRoot().iterateChildren();
        while (it2.hasNext()) {
            schema = (XMPNode)it2.next();
            this.serializeCompactRDFElementProps(schema, level + 2);
        }
        this.writeIndent(level + 1);
        this.write("</rdf:Description>");
        this.writeNewline();
    }

    private boolean serializeCompactRDFAttrProps(XMPNode parentNode, int indent) throws IOException {
        boolean allAreAttrs = true;
        Iterator it = parentNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode prop = (XMPNode)it.next();
            if (this.canBeRDFAttrProp(prop)) {
                this.writeNewline();
                this.writeIndent(indent);
                this.write(prop.getName());
                this.write("=\"");
                this.appendNodeValue(prop.getValue(), true);
                this.write(34);
                continue;
            }
            allAreAttrs = false;
        }
        return allAreAttrs;
    }

    private void serializeCompactRDFElementProps(XMPNode parentNode, int indent) throws IOException, XMPException {
        Iterator it = parentNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode node = (XMPNode)it.next();
            if (this.canBeRDFAttrProp(node)) continue;
            boolean emitEndTag = true;
            boolean indentEndTag = true;
            String elemName = node.getName();
            if ("[]".equals(elemName)) {
                elemName = "rdf:li";
            }
            this.writeIndent(indent);
            this.write(60);
            this.write(elemName);
            boolean hasGeneralQualifiers = false;
            boolean hasRDFResourceQual = false;
            Iterator iq = node.iterateQualifier();
            while (iq.hasNext()) {
                XMPNode qualifier = (XMPNode)iq.next();
                if (!RDF_ATTR_QUALIFIER.contains(qualifier.getName())) {
                    hasGeneralQualifiers = true;
                    continue;
                }
                hasRDFResourceQual = "rdf:resource".equals(qualifier.getName());
                this.write(32);
                this.write(qualifier.getName());
                this.write("=\"");
                this.appendNodeValue(qualifier.getValue(), true);
                this.write(34);
            }
            if (hasGeneralQualifiers) {
                this.serializeCompactRDFGeneralQualifier(indent, node);
            } else if (!node.getOptions().isCompositeProperty()) {
                boolean[] result = this.serializeCompactRDFSimpleProp(node);
                emitEndTag = result[0];
                indentEndTag = result[1];
            } else if (node.getOptions().isArray()) {
                this.serializeCompactRDFArrayProp(node, indent);
            } else {
                emitEndTag = this.serializeCompactRDFStructProp(node, indent, hasRDFResourceQual);
            }
            if (!emitEndTag) continue;
            if (indentEndTag) {
                this.writeIndent(indent);
            }
            this.write("</");
            this.write(elemName);
            this.write(62);
            this.writeNewline();
        }
    }

    private boolean[] serializeCompactRDFSimpleProp(XMPNode node) throws IOException {
        boolean emitEndTag = true;
        boolean indentEndTag = true;
        if (node.getOptions().isURI()) {
            this.write(" rdf:resource=\"");
            this.appendNodeValue(node.getValue(), true);
            this.write("\"/>");
            this.writeNewline();
            emitEndTag = false;
        } else if (node.getValue() == null || node.getValue().length() == 0) {
            this.write("/>");
            this.writeNewline();
            emitEndTag = false;
        } else {
            this.write(62);
            this.appendNodeValue(node.getValue(), false);
            indentEndTag = false;
        }
        return new boolean[]{emitEndTag, indentEndTag};
    }

    private void serializeCompactRDFArrayProp(XMPNode node, int indent) throws IOException, XMPException {
        this.write(62);
        this.writeNewline();
        this.emitRDFArrayTag(node, true, indent + 1);
        if (node.getOptions().isArrayAltText()) {
            XMPNodeUtils.normalizeLangArray(node);
        }
        this.serializeCompactRDFElementProps(node, indent + 2);
        this.emitRDFArrayTag(node, false, indent + 1);
    }

    private boolean serializeCompactRDFStructProp(XMPNode node, int indent, boolean hasRDFResourceQual) throws XMPException, IOException {
        boolean hasAttrFields = false;
        boolean hasElemFields = false;
        boolean emitEndTag = true;
        Iterator ic = node.iterateChildren();
        while (ic.hasNext()) {
            XMPNode field = (XMPNode)ic.next();
            if (this.canBeRDFAttrProp(field)) {
                hasAttrFields = true;
            } else {
                hasElemFields = true;
            }
            if (!hasAttrFields || !hasElemFields) continue;
            break;
        }
        if (hasRDFResourceQual && hasElemFields) {
            throw new XMPException("Can't mix rdf:resource qualifier and element fields", 202);
        }
        if (!node.hasChildren()) {
            this.write(" rdf:parseType=\"Resource\"/>");
            this.writeNewline();
            emitEndTag = false;
        } else if (!hasElemFields) {
            this.serializeCompactRDFAttrProps(node, indent + 1);
            this.write("/>");
            this.writeNewline();
            emitEndTag = false;
        } else if (!hasAttrFields) {
            this.write(" rdf:parseType=\"Resource\">");
            this.writeNewline();
            this.serializeCompactRDFElementProps(node, indent + 1);
        } else {
            this.write(62);
            this.writeNewline();
            this.writeIndent(indent + 1);
            this.write(RDF_STRUCT_START);
            this.serializeCompactRDFAttrProps(node, indent + 2);
            this.write(">");
            this.writeNewline();
            this.serializeCompactRDFElementProps(node, indent + 1);
            this.writeIndent(indent + 1);
            this.write("</rdf:Description>");
            this.writeNewline();
        }
        return emitEndTag;
    }

    private void serializeCompactRDFGeneralQualifier(int indent, XMPNode node) throws IOException, XMPException {
        this.write(" rdf:parseType=\"Resource\">");
        this.writeNewline();
        this.serializeCanonicalRDFProperty(node, false, true, indent + 1);
        Iterator iq = node.iterateQualifier();
        while (iq.hasNext()) {
            XMPNode qualifier = (XMPNode)iq.next();
            this.serializeCanonicalRDFProperty(qualifier, false, false, indent + 1);
        }
    }

    private void serializeCanonicalRDFSchema(XMPNode schemaNode, int level) throws IOException, XMPException {
        Iterator it = schemaNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode propNode = (XMPNode)it.next();
            this.serializeCanonicalRDFProperty(propNode, this.options.getUseCanonicalFormat(), false, level + 2);
        }
    }

    private void declareUsedNamespaces(XMPNode node, Set<String> usedPrefixes, int indent) throws IOException {
        Iterator it;
        if (node.getOptions().isSchemaNode()) {
            String prefix = node.getValue().substring(0, node.getValue().length() - 1);
            this.declareNamespace(prefix, node.getName(), usedPrefixes, indent);
        } else if (node.getOptions().isStruct()) {
            it = node.iterateChildren();
            while (it.hasNext()) {
                XMPNode field = (XMPNode)it.next();
                this.declareNamespace(field.getName(), null, usedPrefixes, indent);
            }
        }
        it = node.iterateChildren();
        while (it.hasNext()) {
            XMPNode child = (XMPNode)it.next();
            this.declareUsedNamespaces(child, usedPrefixes, indent);
        }
        it = node.iterateQualifier();
        while (it.hasNext()) {
            XMPNode qualifier = (XMPNode)it.next();
            this.declareNamespace(qualifier.getName(), null, usedPrefixes, indent);
            this.declareUsedNamespaces(qualifier, usedPrefixes, indent);
        }
    }

    private void declareNamespace(String prefix, String namespace, Set<String> usedPrefixes, int indent) throws IOException {
        if (namespace == null) {
            QName qname = new QName(prefix);
            if (qname.hasPrefix()) {
                prefix = qname.getPrefix();
                namespace = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(prefix + ":");
                this.declareNamespace(prefix, namespace, usedPrefixes, indent);
            } else {
                return;
            }
        }
        if (!usedPrefixes.contains(prefix)) {
            this.writeNewline();
            this.writeIndent(indent);
            this.write("xmlns:");
            this.write(prefix);
            this.write("=\"");
            this.write(namespace);
            this.write(34);
            usedPrefixes.add(prefix);
        }
    }

    private void startOuterRDFDescription(XMPNode schemaNode, int level) throws IOException {
        this.writeIndent(level + 1);
        this.write(RDF_SCHEMA_START);
        this.writeTreeName();
        HashSet<String> usedPrefixes = new HashSet<String>();
        usedPrefixes.add("xml");
        usedPrefixes.add("rdf");
        this.declareUsedNamespaces(schemaNode, usedPrefixes, level + 3);
        this.write(62);
        this.writeNewline();
    }

    private void endOuterRDFDescription(int level) throws IOException {
        this.writeIndent(level + 1);
        this.write("</rdf:Description>");
        this.writeNewline();
    }

    private void serializeCanonicalRDFProperty(XMPNode node, boolean useCanonicalRDF, boolean emitAsRDFValue, int indent) throws IOException, XMPException {
        XMPNode child;
        XMPNode qualifier;
        boolean emitEndTag = true;
        boolean indentEndTag = true;
        String elemName = node.getName();
        if (emitAsRDFValue) {
            elemName = "rdf:value";
        } else if ("[]".equals(elemName)) {
            elemName = "rdf:li";
        }
        this.writeIndent(indent);
        this.write(60);
        this.write(elemName);
        boolean hasGeneralQualifiers = false;
        boolean hasRDFResourceQual = false;
        Iterator it = node.iterateQualifier();
        while (it.hasNext()) {
            qualifier = (XMPNode)it.next();
            if (!RDF_ATTR_QUALIFIER.contains(qualifier.getName())) {
                hasGeneralQualifiers = true;
                continue;
            }
            hasRDFResourceQual = "rdf:resource".equals(qualifier.getName());
            if (emitAsRDFValue) continue;
            this.write(32);
            this.write(qualifier.getName());
            this.write("=\"");
            this.appendNodeValue(qualifier.getValue(), true);
            this.write(34);
        }
        if (hasGeneralQualifiers && !emitAsRDFValue) {
            if (hasRDFResourceQual) {
                throw new XMPException("Can't mix rdf:resource and general qualifiers", 202);
            }
            if (useCanonicalRDF) {
                this.write(">");
                this.writeNewline();
                this.writeIndent(++indent);
                this.write(RDF_STRUCT_START);
                this.write(">");
            } else {
                this.write(" rdf:parseType=\"Resource\">");
            }
            this.writeNewline();
            this.serializeCanonicalRDFProperty(node, useCanonicalRDF, true, indent + 1);
            it = node.iterateQualifier();
            while (it.hasNext()) {
                qualifier = (XMPNode)it.next();
                if (RDF_ATTR_QUALIFIER.contains(qualifier.getName())) continue;
                this.serializeCanonicalRDFProperty(qualifier, useCanonicalRDF, false, indent + 1);
            }
            if (useCanonicalRDF) {
                this.writeIndent(indent);
                this.write("</rdf:Description>");
                this.writeNewline();
                --indent;
            }
        } else if (!node.getOptions().isCompositeProperty()) {
            if (node.getOptions().isURI()) {
                this.write(" rdf:resource=\"");
                this.appendNodeValue(node.getValue(), true);
                this.write("\"/>");
                this.writeNewline();
                emitEndTag = false;
            } else if (node.getValue() == null || "".equals(node.getValue())) {
                this.write("/>");
                this.writeNewline();
                emitEndTag = false;
            } else {
                this.write(62);
                this.appendNodeValue(node.getValue(), false);
                indentEndTag = false;
            }
        } else if (node.getOptions().isArray()) {
            this.write(62);
            this.writeNewline();
            this.emitRDFArrayTag(node, true, indent + 1);
            if (node.getOptions().isArrayAltText()) {
                XMPNodeUtils.normalizeLangArray(node);
            }
            it = node.iterateChildren();
            while (it.hasNext()) {
                child = (XMPNode)it.next();
                this.serializeCanonicalRDFProperty(child, useCanonicalRDF, false, indent + 2);
            }
            this.emitRDFArrayTag(node, false, indent + 1);
        } else if (!hasRDFResourceQual) {
            if (!node.hasChildren()) {
                if (useCanonicalRDF) {
                    this.write(">");
                    this.writeNewline();
                    this.writeIndent(indent + 1);
                    this.write(RDF_EMPTY_STRUCT);
                } else {
                    this.write(" rdf:parseType=\"Resource\"/>");
                    emitEndTag = false;
                }
                this.writeNewline();
            } else {
                if (useCanonicalRDF) {
                    this.write(">");
                    this.writeNewline();
                    this.writeIndent(++indent);
                    this.write(RDF_STRUCT_START);
                    this.write(">");
                } else {
                    this.write(" rdf:parseType=\"Resource\">");
                }
                this.writeNewline();
                it = node.iterateChildren();
                while (it.hasNext()) {
                    child = (XMPNode)it.next();
                    this.serializeCanonicalRDFProperty(child, useCanonicalRDF, false, indent + 1);
                }
                if (useCanonicalRDF) {
                    this.writeIndent(indent);
                    this.write("</rdf:Description>");
                    this.writeNewline();
                    --indent;
                }
            }
        } else {
            it = node.iterateChildren();
            while (it.hasNext()) {
                child = (XMPNode)it.next();
                if (!this.canBeRDFAttrProp(child)) {
                    throw new XMPException("Can't mix rdf:resource and complex fields", 202);
                }
                this.writeNewline();
                this.writeIndent(indent + 1);
                this.write(32);
                this.write(child.getName());
                this.write("=\"");
                this.appendNodeValue(child.getValue(), true);
                this.write(34);
            }
            this.write("/>");
            this.writeNewline();
            emitEndTag = false;
        }
        if (emitEndTag) {
            if (indentEndTag) {
                this.writeIndent(indent);
            }
            this.write("</");
            this.write(elemName);
            this.write(62);
            this.writeNewline();
        }
    }

    private void emitRDFArrayTag(XMPNode arrayNode, boolean isStartTag, int indent) throws IOException {
        if (isStartTag || arrayNode.hasChildren()) {
            this.writeIndent(indent);
            this.write(isStartTag ? "<rdf:" : "</rdf:");
            if (arrayNode.getOptions().isArrayAlternate()) {
                this.write("Alt");
            } else if (arrayNode.getOptions().isArrayOrdered()) {
                this.write("Seq");
            } else {
                this.write("Bag");
            }
            if (isStartTag && !arrayNode.hasChildren()) {
                this.write("/>");
            } else {
                this.write(">");
            }
            this.writeNewline();
        }
    }

    private void appendNodeValue(String value, boolean forAttribute) throws IOException {
        if (value == null) {
            value = "";
        }
        this.write(Utils.escapeXML(value, forAttribute, true));
    }

    private boolean canBeRDFAttrProp(XMPNode node) {
        return !node.hasQualifier() && !node.getOptions().isURI() && !node.getOptions().isCompositeProperty() && !node.getOptions().containsOneOf(0x40000000) && !"[]".equals(node.getName());
    }

    private void writeIndent(int times) throws IOException {
        for (int i = this.options.getBaseIndent() + times; i > 0; --i) {
            this.writer.write(this.options.getIndent());
        }
    }

    private void write(int c) throws IOException {
        this.writer.write(c);
    }

    private void write(String str) throws IOException {
        this.writer.write(str);
    }

    private void writeChars(int number, char c) throws IOException {
        while (number > 0) {
            this.writer.write(c);
            --number;
        }
    }

    private void writeNewline() throws IOException {
        this.writer.write(this.options.getNewline());
    }
}

