/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.log;

import com.itextpdf.kernel.log.DefaultCounter;
import com.itextpdf.kernel.log.ICounter;
import com.itextpdf.kernel.log.ICounterFactory;
import com.itextpdf.kernel.log.SimpleCounterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CounterManager {
    private static CounterManager instance = new CounterManager();
    private Set<ICounterFactory> factories = new HashSet<ICounterFactory>();

    private CounterManager() {
        this.register(new SimpleCounterFactory(new DefaultCounter()));
    }

    public static CounterManager getInstance() {
        return instance;
    }

    public List<ICounter> getCounters(Class<?> cls) {
        ArrayList<ICounter> result = new ArrayList<ICounter>();
        for (ICounterFactory factory : this.factories) {
            ICounter counter = factory.getCounter(cls);
            if (counter == null) continue;
            result.add(counter);
        }
        return result;
    }

    public void register(ICounterFactory factory) {
        if (factory != null) {
            this.factories.add(factory);
        }
    }

    public boolean unregister(ICounterFactory factory) {
        if (factory != null) {
            return this.factories.remove(factory);
        }
        return false;
    }
}

