/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.navigation;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitDestination;
import com.itextpdf.kernel.pdf.navigation.PdfExplicitRemoteGoToDestination;
import com.itextpdf.kernel.pdf.navigation.PdfNamedDestination;
import com.itextpdf.kernel.pdf.navigation.PdfStringDestination;
import java.util.Map;

public abstract class PdfDestination
extends PdfObjectWrapper<PdfObject> {
    private static final long serialVersionUID = 8102903000978704308L;

    protected PdfDestination(PdfObject pdfObject) {
        super(pdfObject);
    }

    public abstract PdfObject getDestinationPage(Map<String, PdfObject> var1);

    @Deprecated
    public abstract PdfDestination replaceNamedDestination(Map<Object, PdfObject> var1);

    public static PdfDestination makeDestination(PdfObject pdfObject) {
        if (pdfObject.getType() == 10) {
            return new PdfStringDestination((PdfString)pdfObject);
        }
        if (pdfObject.getType() == 6) {
            return new PdfNamedDestination((PdfName)pdfObject);
        }
        if (pdfObject.getType() == 1) {
            PdfArray destArray = (PdfArray)pdfObject;
            if (destArray.size() == 0) {
                throw new IllegalArgumentException();
            }
            PdfObject firstObj = destArray.get(0);
            if (firstObj.isNumber()) {
                return new PdfExplicitRemoteGoToDestination(destArray);
            }
            return new PdfExplicitDestination(destArray);
        }
        throw new UnsupportedOperationException();
    }
}

