/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.properties.XMPProperty;
import java.io.Serializable;

public class PdfAConformanceLevel
implements Serializable {
    public static final PdfAConformanceLevel PDF_A_1A = new PdfAConformanceLevel("1", "A");
    public static final PdfAConformanceLevel PDF_A_1B = new PdfAConformanceLevel("1", "B");
    public static final PdfAConformanceLevel PDF_A_2A = new PdfAConformanceLevel("2", "A");
    public static final PdfAConformanceLevel PDF_A_2B = new PdfAConformanceLevel("2", "B");
    public static final PdfAConformanceLevel PDF_A_2U = new PdfAConformanceLevel("2", "U");
    public static final PdfAConformanceLevel PDF_A_3A = new PdfAConformanceLevel("3", "A");
    public static final PdfAConformanceLevel PDF_A_3B = new PdfAConformanceLevel("3", "B");
    public static final PdfAConformanceLevel PDF_A_3U = new PdfAConformanceLevel("3", "U");
    private static final long serialVersionUID = 1481878095812910587L;
    private String conformance;
    private String part;

    private PdfAConformanceLevel(String part, String conformance) {
        this.conformance = conformance;
        this.part = part;
    }

    public String getConformance() {
        return this.conformance;
    }

    public String getPart() {
        return this.part;
    }

    public static PdfAConformanceLevel getConformanceLevel(String part, String conformance) {
        String lowLetter = conformance.toUpperCase();
        boolean aLevel = lowLetter.equals("A");
        boolean bLevel = lowLetter.equals("B");
        boolean uLevel = lowLetter.equals("U");
        switch (part) {
            case "1": {
                if (aLevel) {
                    return PDF_A_1A;
                }
                if (!bLevel) break;
                return PDF_A_1B;
            }
            case "2": {
                if (aLevel) {
                    return PDF_A_2A;
                }
                if (bLevel) {
                    return PDF_A_2B;
                }
                if (!uLevel) break;
                return PDF_A_2U;
            }
            case "3": {
                if (aLevel) {
                    return PDF_A_3A;
                }
                if (bLevel) {
                    return PDF_A_3B;
                }
                if (!uLevel) break;
                return PDF_A_3U;
            }
        }
        return null;
    }

    public static PdfAConformanceLevel getConformanceLevel(XMPMeta meta) {
        XMPProperty conformanceXmpProperty = null;
        XMPProperty partXmpProperty = null;
        try {
            conformanceXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "conformance");
            partXmpProperty = meta.getProperty("http://www.aiim.org/pdfa/ns/id/", "part");
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
        if (conformanceXmpProperty == null || partXmpProperty == null) {
            return null;
        }
        String conformance = conformanceXmpProperty.getValue();
        String part = partXmpProperty.getValue();
        return PdfAConformanceLevel.getConformanceLevel(part, conformance);
    }
}

