/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfPolyGeomAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -9038993253308315792L;
    public static final PdfName Polygon = PdfName.Polygon;
    public static final PdfName PolyLine = PdfName.PolyLine;

    @Deprecated
    public PdfPolyGeomAnnotation(Rectangle rect, PdfName subtype, float[] vertices) {
        super(rect);
        this.setSubtype(subtype);
        this.setVertices(vertices);
    }

    @Deprecated
    public PdfPolyGeomAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfPolyGeomAnnotation createPolygon(Rectangle rect, float[] vertices) {
        return new PdfPolyGeomAnnotation(rect, Polygon, vertices);
    }

    public static PdfPolyGeomAnnotation createPolyLine(Rectangle rect, float[] vertices) {
        return new PdfPolyGeomAnnotation(rect, PolyLine, vertices);
    }

    @Override
    public PdfName getSubtype() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
    }

    public PdfArray getVertices() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Vertices);
    }

    public PdfPolyGeomAnnotation setVertices(PdfArray vertices) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, vertices);
    }

    public PdfPolyGeomAnnotation setVertices(float[] vertices) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, new PdfArray(vertices));
    }

    public PdfArray getLineEndingStyles() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.LE);
    }

    public PdfPolyGeomAnnotation setLineEndingStyles(PdfArray lineEndingStyles) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.LE, lineEndingStyles);
    }

    public PdfDictionary getMeasure() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Measure);
    }

    public PdfPolyGeomAnnotation setMeasure(PdfDictionary measure) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Measure, measure);
    }

    private void setSubtype(PdfName subtype) {
        this.put(PdfName.Subtype, subtype);
    }

    @Override
    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    @Override
    public PdfPolyGeomAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.BS, borderStyle);
    }

    @Override
    public PdfPolyGeomAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    @Override
    public PdfPolyGeomAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    @Override
    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    @Override
    public PdfPolyGeomAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.BE, borderEffect);
    }

    @Override
    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    @Override
    public PdfPolyGeomAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.IC, interiorColor);
    }

    @Override
    public PdfPolyGeomAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }
}

