/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.layer;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PdfOCProperties
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 1137977454824741350L;
    private List<PdfLayer> layers = new ArrayList<PdfLayer>();

    public PdfOCProperties(PdfDocument document) {
        this(new PdfDictionary().makeIndirect(document));
    }

    public PdfOCProperties(PdfDictionary ocPropertiesDict) {
        super(ocPropertiesDict);
        PdfOCProperties.ensureObjectIsAddedToDocument(ocPropertiesDict);
        this.readLayersFromDictionary();
    }

    public void addOCGRadioGroup(List<PdfLayer> group) {
        PdfArray ar = new PdfArray();
        for (PdfLayer layer : group) {
            if (layer.getTitle() != null) continue;
            ar.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if (ar.size() != 0) {
            PdfArray radioButtonGroups;
            PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
            if (d == null) {
                d = new PdfDictionary();
                ((PdfDictionary)this.getPdfObject()).put(PdfName.D, d);
            }
            if ((radioButtonGroups = d.getAsArray(PdfName.RBGroups)) == null) {
                radioButtonGroups = new PdfArray();
                d.put(PdfName.RBGroups, radioButtonGroups);
                d.setModified();
            } else {
                radioButtonGroups.setModified();
            }
            radioButtonGroups.add(ar);
        }
    }

    public PdfObject fillDictionary() {
        PdfArray gr = new PdfArray();
        for (PdfLayer layer : this.layers) {
            if (layer.getTitle() != null) continue;
            gr.add(layer.getIndirectReference());
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.OCGs, gr);
        PdfArray rbGroups = null;
        PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        if (d != null) {
            rbGroups = d.getAsArray(PdfName.RBGroups);
        }
        d = new PdfDictionary();
        if (rbGroups != null) {
            d.put(PdfName.RBGroups, rbGroups);
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.D, d);
        ArrayList<PdfLayer> docOrder = new ArrayList<PdfLayer>(this.layers);
        Iterator it = docOrder.iterator();
        while (it.hasNext()) {
            PdfLayer layer = (PdfLayer)it.next();
            if (layer.getParent() == null) continue;
            it.remove();
        }
        PdfArray order = new PdfArray();
        for (Object e : docOrder) {
            PdfLayer pdfLayer = (PdfLayer)e;
            PdfOCProperties.getOCGOrder(order, pdfLayer);
        }
        d.put(PdfName.Order, order);
        PdfArray off = new PdfArray();
        for (PdfLayer pdfLayer : this.layers) {
            PdfLayer layer = pdfLayer;
            if (layer.getTitle() != null || layer.isOn()) continue;
            off.add(layer.getIndirectReference());
        }
        if (off.size() > 0) {
            d.put(PdfName.OFF, off);
        } else {
            d.remove(PdfName.OFF);
        }
        PdfArray pdfArray = new PdfArray();
        for (PdfLayer layer : this.layers) {
            if (layer.getTitle() != null || !layer.isLocked()) continue;
            pdfArray.add(layer.getIndirectReference());
        }
        if (pdfArray.size() > 0) {
            d.put(PdfName.Locked, pdfArray);
        } else {
            d.remove(PdfName.Locked);
        }
        d.remove(PdfName.AS);
        this.addASEvent(PdfName.View, PdfName.Zoom);
        this.addASEvent(PdfName.View, PdfName.View);
        this.addASEvent(PdfName.Print, PdfName.Print);
        this.addASEvent(PdfName.Export, PdfName.Export);
        return this.getPdfObject();
    }

    @Override
    public void flush() {
        this.fillDictionary();
        super.flush();
    }

    public List<PdfLayer> getLayers() {
        return new ArrayList<PdfLayer>(this.layers);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected void registerLayer(PdfLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer argument is null");
        }
        this.layers.add(layer);
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    private static void getOCGOrder(PdfArray order, PdfLayer layer) {
        List<PdfLayer> children;
        if (!layer.isOnPanel()) {
            return;
        }
        if (layer.getTitle() == null) {
            order.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if ((children = layer.getChildren()) == null) {
            return;
        }
        PdfArray kids = new PdfArray();
        if (layer.getTitle() != null) {
            kids.add(new PdfString(layer.getTitle(), "UnicodeBig"));
        }
        for (PdfLayer child : children) {
            PdfOCProperties.getOCGOrder(kids, child);
        }
        if (kids.size() > 0) {
            order.add(kids);
        }
    }

    private void addASEvent(PdfName event, PdfName category) {
        PdfArray arr = new PdfArray();
        for (PdfLayer layer : this.layers) {
            PdfDictionary usage;
            if (layer.getTitle() != null || (usage = ((PdfDictionary)layer.getPdfObject()).getAsDictionary(PdfName.Usage)) == null || usage.get(category) == null) continue;
            arr.add(((PdfDictionary)layer.getPdfObject()).getIndirectReference());
        }
        if (arr.size() == 0) {
            return;
        }
        PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        PdfArray arras = d.getAsArray(PdfName.AS);
        if (arras == null) {
            arras = new PdfArray();
            d.put(PdfName.AS, arras);
        }
        PdfDictionary as = new PdfDictionary();
        as.put(PdfName.Event, event);
        PdfArray categoryArray = new PdfArray();
        categoryArray.add(category);
        as.put(PdfName.Category, categoryArray);
        as.put(PdfName.OCGs, arr);
        arras.add(as);
    }

    private void readLayersFromDictionary() {
        PdfArray ocgs = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OCGs);
        if (ocgs == null || ocgs.isEmpty()) {
            return;
        }
        TreeMap<PdfIndirectReference, PdfLayer> layerMap = new TreeMap<PdfIndirectReference, PdfLayer>();
        for (int ind = 0; ind < ocgs.size(); ++ind) {
            PdfLayer currentLayer = new PdfLayer(ocgs.getAsDictionary(ind).makeIndirect(this.getDocument()));
            currentLayer.onPanel = false;
            layerMap.put(currentLayer.getIndirectReference(), currentLayer);
        }
        PdfDictionary d = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.D);
        if (d != null && !d.isEmpty()) {
            PdfArray orderArray;
            PdfArray locked;
            PdfArray off = d.getAsArray(PdfName.OFF);
            if (off != null) {
                for (Object offLayer : off) {
                    ((PdfLayer)layerMap.get((Object)offLayer)).on = false;
                }
            }
            if ((locked = d.getAsArray(PdfName.Locked)) != null) {
                for (PdfObject lockedLayer : locked) {
                    ((PdfLayer)layerMap.get((Object)lockedLayer)).locked = true;
                }
            }
            if ((orderArray = d.getAsArray(PdfName.Order)) != null && !orderArray.isEmpty()) {
                this.readOrderFromDictionary(null, orderArray, layerMap);
            }
        }
        for (PdfLayer layer : layerMap.values()) {
            if (layer.isOnPanel()) continue;
            this.layers.add(layer);
        }
    }

    private void readOrderFromDictionary(PdfLayer parent, PdfArray orderArray, Map<PdfIndirectReference, PdfLayer> layerMap) {
        for (int i = 0; i < orderArray.size(); ++i) {
            PdfArray subArray;
            PdfObject item = orderArray.get(i);
            if (item.getType() == 3) {
                PdfLayer layer = layerMap.get(item.getIndirectReference());
                if (layer == null) continue;
                this.layers.add(layer);
                layer.onPanel = true;
                if (parent != null) {
                    parent.addChild(layer);
                }
                if (i + 1 >= orderArray.size() || orderArray.get(i + 1).getType() != 1) continue;
                this.readOrderFromDictionary(layer, orderArray.getAsArray(i + 1), layerMap);
                ++i;
                continue;
            }
            if (item.getType() != 1 || (subArray = (PdfArray)item).isEmpty()) continue;
            PdfObject firstObj = subArray.get(0);
            if (firstObj.getType() == 10) {
                PdfLayer titleLayer = PdfLayer.createTitleSilent(((PdfString)firstObj).toUnicodeString(), this.getDocument());
                titleLayer.onPanel = true;
                this.layers.add(titleLayer);
                if (parent != null) {
                    parent.addChild(titleLayer);
                }
                this.readOrderFromDictionary(titleLayer, new PdfArray(subArray.subList(1, subArray.size())), layerMap);
                continue;
            }
            this.readOrderFromDictionary(parent, subArray, layerMap);
        }
    }
}

