/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.color;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;

public class DeviceCmyk
extends Color {
    public static final DeviceCmyk CYAN = new DeviceCmyk(100, 0, 0, 0);
    public static final DeviceCmyk MAGENTA = new DeviceCmyk(0, 100, 0, 0);
    public static final DeviceCmyk YELLOW = new DeviceCmyk(0, 0, 100, 0);
    public static final DeviceCmyk BLACK = new DeviceCmyk(0, 0, 0, 100);

    public DeviceCmyk() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public DeviceCmyk(int c, int m, int y, int k) {
        this((float)c / 100.0f, (float)m / 100.0f, (float)y / 100.0f, (float)k / 100.0f);
    }

    public DeviceCmyk(float c, float m, float y, float k) {
        super(new PdfDeviceCs.Cmyk(), new float[]{c, m, y, k});
    }

    public static DeviceCmyk makeLighter(DeviceCmyk cmykColor) {
        DeviceRgb rgbEquivalent = DeviceCmyk.convertCmykToRgb(cmykColor);
        DeviceRgb lighterRgb = DeviceRgb.makeLighter(rgbEquivalent);
        return DeviceCmyk.convertRgbToCmyk(lighterRgb);
    }

    public static DeviceCmyk makeDarker(DeviceCmyk cmykColor) {
        DeviceRgb rgbEquivalent = DeviceCmyk.convertCmykToRgb(cmykColor);
        DeviceRgb darkerRgb = DeviceRgb.makeDarker(rgbEquivalent);
        return DeviceCmyk.convertRgbToCmyk(darkerRgb);
    }
}

