/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.AbstractTrueTypeFontModifier;
import com.itextpdf.io.font.OpenTypeParser;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TrueTypeFontMerger
extends AbstractTrueTypeFontModifier {
    private OpenTypeParser cmapSourceParser = null;

    TrueTypeFontMerger(String fontName, Map<OpenTypeParser, Set<Integer>> fontsToMerge, boolean isCmapCheckRequired) throws IOException {
        super(fontName, true);
        List usedFlatGlyphs;
        OpenTypeParser parser;
        this.horizontalMetricMap = new HashMap();
        this.glyphDataMap = new HashMap();
        OpenTypeParser parserExample = null;
        HashSet<Integer> allGids = new HashSet<Integer>();
        LinkedHashMap<OpenTypeParser, List> fontsToMergeWithFlatGlyphs = new LinkedHashMap<OpenTypeParser, List>();
        for (Map.Entry<OpenTypeParser, Set<Integer>> entry : fontsToMerge.entrySet()) {
            parser = entry.getKey();
            usedFlatGlyphs = parser.getFlatGlyphs(entry.getValue());
            fontsToMergeWithFlatGlyphs.put(parser, usedFlatGlyphs);
            allGids.addAll(usedFlatGlyphs);
        }
        allGids.remove(0);
        for (Map.Entry<OpenTypeParser, Set<Integer>> entry : fontsToMergeWithFlatGlyphs.entrySet()) {
            parser = entry.getKey();
            usedFlatGlyphs = (List)((Object)entry.getValue());
            for (Integer glyphObj : usedFlatGlyphs) {
                int glyph = glyphObj;
                byte[] glyphData = parser.getGlyphDataForGid(glyph);
                if (this.glyphDataMap.containsKey(glyph) && !Arrays.equals((byte[])this.glyphDataMap.get(glyph), glyphData)) {
                    throw new com.itextpdf.io.exceptions.IOException("Incompatibility of glyph data/metrics between merged fonts");
                }
                this.glyphDataMap.put(glyph, glyphData);
                byte[] glyphMetric = parser.getHorizontalMetricForGid(glyph);
                if (this.horizontalMetricMap.containsKey(glyph) && !Arrays.equals((byte[])this.horizontalMetricMap.get(glyph), glyphMetric)) {
                    throw new com.itextpdf.io.exceptions.IOException("Incompatibility of glyph data/metrics between merged fonts");
                }
                this.horizontalMetricMap.put(glyph, glyphMetric);
            }
            if (parserExample == null || parser.hhea.numberOfHMetrics > parserExample.hhea.numberOfHMetrics) {
                parserExample = parser;
            }
            if (!isCmapCheckRequired || this.cmapSourceParser != null || !TrueTypeFontMerger.isCmapContainsGids(parser, allGids)) continue;
            this.cmapSourceParser = parser;
        }
        if (isCmapCheckRequired && this.cmapSourceParser == null) {
            throw new com.itextpdf.io.exceptions.IOException("cmap table merging isn't supported.");
        }
        this.raf = parserExample.raf.createView();
        this.directoryOffset = parserExample.directoryOffset;
        this.numberOfHMetrics = parserExample.hhea.numberOfHMetrics;
    }

    @Override
    protected int mergeTables() throws IOException {
        int numOfGlyphs = super.createModifiedTables();
        if (this.cmapSourceParser != null) {
            RandomAccessFileOrArray cmapSourceRaf = this.cmapSourceParser.raf.createView();
            int[] tableLocation = this.cmapSourceParser.tables.get("cmap");
            byte[] cmap = new byte[tableLocation[1]];
            cmapSourceRaf.seek(tableLocation[0]);
            cmapSourceRaf.read(cmap);
            this.modifiedTables.put("cmap", cmap);
        }
        return numOfGlyphs;
    }

    private static boolean isCmapContainsGids(OpenTypeParser parser, Set<Integer> gids) {
        OpenTypeParser.CmapTable cmapTable = parser.getCmapTable();
        return TrueTypeFontMerger.isEncodingContainsGids(cmapTable.cmap03, gids) && TrueTypeFontMerger.isEncodingContainsGids(cmapTable.cmap10, gids) && TrueTypeFontMerger.isEncodingContainsGids(cmapTable.cmap30, gids) && TrueTypeFontMerger.isEncodingContainsGids(cmapTable.cmap31, gids) && TrueTypeFontMerger.isEncodingContainsGids(cmapTable.cmap310, gids);
    }

    private static boolean isEncodingContainsGids(Map<Integer, int[]> encoding, Set<Integer> gids) {
        if (encoding == null) {
            return true;
        }
        HashSet<Integer> encodingGids = new HashSet<Integer>();
        for (int[] mapping : encoding.values()) {
            encodingGids.add(mapping[0]);
        }
        return encodingGids.containsAll(gids);
    }
}

