/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    private static final int TRANSFER_SIZE = 65536;
    private static final byte[] escR = ByteUtils.getIsoBytes("\\r");
    private static final byte[] escN = ByteUtils.getIsoBytes("\\n");
    private static final byte[] escT = ByteUtils.getIsoBytes("\\t");
    private static final byte[] escB = ByteUtils.getIsoBytes("\\b");
    private static final byte[] escF = ByteUtils.getIsoBytes("\\f");

    private StreamUtil() {
    }

    public static void skip(InputStream stream, long size) throws IOException {
        long n;
        while (size > 0L && (n = stream.skip(size)) > 0L) {
            size -= n;
        }
    }

    public static byte[] createEscapedString(byte[] bytes) {
        return StreamUtil.createBufferedEscapedString(bytes).toByteArray();
    }

    public static void writeEscapedString(OutputStream outputStream, byte[] bytes) {
        ByteBuffer buf = StreamUtil.createBufferedEscapedString(bytes);
        try {
            outputStream.write(buf.getInternalBuffer(), 0, buf.size());
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException("Cannot write bytes.", e);
        }
    }

    public static void writeHexedString(OutputStream outputStream, byte[] bytes) {
        ByteBuffer buf = StreamUtil.createBufferedHexedString(bytes);
        try {
            outputStream.write(buf.getInternalBuffer(), 0, buf.size());
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException("Cannot write bytes.", e);
        }
    }

    public static ByteBuffer createBufferedEscapedString(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer(bytes.length * 2 + 2);
        buf.append(40);
        block8: for (byte b : bytes) {
            switch (b) {
                case 13: {
                    buf.append(escR);
                    continue block8;
                }
                case 10: {
                    buf.append(escN);
                    continue block8;
                }
                case 9: {
                    buf.append(escT);
                    continue block8;
                }
                case 8: {
                    buf.append(escB);
                    continue block8;
                }
                case 12: {
                    buf.append(escF);
                    continue block8;
                }
                case 40: 
                case 41: 
                case 92: {
                    buf.append(92).append(b);
                    continue block8;
                }
                default: {
                    if (b < 8 && b >= 0) {
                        buf.append("\\00").append(Integer.toOctalString(b));
                        continue block8;
                    }
                    if (b >= 8 && b < 32) {
                        buf.append("\\0").append(Integer.toOctalString(b));
                        continue block8;
                    }
                    buf.append(b);
                }
            }
        }
        buf.append(41);
        return buf;
    }

    public static ByteBuffer createBufferedHexedString(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer(bytes.length * 2 + 2);
        buf.append(60);
        for (byte b : bytes) {
            buf.appendHex(b);
        }
        buf.append(62);
        return buf;
    }

    public static void transferBytes(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        while ((len = input.read(buffer, 0, 65536)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    public static void transferBytes(RandomAccessFileOrArray input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[65536];
        while ((len = input.read(buffer, 0, 65536)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    public static byte[] inputStreamToArray(InputStream stream) throws IOException {
        int read;
        byte[] b = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((read = stream.read(b)) >= 1) {
            output.write(b, 0, read);
        }
        output.close();
        return output.toByteArray();
    }

    public static void copyBytes(IRandomAccessSource source, long start, long length, OutputStream output) throws IOException {
        if (length <= 0L) {
            return;
        }
        long idx = start;
        byte[] buf = new byte[8192];
        while (length > 0L) {
            long n = source.get(idx, buf, 0, (int)Math.min((long)buf.length, length));
            if (n <= 0L) {
                throw new EOFException();
            }
            output.write(buf, 0, (int)n);
            idx += n;
            length -= n;
        }
    }

    public static void readFully(InputStream input, byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = input.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

