/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GposAnchor;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfMarkRecord;
import com.itextpdf.io.font.otf.OtfReadCommon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GposLookupType5
extends OpenTableLookup {
    private final List<MarkToLigature> marksligatures = new ArrayList<MarkToLigature>();

    public GposLookupType5(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.getIdx() >= line.getEnd()) {
            return false;
        }
        if (this.openReader.isSkip(line.get(line.getIdx()).getCode(), this.lookupFlag)) {
            line.setIdx(line.getIdx() + 1);
            return false;
        }
        boolean changed = false;
        OpenTableLookup.GlyphIndexer ligatureGlyphIndexer = null;
        block0: for (MarkToLigature mb : this.marksligatures) {
            List<GposAnchor[]> componentAnchors;
            OtfMarkRecord omr = mb.marks.get(line.get(line.getIdx()).getCode());
            if (omr == null) continue;
            if (ligatureGlyphIndexer == null) {
                ligatureGlyphIndexer = new OpenTableLookup.GlyphIndexer();
                ligatureGlyphIndexer.setIdx(line.getIdx());
                ligatureGlyphIndexer.setLine(line);
                do {
                    ligatureGlyphIndexer.previousGlyph(this.openReader, this.lookupFlag);
                } while (ligatureGlyphIndexer.getGlyph() != null && mb.marks.containsKey(ligatureGlyphIndexer.getGlyph().getCode()));
                if (ligatureGlyphIndexer.getGlyph() == null) break;
            }
            if ((componentAnchors = mb.ligatures.get(ligatureGlyphIndexer.getGlyph().getCode())) == null) continue;
            int markClass = omr.getMarkClass();
            for (int component = componentAnchors.size() - 1; component >= 0; --component) {
                if (componentAnchors.get(component)[markClass] == null) continue;
                GposAnchor baseAnchor = componentAnchors.get(component)[markClass];
                GposAnchor markAnchor = omr.getAnchor();
                line.set(line.getIdx(), new Glyph(line.get(line.getIdx()), baseAnchor.getXCoordinate() - markAnchor.getXCoordinate(), baseAnchor.getYCoordinate() - markAnchor.getYCoordinate(), 0, 0, ligatureGlyphIndexer.getIdx() - line.getIdx()));
                changed = true;
                break block0;
            }
        }
        line.setIdx(line.getIdx() + 1);
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        this.openReader.rf.readUnsignedShort();
        int markCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int ligatureCoverageLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int classCount = this.openReader.rf.readUnsignedShort();
        int markArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        int ligatureArrayLocation = this.openReader.rf.readUnsignedShort() + subTableLocation;
        List<Integer> markCoverage = this.openReader.readCoverageFormat(markCoverageLocation);
        List<Integer> ligatureCoverage = this.openReader.readCoverageFormat(ligatureCoverageLocation);
        List<OtfMarkRecord> markRecords = OtfReadCommon.readMarkArray(this.openReader, markArrayLocation);
        MarkToLigature markToLigature = new MarkToLigature();
        for (int k = 0; k < markCoverage.size(); ++k) {
            markToLigature.marks.put(markCoverage.get(k), markRecords.get(k));
        }
        List<List<GposAnchor[]>> ligatureArray = OtfReadCommon.readLigatureArray(this.openReader, classCount, ligatureArrayLocation);
        for (int k = 0; k < ligatureCoverage.size(); ++k) {
            markToLigature.ligatures.put(ligatureCoverage.get(k), ligatureArray.get(k));
        }
        this.marksligatures.add(markToLigature);
    }

    public static class MarkToLigature {
        public final Map<Integer, OtfMarkRecord> marks = new HashMap<Integer, OtfMarkRecord>();
        public final Map<Integer, List<GposAnchor[]>> ligatures = new HashMap<Integer, List<GposAnchor[]>>();
    }
}

