/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.IRandomAccessSource;
import java.io.IOException;

public class GetBufferedRandomAccessSource
implements IRandomAccessSource {
    private final IRandomAccessSource source;
    private final byte[] getBuffer;
    private long getBufferStart = -1L;
    private long getBufferEnd = -1L;

    public GetBufferedRandomAccessSource(IRandomAccessSource source) {
        this.source = source;
        this.getBuffer = new byte[(int)Math.min(Math.max(source.length() / 4L, 1L), 4096L)];
        this.getBufferStart = -1L;
        this.getBufferEnd = -1L;
    }

    @Override
    public int get(long position) throws IOException {
        if (position < this.getBufferStart || position > this.getBufferEnd) {
            int count = this.source.get(position, this.getBuffer, 0, this.getBuffer.length);
            if (count == -1) {
                return -1;
            }
            this.getBufferStart = position;
            this.getBufferEnd = position + (long)count - 1L;
        }
        int bufPos = (int)(position - this.getBufferStart);
        return 0xFF & this.getBuffer[bufPos];
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        return this.source.get(position, bytes, off, len);
    }

    @Override
    public long length() {
        return this.source.length();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.getBufferStart = -1L;
        this.getBufferEnd = -1L;
    }
}

