/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.util.MessageFormatUtil;
import java.io.Serializable;

public class ByteBuffer
implements Serializable {
    private static final byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final long serialVersionUID = -4380712536267312975L;
    protected int count;
    private byte[] buffer;

    public ByteBuffer() {
        this(128);
    }

    public ByteBuffer(int size) {
        if (size < 1) {
            size = 128;
        }
        this.buffer = new byte[size];
    }

    public static int getHex(int v) {
        if (v >= 48 && v <= 57) {
            return v - 48;
        }
        if (v >= 65 && v <= 70) {
            return v - 65 + 10;
        }
        if (v >= 97 && v <= 102) {
            return v - 97 + 10;
        }
        return -1;
    }

    public ByteBuffer append(byte b) {
        int newCount = this.count + 1;
        if (newCount > this.buffer.length) {
            byte[] newBuffer = new byte[Math.max(this.buffer.length << 1, newCount)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.count);
            this.buffer = newBuffer;
        }
        this.buffer[this.count] = b;
        this.count = newCount;
        return this;
    }

    public ByteBuffer append(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0 || len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.buffer.length) {
            byte[] newBuffer = new byte[Math.max(this.buffer.length << 1, newCount)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.count);
            this.buffer = newBuffer;
        }
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count = newCount;
        return this;
    }

    public ByteBuffer append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public ByteBuffer append(int b) {
        return this.append((byte)b);
    }

    public ByteBuffer append(String str) {
        return this.append(ByteUtils.getIsoBytes(str));
    }

    public ByteBuffer appendHex(byte b) {
        this.append(bytes[b >> 4 & 0xF]);
        return this.append(bytes[b & 0xF]);
    }

    public byte get(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException(MessageFormatUtil.format("Index: {0}, Size: {1}", index, this.count));
        }
        return this.buffer[index];
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public ByteBuffer reset() {
        this.count = 0;
        return this;
    }

    public byte[] toByteArray(int off, int len) {
        byte[] newBuf = new byte[len];
        System.arraycopy(this.buffer, off, newBuf, 0, len);
        return newBuf;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.count);
    }

    public boolean startsWith(byte[] b) {
        if (this.size() < b.length) {
            return false;
        }
        for (int k = 0; k < b.length; ++k) {
            if (this.buffer[k] == b[k]) continue;
            return false;
        }
        return true;
    }

    ByteBuffer prepend(byte b) {
        this.buffer[this.buffer.length - this.count - 1] = b;
        ++this.count;
        return this;
    }

    ByteBuffer prepend(byte[] b) {
        System.arraycopy(b, 0, this.buffer, this.buffer.length - this.count - b.length, b.length);
        this.count += b.length;
        return this;
    }
}

