/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import java.util.Iterator;

public class ActualTextIterator
implements Iterator<GlyphLine.GlyphLinePart> {
    private GlyphLine glyphLine;
    private int pos;

    public ActualTextIterator(GlyphLine glyphLine) {
        this.glyphLine = glyphLine;
        this.pos = glyphLine.start;
    }

    public ActualTextIterator(GlyphLine glyphLine, int start, int end) {
        this(new GlyphLine(glyphLine.glyphs, glyphLine.actualText, start, end));
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.glyphLine.end;
    }

    @Override
    public GlyphLine.GlyphLinePart next() {
        if (this.glyphLine.actualText == null) {
            GlyphLine.GlyphLinePart result = new GlyphLine.GlyphLinePart(this.pos, this.glyphLine.end, null);
            this.pos = this.glyphLine.end;
            return result;
        }
        GlyphLine.GlyphLinePart currentResult = this.nextGlyphLinePart(this.pos);
        if (currentResult == null) {
            return null;
        }
        this.pos = currentResult.end;
        while (this.pos < this.glyphLine.end && !this.glyphLinePartNeedsActualText(currentResult)) {
            currentResult.actualText = null;
            GlyphLine.GlyphLinePart nextResult = this.nextGlyphLinePart(this.pos);
            if (nextResult == null || this.glyphLinePartNeedsActualText(nextResult)) break;
            currentResult.end = nextResult.end;
            this.pos = nextResult.end;
        }
        return currentResult;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }

    private GlyphLine.GlyphLinePart nextGlyphLinePart(int pos) {
        if (pos >= this.glyphLine.end) {
            return null;
        }
        int startPos = pos;
        GlyphLine.ActualText startActualText = this.glyphLine.actualText.get(pos);
        while (pos < this.glyphLine.end && this.glyphLine.actualText.get(pos) == startActualText) {
            ++pos;
        }
        return new GlyphLine.GlyphLinePart(startPos, pos, startActualText != null ? startActualText.value : null);
    }

    private boolean glyphLinePartNeedsActualText(GlyphLine.GlyphLinePart glyphLinePart) {
        if (glyphLinePart.actualText == null) {
            return false;
        }
        boolean needsActualText = false;
        StringBuilder toUnicodeMapResult = new StringBuilder();
        for (int i = glyphLinePart.start; i < glyphLinePart.end; ++i) {
            Glyph currentGlyph = this.glyphLine.glyphs.get(i);
            if (!currentGlyph.hasValidUnicode()) {
                needsActualText = true;
                break;
            }
            toUnicodeMapResult.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
        }
        return needsActualText || !toUnicodeMapResult.toString().equals(glyphLinePart.actualText);
    }
}

