/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.FormsMetaInfoStaticContainer;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.Button;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.MetaInfoContainer;
import java.util.List;

public class ButtonRenderer
extends BlockRenderer {
    private static final float DEFAULT_FONT_SIZE = 12.0f;

    public ButtonRenderer(Button modelElement) {
        super((IElement)modelElement);
    }

    public void draw(DrawContext drawContext) {
        super.draw(drawContext);
        if (!this.isFlatten()) {
            String value = this.getDefaultValue();
            String name = this.getModelId();
            UnitValue fontSize = this.getPropertyAsUnitValue(24);
            if (!fontSize.isPointValue()) {
                fontSize = UnitValue.createPointValue((float)12.0f);
            }
            PdfDocument doc = drawContext.getDocument();
            Rectangle area = this.getOccupiedArea().getBBox().clone();
            this.applyMargins(area, false);
            PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
            TransparentColor transparentColor = this.getPropertyAsTransparentColor(21);
            Color color = transparentColor == null ? null : transparentColor.getColor();
            float fontSizeValue = fontSize.getValue();
            PdfFont font = doc.getDefaultFont();
            FormsMetaInfoStaticContainer.useMetaInfoDuringTheAction((MetaInfoContainer)((MetaInfoContainer)this.getProperty(135)), () -> {
                PdfAcroForm forms;
                PdfButtonFormField button = PdfFormField.createPushButton((PdfDocument)doc, (Rectangle)area, (String)name, (String)value, (PdfFont)font, (float)fontSizeValue);
                ((PdfWidgetAnnotation)button.getWidgets().get(0)).setHighlightMode(PdfAnnotation.HIGHLIGHT_NONE);
                button.setBorderWidth(0.0f);
                button.setBackgroundColor(null);
                if (color != null) {
                    button.setColor(color);
                }
                if ((forms = PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true)).getField(name) == null) {
                    forms.addField((PdfFormField)button, page);
                }
            });
            if (doc.isTagged()) {
                TagTreePointer formParentPointer = doc.getTagStructureContext().getAutoTaggingPointer();
                List kidsRoles = formParentPointer.getKidsRoles();
                int lastFormIndex = kidsRoles.lastIndexOf("Form");
                TagTreePointer formPointer = formParentPointer.moveToKid(lastFormIndex);
                String lang = (String)this.getProperty(0x10000F);
                if (lang != null) {
                    formPointer.getProperties().setLanguage(lang);
                }
                formParentPointer.moveToParent();
            }
        }
    }

    protected Float getLastYLineRecursively() {
        return super.getFirstYLineRecursively();
    }

    public IRenderer getNextRenderer() {
        return new ButtonRenderer((Button)this.modelElement);
    }

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    public boolean isFlatten() {
        Boolean flatten = this.getPropertyAsBoolean(0x100003);
        return flatten != null ? flatten.booleanValue() : ((Boolean)this.modelElement.getDefaultProperty(0x100003)).booleanValue();
    }

    public String getDefaultValue() {
        String defaultValue = (String)this.getProperty(0x100005);
        return defaultValue != null ? defaultValue : (String)this.modelElement.getDefaultProperty(0x100005);
    }
}

