/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.util.DrawingUtil;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.CheckBox;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;

public class CheckBoxRenderer
extends AbstractFormFieldRenderer {
    private static final Color DEFAULT_BORDER_COLOR = ColorConstants.DARK_GRAY;
    private static final Color DEFAULT_BACKGROUND_COLOR = ColorConstants.WHITE;
    private static final float DEFAULT_BORDER_WIDTH = 0.75f;
    private static final float DEFAULT_SIZE = 8.25f;

    public CheckBoxRenderer(CheckBox modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new CheckBoxRenderer((CheckBox)this.modelElement);
    }

    @Override
    protected IRenderer createFlatRenderer() {
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph().setWidth(8.25f)).setHeight(8.25f)).setBorder((Border)new SolidBorder(DEFAULT_BORDER_COLOR, 0.75f))).setBackgroundColor(DEFAULT_BACKGROUND_COLOR);
        return new FlatParagraphRenderer(paragraph);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        this.setProperty(6, null);
    }

    public boolean isBoxChecked() {
        return null != this.getProperty(0x100009);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        String name = this.getModelId();
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        PdfButtonFormField checkBox = PdfFormField.createCheckBox((PdfDocument)doc, (Rectangle)area, (String)name, (String)(this.isBoxChecked() ? "Yes" : "Off"));
        PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true).addField((PdfFormField)checkBox, page);
        this.writeAcroFormFieldLangAttribute(doc);
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    private class FlatParagraphRenderer
    extends ParagraphRenderer {
        public FlatParagraphRenderer(Paragraph modelElement) {
            super(modelElement);
        }

        public void drawChildren(DrawContext drawContext) {
            if (CheckBoxRenderer.this.isBoxChecked()) {
                PdfCanvas canvas = drawContext.getCanvas();
                Rectangle rectangle = this.getInnerAreaBBox();
                canvas.saveState();
                canvas.setFillColor(ColorConstants.BLACK);
                DrawingUtil.drawPdfACheck((PdfCanvas)canvas, (float)rectangle.getWidth(), (float)rectangle.getHeight(), (float)rectangle.getLeft(), (float)rectangle.getBottom());
                canvas.restoreState();
            }
        }
    }
}

