/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.apply.util.CounterProcessorUtil;
import com.itextpdf.html2pdf.css.resolve.CssContentPropertyResolver;
import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.css.resolve.HtmlStylesToCssConverter;
import com.itextpdf.html2pdf.css.resolve.UserAgentCss;
import com.itextpdf.html2pdf.css.util.CssStyleSheetAnalyzer;
import com.itextpdf.html2pdf.exception.Html2PdfException;
import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementNode;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.CssInheritance;
import com.itextpdf.styledxmlparser.css.resolve.IStyleInheritance;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IDataNode;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.styledxmlparser.util.StyleUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCssResolver
implements ICssResolver {
    private CssStyleSheet cssStyleSheet;
    private MediaDeviceDescription deviceDescription;
    private IStyleInheritance cssInheritance = new CssInheritance();
    private List<CssFontFaceRule> fonts = new ArrayList<CssFontFaceRule>();

    public DefaultCssResolver(INode treeRoot, MediaDeviceDescription mediaDeviceDescription, ResourceResolver resourceResolver) {
        this.deviceDescription = mediaDeviceDescription;
        this.collectCssDeclarations(treeRoot, resourceResolver, null);
        this.collectFonts();
    }

    public DefaultCssResolver(INode treeRoot, ProcessorContext context) {
        this.deviceDescription = context.getDeviceDescription();
        this.collectCssDeclarations(treeRoot, context.getResourceResolver(), context.getCssContext());
        this.collectFonts();
    }

    public List<CssFontFaceRule> getFonts() {
        return this.fonts;
    }

    public void resolveContentAndCountersStyles(INode node, CssContext context) {
        Map<String, String> elementStyles = this.resolveElementsStyles(node);
        CounterProcessorUtil.processCounters(elementStyles, context);
        this.resolveContentProperty(elementStyles, node, context);
    }

    public Map<String, String> resolveStyles(INode element, AbstractCssContext context) {
        if (context instanceof CssContext) {
            return this.resolveStyles(element, (CssContext)context);
        }
        throw new Html2PdfException("custom AbstractCssContext implementations are not supported yet");
    }

    private Map<String, String> resolveStyles(INode element, CssContext context) {
        String elementFontSize;
        Map elementStyles = this.resolveElementsStyles(element);
        if ("currentcolor".equals(elementStyles.get("color"))) {
            elementStyles.put((String)"color", (String)"inherit");
        }
        String parentFontSizeStr = null;
        if (element.parentNode() instanceof IStylesContainer) {
            IStylesContainer parentNode = (IStylesContainer)element.parentNode();
            Map parentStyles = parentNode.getStyles();
            if (parentStyles == null && !(element.parentNode() instanceof IDocumentNode)) {
                Logger logger = LoggerFactory.getLogger(DefaultCssResolver.class);
                logger.error("Element parent styles are not resolved. Styles for current element might be incorrect.");
            }
            if (parentStyles != null) {
                HashSet<IStyleInheritance> inheritanceRules = new HashSet<IStyleInheritance>();
                inheritanceRules.add(this.cssInheritance);
                for (Map.Entry entry : parentStyles.entrySet()) {
                    elementStyles = StyleUtil.mergeParentStyleDeclaration(elementStyles, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)((String)parentStyles.get("font-size")), inheritanceRules);
                }
                parentFontSizeStr = (String)parentStyles.get("font-size");
            }
        }
        if (CssTypesValidationUtils.isRelativeValue((String)(elementFontSize = elementStyles.get("font-size"))) || "larger".equals(elementFontSize) || "smaller".equals(elementFontSize)) {
            float baseFontSize = CssTypesValidationUtils.isRemValue((String)elementFontSize) ? context.getRootFontSize() : (parentFontSizeStr == null ? CssDimensionParsingUtils.parseAbsoluteFontSize((String)CssDefaults.getDefaultValue((String)"font-size")) : CssDimensionParsingUtils.parseAbsoluteLength(parentFontSizeStr));
            float absoluteFontSize = CssDimensionParsingUtils.parseRelativeFontSize((String)elementFontSize, (float)baseFontSize);
            elementStyles.put((String)"font-size", (String)(DecimalFormatUtil.formatNumber((double)absoluteFontSize, (String)"0.####") + "pt"));
        } else {
            elementStyles.put((String)"font-size", (String)(Float.toString(CssDimensionParsingUtils.parseAbsoluteFontSize((String)elementFontSize)) + "pt"));
        }
        if (element instanceof IElementNode && "html".equals(((IElementNode)element).name())) {
            context.setRootFontSize(elementStyles.get("font-size"));
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, String> entry : elementStyles.entrySet()) {
            if (!"initial".equals(entry.getValue()) && !"inherit".equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            elementStyles.put(key, CssDefaults.getDefaultValue((String)key));
        }
        CounterProcessorUtil.processCounters(elementStyles, context);
        this.resolveContentProperty(elementStyles, element, context);
        return elementStyles;
    }

    private Map<String, String> resolveElementsStyles(INode element) {
        String styleAttribute;
        ArrayList<CssRuleSet> ruleSets = new ArrayList<CssRuleSet>();
        ruleSets.add(new CssRuleSet(null, UserAgentCss.getStyles(element)));
        if (element instanceof IElementNode) {
            ruleSets.add(new CssRuleSet(null, HtmlStylesToCssConverter.convert((IElementNode)element)));
        }
        ruleSets.addAll(this.cssStyleSheet.getCssRuleSets(element, this.deviceDescription));
        if (element instanceof IElementNode && (styleAttribute = ((IElementNode)element).getAttribute("style")) != null) {
            ruleSets.add(new CssRuleSet(null, CssRuleSetParser.parsePropertyDeclarations((String)styleAttribute)));
        }
        return CssStyleSheet.extractStylesFromRuleSets(ruleSets);
    }

    private void resolveContentProperty(Map<String, String> styles, INode contentContainer, CssContext context) {
        List<INode> resolvedContent;
        if ((contentContainer instanceof CssPseudoElementNode || contentContainer instanceof PageMarginBoxContextNode) && (resolvedContent = CssContentPropertyResolver.resolveContent(styles, contentContainer, context)) != null) {
            for (INode child : resolvedContent) {
                contentContainer.addChild(child);
            }
        }
        if (contentContainer instanceof IElementNode) {
            context.getCounterManager().addTargetCounterIfRequired((IElementNode)contentContainer);
            context.getCounterManager().addTargetCountersIfRequired((IElementNode)contentContainer);
        }
    }

    private void collectCssDeclarations(INode rootNode, ResourceResolver resourceResolver, CssContext cssContext) {
        this.cssStyleSheet = new CssStyleSheet();
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(rootNode);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode) {
                IElementNode headChildElement = (IElementNode)currentNode;
                if ("style".equals(headChildElement.name())) {
                    if (currentNode.childNodes().size() > 0 && currentNode.childNodes().get(0) instanceof IDataNode) {
                        String styleData = ((IDataNode)currentNode.childNodes().get(0)).getWholeData();
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse((String)styleData);
                        styleSheet = this.wrapStyleSheetInMediaQueryIfNecessary(headChildElement, styleSheet);
                        this.cssStyleSheet.appendCssStyleSheet(styleSheet);
                    }
                } else if (CssUtils.isStyleSheetLink((IElementNode)headChildElement)) {
                    String styleSheetUri = headChildElement.getAttribute("href");
                    try (InputStream stream = resourceResolver.retrieveResourceAsInputStream(styleSheetUri);){
                        if (stream != null) {
                            CssStyleSheet styleSheet = CssStyleSheetParser.parse((InputStream)stream, (String)resourceResolver.resolveAgainstBaseUri(styleSheetUri).toExternalForm());
                            styleSheet = this.wrapStyleSheetInMediaQueryIfNecessary(headChildElement, styleSheet);
                            this.cssStyleSheet.appendCssStyleSheet(styleSheet);
                        }
                    }
                    catch (Exception exc) {
                        Logger logger = LoggerFactory.getLogger(DefaultCssResolver.class);
                        logger.error("Unable to process external css file", (Throwable)exc);
                    }
                }
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        DefaultCssResolver.enablePagesCounterIfMentioned(this.cssStyleSheet, cssContext);
        DefaultCssResolver.enableNonPageTargetCounterIfMentioned(this.cssStyleSheet, cssContext);
    }

    private static void enableNonPageTargetCounterIfMentioned(CssStyleSheet styleSheet, CssContext cssContext) {
        if (CssStyleSheetAnalyzer.checkNonPagesTargetCounterPresence(styleSheet)) {
            cssContext.setNonPagesTargetCounterPresent(true);
        }
    }

    private static void enablePagesCounterIfMentioned(CssStyleSheet styleSheet, CssContext cssContext) {
        if (CssStyleSheetAnalyzer.checkPagesCounterPresence(styleSheet)) {
            cssContext.setPagesCounterPresent(true);
        }
    }

    private CssStyleSheet wrapStyleSheetInMediaQueryIfNecessary(IElementNode headChildElement, CssStyleSheet styleSheet) {
        String mediaAttribute = headChildElement.getAttribute("media");
        if (mediaAttribute != null && mediaAttribute.length() > 0) {
            CssMediaRule mediaRule = new CssMediaRule(mediaAttribute);
            mediaRule.addStatementsToBody((Collection)styleSheet.getStatements());
            styleSheet = new CssStyleSheet();
            styleSheet.addStatement((CssStatement)mediaRule);
        }
        return styleSheet;
    }

    private void collectFonts() {
        for (CssStatement cssStatement : this.cssStyleSheet.getStatements()) {
            this.collectFonts(cssStatement);
        }
    }

    private void collectFonts(CssStatement cssStatement) {
        if (cssStatement instanceof CssFontFaceRule) {
            this.fonts.add((CssFontFaceRule)cssStatement);
        } else if (cssStatement instanceof CssMediaRule && ((CssMediaRule)cssStatement).matchMediaDevice(this.deviceDescription)) {
            for (CssStatement cssSubStatement : ((CssMediaRule)cssStatement).getStatements()) {
                this.collectFonts(cssSubStatement);
            }
        }
    }
}

