/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.resolver.resource;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.util.ContextMappingHelper;
import com.itextpdf.html2pdf.util.SvgProcessingUtil;
import com.itextpdf.io.codec.Base64;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.resolver.resource.IResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.processors.ISvgConverterProperties;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HtmlResourceResolver
extends ResourceResolver {
    private static final String SVG_BASE64_PREFIX = "data:image/svg+xml";
    private ProcessorContext context;

    public HtmlResourceResolver(String baseUri, ProcessorContext context) {
        this(baseUri, context, null);
    }

    public HtmlResourceResolver(String baseUri, ProcessorContext context, IResourceRetriever retriever) {
        super(baseUri, retriever);
        this.context = context;
    }

    protected PdfXObject tryResolveBase64ImageSource(String src) {
        String fixedSrc = src.replaceAll("\\s", "");
        if (fixedSrc.startsWith(SVG_BASE64_PREFIX)) {
            fixedSrc = fixedSrc.substring(fixedSrc.indexOf("base64") + 7);
            try {
                PdfFormXObject xObject = HtmlResourceResolver.processAsSvg(new ByteArrayInputStream(Base64.decode((String)fixedSrc)), this.context, null);
                if (xObject != null) {
                    return xObject;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.tryResolveBase64ImageSource(src);
    }

    protected PdfXObject createImageByUrl(URL url) throws Exception {
        try {
            return super.createImageByUrl(url);
        }
        catch (Exception ignored) {
            try (InputStream is = this.getRetriever().getInputStreamByUrl(url);){
                PdfFormXObject pdfFormXObject = is == null ? null : HtmlResourceResolver.processAsSvg(is, this.context, FileUtil.parentDirectory((URL)url));
                return pdfFormXObject;
            }
        }
    }

    private static PdfFormXObject processAsSvg(InputStream stream, ProcessorContext context, String parentDir) throws IOException {
        SvgConverterProperties svgConverterProperties = ContextMappingHelper.mapToSvgConverterProperties(context);
        if (parentDir != null) {
            svgConverterProperties.setBaseUri(parentDir);
        }
        ISvgProcessorResult res = SvgConverter.parseAndProcess((InputStream)stream, (ISvgConverterProperties)svgConverterProperties);
        if (context.getPdfDocument() != null) {
            SvgProcessingUtil processingUtil = new SvgProcessingUtil(context.getResourceResolver());
            return processingUtil.createXObjectFromProcessingResult(res, context.getPdfDocument());
        }
        return null;
    }
}

