/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.ImgTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class PTagWorker
implements ITagWorker,
IDisplayAware {
    private Paragraph lastParagraph = new Paragraph();
    private Div elementsContainer;
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public PTagWorker(IElementNode element, ProcessorContext context) {
        this.inlineHelper = new WaitingInlineElementsHelper((String)element.getStyles().get("white-space"), (String)element.getStyles().get("text-transform"));
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.lastParagraph);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (childTagWorker instanceof ImgTagWorker && "block".equals(((ImgTagWorker)childTagWorker).getDisplay())) {
            IPropertyContainer propertyContainer = childTagWorker.getElementResult();
            this.processBlockElement((IElement)((Image)propertyContainer));
            return true;
        }
        if (element instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)element);
            return true;
        }
        if (this.isBlockWithDisplay(childTagWorker, element, "inline-block", false)) {
            this.inlineHelper.add((IBlockElement)element);
            return true;
        }
        if (this.isBlockWithDisplay(childTagWorker, element, "block", false)) {
            IPropertyContainer propertyContainer = childTagWorker.getElementResult();
            this.processBlockElement((IElement)((IBlockElement)propertyContainer));
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (this.isBlockWithDisplay(childTagWorker, propertyContainer, "inline-block", true)) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                if (this.isBlockWithDisplay(childTagWorker, propertyContainer, "block", true)) {
                    this.processBlockElement((IElement)((IBlockElement)propertyContainer));
                    continue;
                }
                allChildrenProcessed = false;
            }
            return allChildrenProcessed;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return null == this.elementsContainer ? this.lastParagraph : this.elementsContainer;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private void processBlockElement(IElement propertyContainer) {
        if (this.elementsContainer == null) {
            this.elementsContainer = new Div();
            this.elementsContainer.add((IBlockElement)this.lastParagraph);
        }
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.lastParagraph);
        if (propertyContainer instanceof Image) {
            this.elementsContainer.add((Image)propertyContainer);
        } else {
            this.elementsContainer.add((IBlockElement)propertyContainer);
        }
        this.lastParagraph = new Paragraph();
        this.elementsContainer.add((IBlockElement)this.lastParagraph);
    }

    private boolean isBlockWithDisplay(ITagWorker childTagWorker, IPropertyContainer element, String displayMode, boolean isChild) {
        if (isChild) {
            return element instanceof IBlockElement && displayMode.equals(((SpanTagWorker)childTagWorker).getElementDisplay(element));
        }
        return element instanceof IBlockElement && childTagWorker instanceof IDisplayAware && displayMode.equals(((IDisplayAware)((Object)childTagWorker)).getDisplay());
    }
}

