/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProperties;
import com.itextpdf.html2pdf.attach.impl.layout.PageMarginBoxBuilder;
import com.itextpdf.html2pdf.attach.impl.layout.PageSizeParser;
import com.itextpdf.html2pdf.css.apply.impl.PageMarginBoxCssApplier;
import com.itextpdf.html2pdf.css.apply.util.BackgroundApplierUtil;
import com.itextpdf.html2pdf.css.apply.util.BorderStyleApplierUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageContextProcessor {
    private PageSize pageSize;
    private Set<String> marks;
    private Float bleed;
    private float[] margins;
    private Border[] borders;
    private float[] paddings;
    private Div pageBackgroundSimulation;
    private Div pageBordersSimulation;
    private PageContextProperties properties;
    private ProcessorContext context;
    private PageMarginBoxBuilder pageMarginBoxHelper;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageContextProcessor.class);

    PageContextProcessor(PageContextProperties properties, ProcessorContext context, PageSize defaultPageSize, float[] defaultPageMargins) {
        this.properties = properties;
        this.context = context;
        this.reset(defaultPageSize, defaultPageMargins);
    }

    private static Set<String> parseMarks(String marksStr) {
        String[] split;
        HashSet<String> marks = new HashSet<String>();
        if (marksStr == null) {
            return marks;
        }
        for (String mark : split = marksStr.split(" ")) {
            if (!"crop".equals(mark) && !"cross".equals(mark)) {
                marks.clear();
                break;
            }
            marks.add(mark);
        }
        return marks;
    }

    PageContextProcessor reset(PageSize defaultPageSize, float[] defaultPageMargins) {
        Map styles = this.properties.getResolvedPageContextNode().getStyles();
        float em = CssUtils.parseAbsoluteLength((String)((String)styles.get("font-size")));
        float rem = this.context.getCssContext().getRootFontSize();
        this.pageSize = PageSizeParser.fetchPageSize((String)styles.get("size"), em, rem, defaultPageSize);
        UnitValue bleedValue = CssUtils.parseLengthValueToPt((String)((String)styles.get("bleed")), (float)em, (float)rem);
        if (bleedValue != null && bleedValue.isPointValue()) {
            this.bleed = Float.valueOf(bleedValue.getValue());
        }
        this.marks = PageContextProcessor.parseMarks((String)styles.get("marks"));
        this.parseMargins(styles, em, rem, defaultPageMargins);
        this.parseBorders(styles, em, rem);
        this.parsePaddings(styles, em, rem);
        this.createPageSimulationElements(styles, this.context);
        this.pageMarginBoxHelper = new PageMarginBoxBuilder(this.properties.getResolvedPageMarginBoxes(), this.margins, this.pageSize);
        return this;
    }

    PageSize getPageSize() {
        return this.pageSize;
    }

    float[] computeLayoutMargins() {
        float[] layoutMargins = Arrays.copyOf(this.margins, this.margins.length);
        int i = 0;
        while (i < this.borders.length) {
            float width = this.borders[i] != null ? this.borders[i].getWidth() : 0.0f;
            int n = i++;
            layoutMargins[n] = layoutMargins[n] + width;
        }
        for (i = 0; i < this.paddings.length; ++i) {
            int n = i;
            layoutMargins[n] = layoutMargins[n] + this.paddings[i];
        }
        return layoutMargins;
    }

    void processPageEnd(int pageNum, PdfDocument pdfDocument, DocumentRenderer documentRenderer) {
        this.drawMarginBoxes(pageNum, pdfDocument, documentRenderer);
    }

    void processNewPage(PdfPage page) {
        this.setBleed(page);
        this.drawMarks(page);
        this.drawPageBackgroundAndBorders(page);
    }

    private void setBleed(PdfPage page) {
        if (this.bleed == null && !this.marks.isEmpty()) {
            this.bleed = Float.valueOf(6.0f);
        }
        if (this.bleed != null) {
            Rectangle box = page.getMediaBox();
            box.increaseHeight(this.bleed.floatValue() * 2.0f);
            box.setWidth(box.getWidth() + this.bleed.floatValue() * 2.0f);
            page.setMediaBox(box).setBleedBox(box);
            Rectangle trimBox = page.getTrimBox();
            trimBox.moveUp(this.bleed.floatValue());
            trimBox.moveRight(this.bleed.floatValue());
            page.setTrimBox(trimBox);
        }
    }

    private void drawMarks(PdfPage page) {
        if (this.marks.isEmpty()) {
            return;
        }
        float horizontalIndent = 48.0f;
        float verticalIndent = 57.0f;
        Rectangle mediaBox = page.getMediaBox();
        mediaBox.increaseHeight(verticalIndent * 2.0f);
        mediaBox.setWidth(mediaBox.getWidth() + horizontalIndent * 2.0f);
        page.setMediaBox(mediaBox);
        Rectangle bleedBox = page.getBleedBox();
        bleedBox.moveUp(verticalIndent);
        bleedBox.moveRight(horizontalIndent);
        page.setBleedBox(bleedBox);
        Rectangle trimBox = page.getTrimBox();
        trimBox.moveUp(verticalIndent);
        trimBox.moveRight(horizontalIndent);
        page.setTrimBox(trimBox);
        PdfCanvas canvas = new PdfCanvas(page);
        if (page.getDocument().isTagged()) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        if (this.marks.contains("crop")) {
            float cropLineLength = 24.0f;
            float verticalCropStartIndent = verticalIndent - cropLineLength;
            float horizontalCropStartIndent = horizontalIndent - cropLineLength;
            canvas.saveState().setLineWidth(0.1f).moveTo((double)trimBox.getLeft(), (double)verticalCropStartIndent).lineTo((double)trimBox.getLeft(), (double)verticalIndent).moveTo((double)horizontalCropStartIndent, (double)trimBox.getTop()).lineTo((double)horizontalIndent, (double)trimBox.getTop()).moveTo((double)trimBox.getRight(), (double)verticalCropStartIndent).lineTo((double)trimBox.getRight(), (double)verticalIndent).moveTo((double)(mediaBox.getWidth() - horizontalCropStartIndent), (double)trimBox.getTop()).lineTo((double)(mediaBox.getWidth() - horizontalIndent), (double)trimBox.getTop()).moveTo((double)trimBox.getLeft(), (double)(mediaBox.getHeight() - verticalCropStartIndent)).lineTo((double)trimBox.getLeft(), (double)(mediaBox.getHeight() - verticalIndent)).moveTo((double)(mediaBox.getWidth() - horizontalCropStartIndent), (double)trimBox.getBottom()).lineTo((double)(mediaBox.getWidth() - horizontalIndent), (double)trimBox.getBottom()).moveTo((double)trimBox.getRight(), (double)(mediaBox.getHeight() - verticalCropStartIndent)).lineTo((double)trimBox.getRight(), (double)(mediaBox.getHeight() - verticalIndent)).moveTo((double)horizontalCropStartIndent, (double)trimBox.getBottom()).lineTo((double)horizontalIndent, (double)trimBox.getBottom()).stroke().restoreState();
        }
        if (this.marks.contains("cross")) {
            float horCrossCenterIndent = verticalIndent - 12.0f;
            float verCrossCenterIndent = horizontalIndent - 12.0f;
            canvas.saveState().setLineWidth(0.1f);
            float x = mediaBox.getWidth() / 2.0f;
            float y = mediaBox.getHeight() - horCrossCenterIndent;
            this.drawCross(canvas, x, y, true);
            x = mediaBox.getWidth() / 2.0f;
            y = horCrossCenterIndent;
            this.drawCross(canvas, x, y, true);
            x = verCrossCenterIndent;
            y = mediaBox.getHeight() / 2.0f;
            this.drawCross(canvas, x, y, false);
            x = mediaBox.getWidth() - verCrossCenterIndent;
            y = mediaBox.getHeight() / 2.0f;
            this.drawCross(canvas, x, y, false);
            canvas.restoreState();
        }
        if (page.getDocument().isTagged()) {
            canvas.closeTag();
        }
    }

    private void drawCross(PdfCanvas canvas, float x, float y, boolean horizontalCross) {
        float yLineHalf;
        float xLineHalf;
        float circleR = 6.0f;
        if (horizontalCross) {
            xLineHalf = 30.0f;
            yLineHalf = 12.0f;
        } else {
            xLineHalf = 12.0f;
            yLineHalf = 30.0f;
        }
        canvas.moveTo((double)(x - xLineHalf), (double)y).lineTo((double)(x + xLineHalf), (double)y).moveTo((double)x, (double)(y - yLineHalf)).lineTo((double)x, (double)(y + yLineHalf));
        canvas.circle((double)x, (double)y, (double)circleR);
        canvas.stroke();
    }

    private void drawPageBackgroundAndBorders(PdfPage page) {
        Canvas canvas = new Canvas(new PdfCanvas(page), page.getDocument(), page.getBleedBox());
        canvas.enableAutoTagging(page);
        canvas.add((IBlockElement)this.pageBackgroundSimulation);
        canvas.close();
        canvas = new Canvas(new PdfCanvas(page), page.getDocument(), page.getTrimBox());
        canvas.enableAutoTagging(page);
        canvas.add((IBlockElement)this.pageBordersSimulation);
        canvas.close();
    }

    private void drawMarginBoxes(int pageNumber, PdfDocument pdfDocument, DocumentRenderer documentRenderer) {
        this.pageMarginBoxHelper.buildForSinglePage(pageNumber, pdfDocument, documentRenderer, this.context);
        if (this.pageMarginBoxHelper.getRenderers() != null) {
            for (int i = 0; i < 16; ++i) {
                if (this.pageMarginBoxHelper.getRenderers()[i] == null) continue;
                this.draw(this.pageMarginBoxHelper.getRenderers()[i], this.pageMarginBoxHelper.getNodes()[i], pdfDocument, pdfDocument.getPage(pageNumber), documentRenderer, pageNumber);
            }
        }
    }

    private void draw(IRenderer renderer, PageMarginBoxContextNode node, PdfDocument pdfDocument, PdfPage page, DocumentRenderer documentRenderer, int pageNumber) {
        IRenderer rendererToDraw;
        LayoutResult result = renderer.layout(new LayoutContext(new LayoutArea(pageNumber, node.getPageMarginBoxRectangle())));
        IRenderer iRenderer = rendererToDraw = result.getStatus() == 1 ? renderer : result.getSplitRenderer();
        if (rendererToDraw != null) {
            TagTreePointer tagPointer = null;
            TagTreePointer backupPointer = null;
            PdfPage backupPage = null;
            if (pdfDocument.isTagged()) {
                tagPointer = pdfDocument.getTagStructureContext().getAutoTaggingPointer();
                backupPage = tagPointer.getCurrentPage();
                backupPointer = new TagTreePointer(tagPointer);
                tagPointer.moveToRoot();
                tagPointer.setPageForTagging(page);
            }
            rendererToDraw.setParent((IRenderer)documentRenderer).draw(new DrawContext(page.getDocument(), new PdfCanvas(page), pdfDocument.isTagged()));
            if (pdfDocument.isTagged()) {
                tagPointer.setPageForTagging(backupPage);
                tagPointer.moveToPointer(backupPointer);
            }
        } else {
            LOGGER.error(MessageFormatUtil.format((String)"Page margin box {0} content cannot be drawn.", (Object[])new Object[]{node.getMarginBoxName()}));
        }
    }

    private void parseMargins(Map<String, String> styles, float em, float rem, float[] defaultMarginValues) {
        PageSize pageSize = this.getPageSize();
        this.margins = PageMarginBoxCssApplier.parseBoxProps(styles, em, rem, defaultMarginValues, (Rectangle)pageSize, "margin-top", "margin-right", "margin-bottom", "margin-left");
    }

    private void parsePaddings(Map<String, String> styles, float em, float rem) {
        float defaultPadding = 0.0f;
        PageSize pageSize = this.getPageSize();
        this.paddings = PageMarginBoxCssApplier.parseBoxProps(styles, em, rem, new float[]{defaultPadding, defaultPadding, defaultPadding, defaultPadding}, (Rectangle)pageSize, "padding-top", "padding-right", "padding-bottom", "padding-left");
    }

    private void parseBorders(Map<String, String> styles, float em, float rem) {
        this.borders = BorderStyleApplierUtil.getBordersArray(styles, em, rem);
    }

    private void createPageSimulationElements(Map<String, String> styles, ProcessorContext context) {
        this.pageBackgroundSimulation = new Div().setFillAvailableArea(true);
        BackgroundApplierUtil.applyBackground(styles, context, (IPropertyContainer)this.pageBackgroundSimulation);
        this.pageBackgroundSimulation.getAccessibilityProperties().setRole("Artifact");
        this.pageBordersSimulation = new Div().setFillAvailableArea(true);
        this.pageBordersSimulation.setMargins(this.margins[0], this.margins[1], this.margins[2], this.margins[3]);
        this.pageBordersSimulation.setBorderTop(this.borders[0]);
        this.pageBordersSimulation.setBorderRight(this.borders[1]);
        this.pageBordersSimulation.setBorderBottom(this.borders[2]);
        this.pageBordersSimulation.setBorderLeft(this.borders[3]);
        this.pageBordersSimulation.getAccessibilityProperties().setRole("Artifact");
    }
}

