/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve;

import com.itextpdf.html2pdf.css.page.PageMarginRunningElementNode;
import com.itextpdf.html2pdf.css.resolve.CssContentElementNode;
import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.css.resolve.func.counter.CssCounterManager;
import com.itextpdf.html2pdf.css.resolve.func.counter.PageCountElementNode;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.page.PageMarginBoxContextNode;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.pseudo.CssPseudoElementNode;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.css.resolve.CssQuotes;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CssContentPropertyResolver {
    private static final Logger logger = LoggerFactory.getLogger(CssContentPropertyResolver.class);

    CssContentPropertyResolver() {
    }

    static List<INode> resolveContent(Map<String, String> styles, INode contentContainer, CssContext context) {
        CssDeclarationValueTokenizer.Token token;
        String contentStr = styles.get("content");
        ArrayList<INode> result = new ArrayList<INode>();
        if (contentStr == null || "none".equals(contentStr) || "normal".equals(contentStr)) {
            return null;
        }
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(contentStr);
        CssQuotes quotes = null;
        while ((token = tokenizer.getNextValidToken()) != null) {
            String counterName;
            String[] params;
            if (token.isString()) {
                result.add((INode)new ContentTextNode(contentContainer, token.getValue()));
                continue;
            }
            if (token.getValue().startsWith("counters(")) {
                String paramsStr = token.getValue().substring("counters".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                if (params.length == 0) {
                    return CssContentPropertyResolver.errorFallback(contentStr);
                }
                counterName = params[0].trim();
                String counterSeparationStr = params[1].trim();
                counterSeparationStr = counterSeparationStr.substring(1, counterSeparationStr.length() - 1);
                String listStyleType = params.length > 2 ? params[2].trim() : null;
                CssCounterManager counterManager = context.getCounterManager();
                INode scope = contentContainer;
                if ("page".equals(counterName)) {
                    result.add((INode)new PageCountElementNode(false, contentContainer));
                    continue;
                }
                if ("pages".equals(counterName)) {
                    result.add((INode)new PageCountElementNode(true, contentContainer));
                    continue;
                }
                String resolvedCounter = counterManager.resolveCounters(counterName, counterSeparationStr, listStyleType, scope);
                if (resolvedCounter == null) {
                    logger.error(MessageFormatUtil.format((String)"Unable to resolve counter \"{0}\"", (Object[])new Object[]{counterName}));
                    continue;
                }
                result.add((INode)new ContentTextNode(scope, resolvedCounter));
                continue;
            }
            if (token.getValue().startsWith("counter(")) {
                String paramsStr = token.getValue().substring("counter".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                if (params.length == 0) {
                    return CssContentPropertyResolver.errorFallback(contentStr);
                }
                counterName = params[0].trim();
                String listStyleType = params.length > 1 ? params[1].trim() : null;
                CssCounterManager counterManager = context.getCounterManager();
                INode scope = contentContainer;
                if ("page".equals(counterName)) {
                    result.add((INode)new PageCountElementNode(false, contentContainer));
                    continue;
                }
                if ("pages".equals(counterName)) {
                    result.add((INode)new PageCountElementNode(true, contentContainer));
                    continue;
                }
                String resolvedCounter = counterManager.resolveCounter(counterName, listStyleType, scope);
                if (resolvedCounter == null) {
                    logger.error(MessageFormatUtil.format((String)"Unable to resolve counter \"{0}\"", (Object[])new Object[]{counterName}));
                    continue;
                }
                result.add((INode)new ContentTextNode(scope, resolvedCounter));
                continue;
            }
            if (token.getValue().startsWith("url(")) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("src", CssUtils.extractUrl((String)token.getValue()));
                attributes.put("style", "display:inline-block");
                result.add((INode)new CssContentElementNode(contentContainer, "img", attributes));
                continue;
            }
            if (token.getValue().startsWith("attr(") && contentContainer instanceof CssPseudoElementNode) {
                int endBracket = token.getValue().indexOf(41);
                if (endBracket <= 5) continue;
                String attrName = token.getValue().substring(5, endBracket);
                if (attrName.contains("(") || attrName.contains(" ") || attrName.contains("'") || attrName.contains("\"")) {
                    return CssContentPropertyResolver.errorFallback(contentStr);
                }
                IElementNode element = (IElementNode)contentContainer.parentNode();
                String value = element.getAttribute(attrName);
                result.add((INode)new ContentTextNode(contentContainer, value == null ? "" : value));
                continue;
            }
            if (token.getValue().endsWith("quote") && contentContainer instanceof IStylesContainer) {
                String value;
                if (quotes == null) {
                    quotes = CssQuotes.createQuotes((String)styles.get("quotes"), (boolean)true);
                }
                if ((value = quotes.resolveQuote(token.getValue(), (AbstractCssContext)context)) == null) {
                    return CssContentPropertyResolver.errorFallback(contentStr);
                }
                result.add((INode)new ContentTextNode(contentContainer, value));
                continue;
            }
            if (token.getValue().startsWith("element(") && contentContainer instanceof PageMarginBoxContextNode) {
                String paramsStr = token.getValue().substring("element".length() + 1, token.getValue().length() - 1);
                params = paramsStr.split(",");
                if (params.length == 0) {
                    return CssContentPropertyResolver.errorFallback(contentStr);
                }
                String name = params[0].trim();
                String runningElementOccurrence = null;
                if (params.length > 1) {
                    runningElementOccurrence = params[1].trim();
                }
                result.add(new PageMarginRunningElementNode(name, runningElementOccurrence));
                continue;
            }
            return CssContentPropertyResolver.errorFallback(contentStr);
        }
        return result;
    }

    private static List<INode> errorFallback(String contentStr) {
        Logger logger = LoggerFactory.getLogger(CssContentPropertyResolver.class);
        int logMessageParameterMaxLength = 100;
        if (contentStr.length() > logMessageParameterMaxLength) {
            contentStr = contentStr.substring(0, logMessageParameterMaxLength) + ".....";
        }
        logger.error(MessageFormatUtil.format((String)"Content property \"{0}\" is either invalid or uses unsupported function.", (Object[])new Object[]{contentStr}));
        return null;
    }

    private static class ContentTextNode
    implements ITextNode {
        private final INode parent;
        private String content;

        ContentTextNode(INode parent, String content) {
            this.parent = parent;
            this.content = content;
        }

        public List<INode> childNodes() {
            return Collections.emptyList();
        }

        public void addChild(INode node) {
            throw new UnsupportedOperationException();
        }

        public INode parentNode() {
            return this.parent;
        }

        public String wholeText() {
            return this.content;
        }
    }
}

