/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.AbstractSelectField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.ComboBoxField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.ListBoxField;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.OptGroupTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.OptionTagWorker;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;

public class SelectTagWorker
implements ITagWorker,
IDisplayAware {
    private AbstractSelectField selectElement;
    private String display;

    public SelectTagWorker(IElementNode element, ProcessorContext context) {
        String name = context.getFormFieldNameResolver().resolveFormName(element.getAttribute("name"));
        boolean multipleAttr = element.getAttribute("multiple") != null;
        Integer sizeAttr = CssUtils.parseInteger(element.getAttribute("size"));
        int size = this.getSelectSize(sizeAttr, multipleAttr);
        this.selectElement = size > 1 || multipleAttr ? new ListBoxField(name, size, multipleAttr) : new ComboBoxField(name);
        this.selectElement.setProperty(0x100003, !context.isCreateAcroForm());
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return content == null || content.trim().isEmpty();
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        if ((childTagWorker instanceof OptionTagWorker || childTagWorker instanceof OptGroupTagWorker) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.selectElement.addOption((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.selectElement;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private int getSelectSize(Integer size, boolean multiple) {
        if (size != null && size > 0) {
            return size;
        }
        return multiple ? 4 : 1;
    }
}

