/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.Button;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.CheckBox;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.InputField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.Radio;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTagWorker
implements ITagWorker,
IDisplayAware {
    private IElement formElement;
    private String display;

    public InputTagWorker(IElementNode element, ProcessorContext context) {
        String inputType = element.getAttribute("type");
        String value = element.getAttribute("value");
        String name = context.getFormFieldNameResolver().resolveFormName(element.getAttribute("name"));
        if (inputType == null || "text".equals(inputType) || "email".equals(inputType) || "password".equals(inputType) || "number".equals(inputType)) {
            Integer size = CssUtils.parseInteger(element.getAttribute("size"));
            this.formElement = new InputField(name);
            this.formElement.setProperty(0x100005, (Object)InputTagWorker.preprocessInputValue(value, inputType));
            this.formElement.setProperty(0x100004, (Object)size);
            if ("password".equals(inputType)) {
                this.formElement.setProperty(0x100006, (Object)true);
            }
        } else if ("submit".equals(inputType) || "button".equals(inputType)) {
            this.formElement = new Button(name);
            this.formElement.setProperty(0x100005, (Object)value);
        } else if ("checkbox".equals(inputType)) {
            this.formElement = new CheckBox(name);
            String checked = element.getAttribute("checked");
            if (null != checked) {
                this.formElement.setProperty(0x100009, (Object)checked);
            }
        } else if ("radio".equals(inputType)) {
            this.formElement = new Radio(name);
            String radioGroupName = element.getAttribute("name");
            this.formElement.setProperty(0x100005, (Object)radioGroupName);
            String checked = element.getAttribute("checked");
            if (null != checked) {
                context.getRadioCheckResolver().checkField(radioGroupName, (Radio)this.formElement);
                this.formElement.setProperty(0x100009, (Object)checked);
            }
        } else {
            Logger logger = LoggerFactory.getLogger(InputTagWorker.class);
            logger.error(MessageFormatUtil.format((String)"Input type {0} is not supported", (Object[])new Object[]{inputType}));
        }
        if (this.formElement != null) {
            this.formElement.setProperty(0x100003, (Object)(!context.isCreateAcroForm() ? 1 : 0));
        }
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.formElement;
    }

    private static String preprocessInputValue(String value, String inputType) {
        if ("number".equals(inputType) && value != null && !value.matches("[0-9.]*")) {
            value = "";
        }
        return value;
    }
}

