/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.SpanWrapper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpanTagWorker
implements ITagWorker,
IDisplayAware {
    SpanWrapper spanWrapper;
    private Map<IPropertyContainer, String> childrenDisplayMap = new HashMap<IPropertyContainer, String>();
    private List<IPropertyContainer> elements;
    private List<IPropertyContainer> ownLeafElements = new ArrayList<IPropertyContainer>();
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public SpanTagWorker(IElementNode element, ProcessorContext context) {
        this.spanWrapper = new SpanWrapper();
        Map<String, String> styles = element.getStyles();
        this.inlineHelper = new WaitingInlineElementsHelper(styles == null ? null : styles.get("white-space"), styles == null ? null : styles.get("text-transform"));
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.inlineHelper.getWaitingLeaves().isEmpty() && this.spanWrapper.getElements().isEmpty()) {
            this.inlineHelper.add("");
        }
        this.flushInlineHelper();
        this.elements = this.spanWrapper.getElements();
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (element instanceof ILeafElement) {
            this.flushInlineHelper();
            this.spanWrapper.add((ILeafElement)element);
            this.ownLeafElements.add(element);
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            this.flushInlineHelper();
            this.spanWrapper.add(((SpanTagWorker)childTagWorker).spanWrapper);
            this.childrenDisplayMap.putAll(((SpanTagWorker)childTagWorker).childrenDisplayMap);
            return true;
        }
        if (childTagWorker.getElementResult() instanceof IBlockElement) {
            if (childTagWorker instanceof IDisplayAware) {
                String display = ((IDisplayAware)((Object)childTagWorker)).getDisplay();
                this.childrenDisplayMap.put(childTagWorker.getElementResult(), display);
            }
            this.flushInlineHelper();
            this.spanWrapper.add((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        return false;
    }

    public List<IPropertyContainer> getAllElements() {
        return this.elements;
    }

    public List<IPropertyContainer> getOwnLeafElements() {
        return this.ownLeafElements;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return null;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    String getElementDisplay(IPropertyContainer child) {
        return this.childrenDisplayMap.get(child);
    }

    private void flushInlineHelper() {
        this.spanWrapper.addAll(this.inlineHelper.getWaitingLeaves());
        this.ownLeafElements.addAll(this.inlineHelper.getWaitingLeaves());
        this.inlineHelper.clearWaitingLeaves();
    }
}

