/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.Transform;
import com.itextpdf.layout.property.UnitValue;
import java.util.Map;

public class TransformationApplierUtil {
    private TransformationApplierUtil() {
    }

    public static void applyTransformation(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        if (cssProps.get("transform") == null) {
            return;
        }
        String transformationFunction = cssProps.get("transform").toLowerCase();
        String[] components = transformationFunction.split("\\)");
        Transform multipleFunction = new Transform(components.length);
        for (String component : components) {
            multipleFunction.addSingleTransform(TransformationApplierUtil.parseSingleFunction(component));
        }
        element.setProperty(106, (Object)multipleFunction);
    }

    private static Transform.SingleTransform parseSingleFunction(String transformationFunction) {
        String[] arg;
        if ("none".equals(transformationFunction)) {
            return TransformationApplierUtil.getSingleTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        String function = transformationFunction.substring(0, transformationFunction.indexOf(40)).trim();
        String args = transformationFunction.substring(transformationFunction.indexOf(40) + 1);
        if ("matrix".equals(function) && (arg = args.split(",")).length == 6) {
            float[] matrix = new float[6];
            for (int i = 0; i < 6; ++i) {
                matrix[i] = i == 4 || i == 5 ? CssUtils.parseAbsoluteLength(arg[i].trim()) : Float.parseFloat(arg[i].trim());
                if (i != 1 && i != 2 && i != 5) continue;
                int n = i;
                matrix[n] = matrix[n] * -1.0f;
            }
            return TransformationApplierUtil.getSingleTransform(matrix);
        }
        if ("translate".equals(function)) {
            float x;
            arg = args.split(",");
            boolean yPoint = true;
            float y = 0.0f;
            boolean xPoint = arg[0].indexOf(37) < 0;
            float f = x = xPoint ? CssUtils.parseAbsoluteLength(arg[0].trim()) : Float.parseFloat(arg[0].trim().substring(0, arg[0].indexOf(37)));
            if (arg.length == 2) {
                yPoint = arg[1].indexOf(37) < 0;
                y = -1.0f * (yPoint ? CssUtils.parseAbsoluteLength(arg[1].trim()) : Float.parseFloat(arg[1].trim().substring(0, arg[1].indexOf(37))));
            }
            return TransformationApplierUtil.getSingleTransformTranslate(1.0f, 0.0f, 0.0f, 1.0f, x, y, xPoint, yPoint);
        }
        if ("translatex".equals(function)) {
            boolean xPoint = args.indexOf(37) < 0;
            float x = xPoint ? CssUtils.parseAbsoluteLength(args.trim()) : Float.parseFloat(args.trim().substring(0, args.indexOf(37)));
            return TransformationApplierUtil.getSingleTransformTranslate(1.0f, 0.0f, 0.0f, 1.0f, x, 0.0f, xPoint, true);
        }
        if ("translatey".equals(function)) {
            boolean yPoint = args.indexOf(37) < 0;
            float y = -1.0f * (yPoint ? CssUtils.parseAbsoluteLength(args.trim()) : Float.parseFloat(args.trim().substring(0, args.indexOf(37))));
            return TransformationApplierUtil.getSingleTransformTranslate(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, y, true, yPoint);
        }
        if ("rotate".equals(function)) {
            double angleInRad = TransformationApplierUtil.parseAngleToRadians(args);
            float cos = (float)Math.cos(angleInRad);
            float sin = (float)Math.sin(angleInRad);
            return TransformationApplierUtil.getSingleTransform(cos, sin, -1.0f * sin, cos, 0.0f, 0.0f);
        }
        if ("skew".equals(function)) {
            arg = args.split(",");
            double xAngleInRad = TransformationApplierUtil.parseAngleToRadians(arg[0]);
            double yAngleInRad = arg.length == 2 ? TransformationApplierUtil.parseAngleToRadians(arg[1]) : 0.0;
            float tanX = (float)Math.tan(xAngleInRad);
            float tanY = (float)Math.tan(yAngleInRad);
            return TransformationApplierUtil.getSingleTransform(1.0f, tanY, tanX, 1.0f, 0.0f, 0.0f);
        }
        if ("skewx".equals(function)) {
            float tanX = (float)Math.tan(TransformationApplierUtil.parseAngleToRadians(args));
            return TransformationApplierUtil.getSingleTransform(1.0f, 0.0f, tanX, 1.0f, 0.0f, 0.0f);
        }
        if ("skewy".equals(function)) {
            float tanY = (float)Math.tan(TransformationApplierUtil.parseAngleToRadians(args));
            return TransformationApplierUtil.getSingleTransform(1.0f, tanY, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        if ("scale".equals(function)) {
            float y;
            float x;
            arg = args.split(",");
            if (arg.length == 2) {
                x = Float.parseFloat(arg[0].trim());
                y = Float.parseFloat(arg[1].trim());
            } else {
                y = x = Float.parseFloat(arg[0].trim());
            }
            return TransformationApplierUtil.getSingleTransform(x, 0.0f, 0.0f, y, 0.0f, 0.0f);
        }
        if ("scalex".equals(function)) {
            float x = Float.parseFloat(args.trim());
            return TransformationApplierUtil.getSingleTransform(x, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        if ("scaley".equals(function)) {
            float y = Float.parseFloat(args.trim());
            return TransformationApplierUtil.getSingleTransform(1.0f, 0.0f, 0.0f, y, 0.0f, 0.0f);
        }
        return new Transform.SingleTransform();
    }

    private static double parseAngleToRadians(String value) {
        if (value.indexOf(100) < 0) {
            return 0.0;
        }
        if (value.indexOf(114) > 0) {
            return -1.0 * Double.parseDouble(value.trim().substring(0, value.indexOf(114)));
        }
        return Math.toRadians(-1.0 * Double.parseDouble(value.trim().substring(0, value.indexOf(100))));
    }

    private static Transform.SingleTransform getSingleTransformTranslate(float a, float b, float c, float d, float tx, float ty, boolean xPoint, boolean yPoint) {
        return new Transform.SingleTransform(a, b, c, d, new UnitValue(xPoint ? 1 : 2, tx), new UnitValue(yPoint ? 1 : 2, ty));
    }

    private static Transform.SingleTransform getSingleTransform(float a, float b, float c, float d, float tx, float ty) {
        return new Transform.SingleTransform(a, b, c, d, new UnitValue(1, tx), new UnitValue(1, ty));
    }

    private static Transform.SingleTransform getSingleTransform(float[] floats) {
        return new Transform.SingleTransform(floats[0], floats[1], floats[2], floats[3], new UnitValue(1, floats[4]), new UnitValue(1, floats[5]));
    }
}

