/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.html2pdf.css.resolve.CssDefaults;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.ColorConstants;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.DashedBorder;
import com.itextpdf.layout.border.DottedBorder;
import com.itextpdf.layout.border.DoubleBorder;
import com.itextpdf.layout.border.GrooveBorder;
import com.itextpdf.layout.border.InsetBorder;
import com.itextpdf.layout.border.OutsetBorder;
import com.itextpdf.layout.border.RidgeBorder;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.property.UnitValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderStyleApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BorderStyleApplierUtil.class);

    private BorderStyleApplierUtil() {
    }

    public static void applyBorders(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        UnitValue radius;
        float rem;
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        Border[] bordersArray = BorderStyleApplierUtil.getBordersArray(cssProps, em, rem = context.getCssContext().getRootFontSize());
        if (bordersArray[0] != null) {
            element.setProperty(13, (Object)bordersArray[0]);
        }
        if (bordersArray[1] != null) {
            element.setProperty(12, (Object)bordersArray[1]);
        }
        if (bordersArray[2] != null) {
            element.setProperty(10, (Object)bordersArray[2]);
        }
        if (bordersArray[3] != null) {
            element.setProperty(11, (Object)bordersArray[3]);
        }
        if (null != (radius = BorderStyleApplierUtil.getBorderRadius(cssProps, em, rem))) {
            element.setProperty(101, (Object)radius);
        }
    }

    public static Border[] getBordersArray(Map<String, String> styles, float em, float rem) {
        Border leftBorder;
        Border bottomBorder;
        Border rightBorder;
        Border topBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-top-width"), styles.get("border-top-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-top-color"), em, rem);
        Border[] borders = new Border[]{topBorder, rightBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-right-width"), styles.get("border-right-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-right-color"), em, rem), bottomBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-bottom-width"), styles.get("border-bottom-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-bottom-color"), em, rem), leftBorder = BorderStyleApplierUtil.getCertainBorder(styles.get("border-left-width"), styles.get("border-left-style"), BorderStyleApplierUtil.getSpecificBorderColorOrDefaultColor(styles, "border-left-color"), em, rem)};
        return borders;
    }

    public static Border getCertainBorder(String borderWidth, String borderStyle, String borderColor, float em, float rem) {
        UnitValue unitValue;
        if (borderStyle == null || "none".equals(borderStyle)) {
            return null;
        }
        if (borderWidth == null) {
            borderWidth = CssDefaults.getDefaultValue("border-width");
        }
        if (CssConstants.BORDER_WIDTH_VALUES.contains(borderWidth)) {
            if ("thin".equals(borderWidth)) {
                borderWidth = "1px";
            } else if ("medium".equals(borderWidth)) {
                borderWidth = "2px";
            } else if ("thick".equals(borderWidth)) {
                borderWidth = "3px";
            }
        }
        if ((unitValue = CssUtils.parseLengthValueToPt(borderWidth, em, rem)) == null) {
            return null;
        }
        if (unitValue.isPercentValue()) {
            LOGGER.error("border-width in percents is not supported");
            return null;
        }
        float borderWidthValue = unitValue.getValue();
        SolidBorder border = null;
        if (borderWidthValue > 0.0f) {
            DeviceRgb color = (DeviceRgb)ColorConstants.BLACK;
            float opacity = 1.0f;
            if (borderColor != null) {
                if (!"transparent".equals(borderColor)) {
                    float[] rgbaColor = CssUtils.parseRgbaColor(borderColor);
                    color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
                    opacity = rgbaColor[3];
                } else {
                    opacity = 0.0f;
                }
            } else if ("groove".equals(borderStyle) || "ridge".equals(borderStyle) || "inset".equals(borderStyle) || "outset".equals(borderStyle)) {
                color = new DeviceRgb(212, 208, 200);
            }
            switch (borderStyle) {
                case "solid": {
                    border = new SolidBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "dashed": {
                    border = new DashedBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "dotted": {
                    border = new DottedBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "double": {
                    border = new DoubleBorder((Color)color, borderWidthValue, opacity);
                    break;
                }
                case "groove": {
                    border = new GrooveBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "ridge": {
                    border = new RidgeBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "inset": {
                    border = new InsetBorder(color, borderWidthValue, opacity);
                    break;
                }
                case "outset": {
                    border = new OutsetBorder(color, borderWidthValue, opacity);
                    break;
                }
                default: {
                    border = null;
                }
            }
        }
        return border;
    }

    public static UnitValue getBorderRadius(Map<String, String> styles, float em, float rem) {
        String borderRadius = styles.get("border-radius");
        return CssUtils.parseLengthValueToPt(borderRadius, em, rem);
    }

    private static String getSpecificBorderColorOrDefaultColor(Map<String, String> styles, String specificBorderColorProperty) {
        String borderColor = styles.get(specificBorderColorProperty);
        if (borderColor == null) {
            borderColor = styles.get("color");
        }
        return borderColor;
    }
}

