/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.ILeafElement;

public class LinkHelper {
    private LinkHelper() {
    }

    public static void applyLinkAnnotation(IPropertyContainer container, String url) {
        if (container != null) {
            PdfLinkAnnotation linkAnnotation;
            if (url.startsWith("#")) {
                String name = url.substring(1);
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createGoTo((String)name)).setFlags(4);
            } else {
                linkAnnotation = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setAction(PdfAction.createURI((String)url)).setFlags(4);
            }
            linkAnnotation.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
            container.setProperty(88, (Object)linkAnnotation);
            if (container instanceof ILeafElement && container instanceof IAccessibleElement) {
                ((IAccessibleElement)container).setRole(PdfName.Link);
            }
        }
    }

    public static void createDestination(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        if (element.getAttribute("id") == null) {
            return;
        }
        if (tagWorker == null) {
            return;
        }
        IPropertyContainer propertyContainer = tagWorker.getElementResult();
        if (propertyContainer == null) {
            return;
        }
        String id = element.getAttribute("id");
        if (context.getLinkContext().isUsedLinkDestination(id)) {
            propertyContainer.setProperty(17, (Object)id);
        }
    }
}

