/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.Attacher;
import com.itextpdf.html2pdf.exception.Html2PdfException;
import com.itextpdf.html2pdf.html.impl.jsoup.JsoupHtmlParser;
import com.itextpdf.html2pdf.html.node.IDocumentNode;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.IElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

public class HtmlConverter {
    private HtmlConverter() {
    }

    public static void convertToPdf(String html, OutputStream pdfStream) throws IOException {
        HtmlConverter.convertToPdf(html, pdfStream, null);
    }

    public static void convertToPdf(String html, OutputStream pdfStream, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(html, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter) throws IOException {
        HtmlConverter.convertToPdf(html, pdfWriter, null);
    }

    public static void convertToPdf(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(html, new PdfDocument(pdfWriter), converterProperties);
    }

    public static void convertToPdf(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        Document document = HtmlConverter.convertToDocument(html, pdfDocument, converterProperties);
        document.close();
    }

    public static void convertToPdf(File htmlFile, File pdfFile) throws IOException {
        HtmlConverter.convertToPdf(htmlFile, pdfFile, null);
    }

    public static void convertToPdf(File htmlFile, File pdfFile, ConverterProperties converterProperties) throws IOException {
        if (converterProperties == null) {
            converterProperties = new ConverterProperties().setBaseUri(FileUtil.getParentDirectory((String)htmlFile.getAbsolutePath()) + File.separator);
        } else if (converterProperties.getBaseUri() == null) {
            converterProperties = new ConverterProperties(converterProperties).setBaseUri(FileUtil.getParentDirectory((String)htmlFile.getAbsolutePath()) + File.separator);
        }
        try (FileInputStream fileInputStream = new FileInputStream(htmlFile.getAbsolutePath());
             FileOutputStream fileOutputStream = new FileOutputStream(pdfFile.getAbsolutePath());){
            HtmlConverter.convertToPdf((InputStream)fileInputStream, (OutputStream)fileOutputStream, converterProperties);
        }
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfStream, null);
    }

    public static void convertToPdf(InputStream htmlStream, OutputStream pdfStream, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfWriter(pdfStream), converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, pdfDocument, null);
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfDocument(pdfWriter));
    }

    public static void convertToPdf(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        HtmlConverter.convertToPdf(htmlStream, new PdfDocument(pdfWriter), converterProperties);
    }

    public static void convertToPdf(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        Document document = HtmlConverter.convertToDocument(htmlStream, pdfDocument, converterProperties);
        document.close();
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter) throws IOException {
        return HtmlConverter.convertToDocument(html, pdfWriter, null);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, pdfWriter, null);
    }

    public static Document convertToDocument(String html, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        return HtmlConverter.convertToDocument(html, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfWriter pdfWriter, ConverterProperties converterProperties) throws IOException {
        return HtmlConverter.convertToDocument(htmlStream, new PdfDocument(pdfWriter), converterProperties);
    }

    public static Document convertToDocument(String html, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        block3: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block3;
                throw new RuntimeException(e.getCause());
            }
        }
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static Document convertToDocument(InputStream htmlStream, PdfDocument pdfDocument, ConverterProperties converterProperties) throws IOException {
        block3: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block3;
                throw new RuntimeException(e.getCause());
            }
        }
        if (pdfDocument.getReader() != null) {
            throw new Html2PdfException("PdfDocument should be created in writing mode. Reading and stamping is not allowed");
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties != null ? converterProperties.getCharset() : null);
        return Attacher.attach(doc, pdfDocument, converterProperties);
    }

    public static List<IElement> convertToElements(String html) throws IOException {
        return HtmlConverter.convertToElements(html, null);
    }

    public static List<IElement> convertToElements(InputStream htmlStream) throws IOException {
        return HtmlConverter.convertToElements(htmlStream, null);
    }

    public static List<IElement> convertToElements(String html, ConverterProperties converterProperties) throws IOException {
        block2: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block2;
                throw new RuntimeException(e.getCause());
            }
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(html);
        return Attacher.attach(doc, converterProperties);
    }

    public static List<IElement> convertToElements(InputStream htmlStream, ConverterProperties converterProperties) throws IOException {
        block2: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block2;
                throw new RuntimeException(e.getCause());
            }
        }
        JsoupHtmlParser parser = new JsoupHtmlParser();
        IDocumentNode doc = parser.parse(htmlStream, converterProperties != null ? converterProperties.getCharset() : null);
        return Attacher.attach(doc, converterProperties);
    }
}

