/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PushButtonFormFieldBuilder;
import com.itextpdf.forms.form.element.Button;
import com.itextpdf.forms.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonRenderer
extends AbstractOneLineTextFieldRenderer {
    private static final float DEFAULT_Y_OFFSET = 4.0f;
    private static final float RELATIVE_PADDING_FOR_SMALL_SIZES = 0.15f;
    private boolean isSplit = false;

    public ButtonRenderer(Button modelElement) {
        super(modelElement);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        float lowestChildBottom;
        float deltaY;
        if (((Button)this.modelElement).isSingleLine()) {
            ParagraphRenderer renderer = (ParagraphRenderer)this.flatRenderer.getChildRenderers().get(0);
            List flatLines = renderer.getLines();
            Rectangle buttonBBox = this.getOccupiedArea().getBBox();
            Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
            this.updatePdfFont(renderer);
            if (flatLines.isEmpty() || this.font == null) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form field with type {0}.", (Object[])new Object[]{"button"}));
                this.setProperty(0x200001, true);
                flatBBox.setY(flatBBox.getTop()).setHeight(0.0f);
            } else {
                if (flatLines.size() != 1) {
                    this.isSplit = true;
                }
                this.cropContentLines(flatLines, flatBBox);
                Float width = this.retrieveWidth(layoutContext.getArea().getBBox().getWidth());
                if (width == null) {
                    LineRenderer drawnLine = (LineRenderer)flatLines.get(0);
                    drawnLine.move(flatBBox.getX() - drawnLine.getOccupiedArea().getBBox().getX(), 0.0f);
                    flatBBox.setWidth(drawnLine.getOccupiedArea().getBBox().getWidth());
                    buttonBBox.setWidth(flatBBox.getWidth() + 2.0f * (flatBBox.getX() - buttonBBox.getX()));
                }
            }
        } else if (this.getProperty(75) == null && (deltaY = (lowestChildBottom = this.getLowestChildBottom(this.flatRenderer, this.flatRenderer.getOccupiedArea().getBBox().getBottom())) - this.getInnerAreaBBox().getY()) > 0.0f) {
            this.flatRenderer.move(0.0f, -deltaY / 2.0f);
        }
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    protected Float getLastYLineRecursively() {
        return super.getFirstYLineRecursively();
    }

    @Override
    protected IRenderer createFlatRenderer() {
        Float height;
        Div div = new Div();
        for (IElement child : ((Button)this.modelElement).getChildren()) {
            if (child instanceof Image) {
                div.add((Image)child);
            } else {
                div.add((IBlockElement)child);
            }
            child.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        }
        this.setProperty(82, Boolean.TRUE);
        this.setProperty(104, OverflowPropertyValue.VISIBLE);
        if (((Button)this.modelElement).isSingleLine()) {
            this.setProperty(118, Boolean.TRUE);
        }
        if ((height = this.retrieveHeight()) == null) {
            UnitValue[] paddings;
            float buttonPadding = 4.0f;
            if (this.getProperty(24) != null) {
                float fontSize = ((UnitValue)this.getProperty(24)).getValue();
                buttonPadding = Math.min(4.0f, 0.15f * fontSize);
            }
            if ((paddings = this.getPaddings())[0] == null || paddings[0].getValue() == 0.0f) {
                this.setProperty(50, UnitValue.createPointValue((float)buttonPadding));
            }
            if (paddings[2] == null || paddings[2].getValue() == 0.0f) {
                this.setProperty(47, UnitValue.createPointValue((float)buttonPadding));
            }
        }
        return div.createRendererSubTree();
    }

    public IRenderer getNextRenderer() {
        return new ButtonRenderer((Button)this.modelElement);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected boolean isRendererFit(float availableWidth, float availableHeight) {
        return !this.isSplit && super.isRendererFit(availableWidth, availableHeight);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(ButtonRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        this.applyMargins(area, false);
        this.deleteMargins();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        Background background = (Background)this.getProperty(6);
        Color backgroundColor = background == null ? null : background.getColor();
        float fontSizeValue = fontSize.getValue();
        if (this.font == null) {
            this.font = doc.getDefaultFont();
        }
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        PdfButtonFormField button = ((PushButtonFormFieldBuilder)new PushButtonFormFieldBuilder(doc, name).setWidgetRectangle(area)).createPushButton();
        button.disableFieldRegeneration();
        button.setFont(this.font).setFontSize(fontSizeValue);
        button.getFirstFormAnnotation().setBackgroundColor(backgroundColor);
        this.applyDefaultFieldProperties(button);
        button.getFirstFormAnnotation().setFormFieldElement((Button)this.modelElement);
        button.enableFieldRegeneration();
        PdfAcroForm forms = PdfFormCreator.getAcroForm(doc, true);
        forms.addField(button, page);
        this.writeAcroFormFieldLangAttribute(doc);
    }

    @Override
    void setContentHeight(IRenderer flatRenderer, float height) {
        UnitValue[] margins;
        UnitValue[] paddings;
        Rectangle bBox = flatRenderer.getOccupiedArea().getBBox();
        Border border = this.getBorders()[0];
        if (border != null) {
            height += border.getWidth() * 2.0f;
        }
        if ((paddings = this.getPaddings())[0] != null) {
            height += paddings[0].getValue();
        }
        if (paddings[2] != null) {
            height += paddings[2].getValue();
        }
        if ((margins = this.getMargins())[0] != null) {
            height += margins[0].getValue();
        }
        if (margins[2] != null) {
            height += margins[2].getValue();
        }
        float newY = this.getOccupiedArea().getBBox().getBottom() + height / 2.0f - bBox.getHeight() / 2.0f;
        float dy = bBox.getBottom() - newY;
        bBox.moveDown(dy);
        bBox.setHeight(height);
        flatRenderer.move(0.0f, -dy);
    }

    private float getLowestChildBottom(IRenderer renderer, float value) {
        float lowestChildBottom = value;
        for (IRenderer child : renderer.getChildRenderers()) {
            lowestChildBottom = this.getLowestChildBottom(child, lowestChildBottom);
            if (child.getOccupiedArea() == null || !(child.getOccupiedArea().getBBox().getBottom() < lowestChildBottom)) continue;
            lowestChildBottom = child.getOccupiedArea().getBBox().getBottom();
        }
        return lowestChildBottom;
    }
}

