/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.forms.form.element.FormField;
import com.itextpdf.forms.form.renderer.CheckBoxRenderer;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckBox
extends FormField<CheckBox> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckBox.class);

    public CheckBox(String id) {
        super(id);
        this.setProperty(105, BoxSizingPropertyValue.BORDER_BOX);
        this.setChecked(false);
    }

    public CheckBox setChecked(boolean checked) {
        this.setProperty(0x200007, checked);
        return this;
    }

    public CheckBox setPdfAConformanceLevel(PdfAConformanceLevel conformanceLevel) {
        this.setProperty(0x20000F, conformanceLevel);
        return this;
    }

    public CheckBox setCheckBoxType(CheckBoxType checkBoxType) {
        if (checkBoxType == null) {
            LOGGER.warn(MessageFormatUtil.format((String)"Value '{0}': <{1}> invalid. Default value will be used.", (Object[])new Object[]{"checkBoxType", null}));
            return this;
        }
        this.setProperty(0x20000E, (Object)checkBoxType);
        return this;
    }

    @Override
    public CheckBox setSize(float size) {
        if (size <= 0.0f) {
            LOGGER.warn(MessageFormatUtil.format((String)"Value '{0}': <{1}> invalid. Default value will be used.", (Object[])new Object[]{"size", Float.valueOf(size)}));
            return this;
        }
        this.setProperty(77, UnitValue.createPointValue((float)size));
        this.setProperty(27, UnitValue.createPointValue((float)size));
        return this;
    }

    protected IRenderer makeNewRenderer() {
        return new CheckBoxRenderer(this);
    }
}

