/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.forms.fields.TextAndChoiceLegacyDrawer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;

public class ChoiceFormFieldBuilder
extends TerminalFormFieldBuilder<ChoiceFormFieldBuilder> {
    private PdfArray options = null;

    public ChoiceFormFieldBuilder(PdfDocument document, String formFieldName) {
        super(document, formFieldName);
    }

    public PdfArray getOptions() {
        return this.options;
    }

    public ChoiceFormFieldBuilder setOptions(PdfArray options) {
        this.options = options;
        return this;
    }

    public ChoiceFormFieldBuilder setOptions(String[] options) {
        return this.setOptions(ChoiceFormFieldBuilder.processOptions(options));
    }

    public ChoiceFormFieldBuilder setOptions(String[][] options) {
        return this.setOptions(ChoiceFormFieldBuilder.processOptions(options));
    }

    public PdfChoiceFormField createList() {
        return this.createChoice(0);
    }

    public PdfChoiceFormField createComboBox() {
        return this.createChoice(PdfChoiceFormField.FF_COMBO);
    }

    @Override
    protected ChoiceFormFieldBuilder getThis() {
        return this;
    }

    private PdfChoiceFormField createChoice(int flags) {
        PdfChoiceFormField field;
        PdfWidgetAnnotation annotation = null;
        if (this.getWidgetRectangle() == null) {
            field = new PdfChoiceFormField(this.getDocument());
        } else {
            annotation = new PdfWidgetAnnotation(this.getWidgetRectangle());
            if (null != this.getConformanceLevel()) {
                annotation.setFlag(4);
            }
            field = new PdfChoiceFormField(annotation, this.getDocument());
        }
        field.pdfAConformanceLevel = this.getConformanceLevel();
        field.setFieldFlags(flags);
        field.setFieldName(this.getFormFieldName());
        if (this.options == null) {
            field.put(PdfName.Opt, (PdfObject)new PdfArray());
            field.setListSelected(new String[0], false);
        } else {
            field.put(PdfName.Opt, (PdfObject)this.options);
            field.setListSelected(new String[0], false);
            String optionsArrayString = "";
            if ((flags & PdfChoiceFormField.FF_COMBO) == 0) {
                optionsArrayString = PdfFormField.optionsArrayToString(this.options);
            }
            if (annotation != null) {
                PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, this.getWidgetRectangle().getWidth(), this.getWidgetRectangle().getHeight()));
                TextAndChoiceLegacyDrawer.drawChoiceAppearance(field.getFirstFormAnnotation(), this.getWidgetRectangle(), field.fontSize, optionsArrayString, xObject, 0);
                annotation.setNormalAppearance((PdfDictionary)xObject.getPdfObject());
                this.setPageToField(field);
            }
        }
        return field;
    }

    private static PdfArray processOptions(String[][] options) {
        PdfArray array = new PdfArray();
        for (String[] option : options) {
            if (option.length != 2) {
                throw new IllegalArgumentException("Inner arrays shall have exactly two elements");
            }
            PdfArray subArray = new PdfArray((PdfObject)new PdfString(option[0], "UnicodeBig"));
            subArray.add((PdfObject)new PdfString(option[1], "UnicodeBig"));
            array.add((PdfObject)subArray);
        }
        return array;
    }

    private static PdfArray processOptions(String[] options) {
        PdfArray array = new PdfArray();
        for (String option : options) {
            array.add((PdfObject)new PdfString(option, "UnicodeBig"));
        }
        return array;
    }
}

